/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0.0lf + dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)) => dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)
 * (0.0lf + dvec3(1.67lf, 0.66lf, 1.87lf)) => dvec3(1.67lf, 0.66lf, 1.87lf)
 * (-1.3333333333333333lf + dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)) => dvec3(-2.6666666666666665lf, -2.183333333333333lf, -2.2733333333333334lf)
 * (-1.3333333333333333lf + dvec3(1.67lf, 0.66lf, 1.87lf)) => dvec3(0.33666666666666667lf, -0.6733333333333332lf, 0.5366666666666668lf)
 * (0.85lf + dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)) => dvec3(-0.4833333333333333lf, 0.0lf, -0.08999999999999997lf)
 * (0.85lf + dvec3(1.67lf, 0.66lf, 1.87lf)) => dvec3(2.52lf, 1.51lf, 2.72lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance((0.0lf + dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)), dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)) <= 1.839531945299613e-05lf ? 1 : -1] array0;
  double[distance((0.0lf + dvec3(1.67lf, 0.66lf, 1.87lf)), dvec3(1.67lf, 0.66lf, 1.87lf)) <= 2.5925662961629354e-05lf ? 1 : -1] array1;
  double[distance((-1.3333333333333333lf + dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)), dvec3(-2.6666666666666665lf, -2.183333333333333lf, -2.2733333333333334lf)) <= 4.128692286911196e-05lf ? 1 : -1] array2;
  double[distance((-1.3333333333333333lf + dvec3(1.67lf, 0.66lf, 1.87lf)), dvec3(0.33666666666666667lf, -0.6733333333333332lf, 0.5366666666666668lf)) <= 9.245178923813933e-06lf ? 1 : -1] array3;
  double[distance((0.85lf + dvec3(-1.3333333333333333lf, -0.85lf, -0.94lf)), dvec3(-0.4833333333333333lf, 0.0lf, -0.08999999999999997lf)) <= 4.916412422804977e-06lf ? 1 : -1] array4;
  double[distance((0.85lf + dvec3(1.67lf, 0.66lf, 1.87lf)), dvec3(2.52lf, 1.51lf, 2.72lf)) <= 4.003610870202049e-05lf ? 1 : -1] array5;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
