/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.gotosource.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileFilter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.graalvm.visualvm.core.options.UISupport;
import org.graalvm.visualvm.core.ui.components.SectionSeparator;
import org.graalvm.visualvm.gotosource.SourcesRoot;
import org.graalvm.visualvm.gotosource.SourcesViewer;
import org.graalvm.visualvm.gotosource.impl.SourceRoots;
import org.graalvm.visualvm.gotosource.impl.SourceViewers;
import org.graalvm.visualvm.gotosource.options.Bundle;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.swing.SmallButton;
import org.openide.awt.Mnemonics;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

final class SourcesOptionsPanel
extends JPanel {
    private static final String PROP_LAST_SOURCES_DIR = "prop_SourcesOptionsPanel_lastDir";
    private DefaultListModel<String> rootsListModel;
    private JList<String> rootsList;
    private JButton addButton;
    private JButton removeButton;
    private JButton upButton;
    private JButton downButton;
    private JLabel rootsForcedHint;
    private JComboBox<SourcesViewer> viewerSelector;
    private JLabel viewerDescription;
    private JPanel viewerSettings;
    private JLabel viewerForcedHint;

    SourcesOptionsPanel() {
        this.initUI();
    }

    void load(Preferences settings) {
        this.rootsForcedHint.setVisible(SourceRoots.areForcedRoots());
        this.rootsListModel = new DefaultListModel();
        for (String root : SourceRoots.getRoots()) {
            this.rootsListModel.addElement(root);
        }
        this.rootsList.setModel(this.rootsListModel);
        this.rootsList.setEnabled(!this.rootsForcedHint.isVisible());
        this.updateRootsButtons();
        this.viewerForcedHint.setVisible(SourceViewers.isForcedViewer());
        Collection<? extends SourcesViewer> viewers = SourceViewers.getRegisteredViewers();
        this.viewerSelector.setModel(new DefaultComboBoxModel<SourcesViewer>(viewers.toArray(new SourcesViewer[0])));
        this.viewerSelector.setEnabled(!this.viewerForcedHint.isVisible());
        SourcesViewer selected = SourceViewers.getSelectedViewer();
        if (selected == null && !viewers.isEmpty()) {
            selected = viewers.iterator().next();
            SourceViewers.saveSelectedViewer(selected);
        }
        for (int i = 0; i < this.viewerSelector.getItemCount(); ++i) {
            this.viewerSelector.getItemAt(i).loadSettings();
        }
        if (selected != null) {
            this.viewerSelector.setSelectedItem(selected);
            this.viewerSelected(selected);
        }
    }

    void save(Preferences settings) {
        if (!SourceRoots.areForcedRoots()) {
            SourceRoots.saveRoots(this.getDefinedRoots());
        }
        if (!SourceViewers.isForcedViewer()) {
            SourceViewers.saveSelectedViewer(this.getSelectedViewer());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < SourcesOptionsPanel.this.viewerSelector.getItemCount(); ++i) {
                        ((SourcesViewer)SourcesOptionsPanel.this.viewerSelector.getItemAt(i)).saveSettings();
                    }
                }
            });
        }
    }

    void cancel() {
    }

    boolean dirty(Preferences settings) {
        Object[] currentStrings;
        Object[] definedStrings;
        if (!SourceRoots.areForcedRoots() && !Arrays.equals(definedStrings = SourceRoots.getRoots(), currentStrings = this.getDefinedRoots())) {
            return true;
        }
        if (!SourceViewers.isForcedViewer()) {
            String currentlySelectedViewerID;
            SourcesViewer selectedViewer = SourceViewers.getSelectedViewer();
            String selectedViewerID = selectedViewer == null ? null : selectedViewer.getID();
            SourcesViewer currentlySelectedViewer = this.getSelectedViewer();
            String string = currentlySelectedViewerID = currentlySelectedViewer == null ? null : currentlySelectedViewer.getID();
            if (!Objects.equals(selectedViewerID, currentlySelectedViewerID)) {
                return true;
            }
            for (int i = 0; i < this.viewerSelector.getItemCount(); ++i) {
                if (!this.viewerSelector.getItemAt(i).settingsDirty()) continue;
                return true;
            }
        }
        return false;
    }

    private String[] getDefinedRoots() {
        Object[] roots = new String[this.rootsListModel.size()];
        this.rootsListModel.copyInto(roots);
        return roots;
    }

    private SourcesViewer getSelectedViewer() {
        return (SourcesViewer)this.viewerSelector.getSelectedItem();
    }

    private void viewerSelected(SourcesViewer viewer) {
        this.viewerDescription.setText(viewer.getDescription());
        this.viewerSettings.removeAll();
        JComponent settingsComponent = viewer.getSettingsComponent();
        if (settingsComponent != null) {
            this.viewerSettings.add((Component)settingsComponent, "North");
        }
        this.validate();
        this.repaint();
    }

    private void updateRootsButtons() {
        if (this.rootsForcedHint.isVisible()) {
            this.addButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        } else {
            int[] selectedRows = this.rootsList.getSelectedIndices();
            int selectedRow = selectedRows.length == 1 ? selectedRows[0] : -1;
            this.addButton.setEnabled(true);
            this.removeButton.setEnabled(selectedRows.length > 0);
            if (selectedRow == -1) {
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
            } else {
                Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                this.upButton.setEnabled(selectedRow > 0);
                this.downButton.setEnabled(selectedRow < this.rootsListModel.size() - 1);
                if (this.upButton == focusOwner && !this.upButton.isEnabled() && this.downButton.isEnabled()) {
                    this.downButton.requestFocusInWindow();
                } else if (this.downButton == focusOwner && !this.downButton.isEnabled() && this.upButton.isEnabled()) {
                    this.upButton.requestFocusInWindow();
                }
            }
        }
    }

    private void initUI() {
        this.setLayout(new GridBagLayout());
        int y = 0;
        int htab = 15;
        int vgap = 5;
        SectionSeparator definitionsSection = UISupport.createSectionSeparator((String)Bundle.SourcesOptionsPanel_DefinitionsCaption());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 0;
        c.fill = 2;
        c.insets = new Insets(0, 0, vgap * 3, 0);
        this.add((Component)definitionsSection, c);
        JLabel definitionsCaption = new JLabel();
        Mnemonics.setLocalizedText((JLabel)definitionsCaption, (String)Bundle.SourcesOptionsPanel_Sources());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y++;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(0, htab, vgap, 0);
        this.add((Component)definitionsCaption, c);
        this.rootsListModel = new DefaultListModel();
        this.rootsList = new JList<String>(this.rootsListModel);
        this.rootsList.setVisibleRowCount(0);
        definitionsCaption.setLabelFor(this.rootsList);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y++;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 5;
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(0, htab, vgap * 3, 0);
        this.add((Component)new JScrollPane(this.rootsList), c);
        this.addButton = new SmallButton(Icons.getIcon((String)"GeneralIcons.Add")){
            {
                this.setToolTipText(Bundle.SourcesOptionsPanel_Add());
            }

            protected void fireActionPerformed(ActionEvent e) {
                File lastDir;
                super.fireActionPerformed(e);
                JFileChooser fileChooser = new JFileChooser((String)null);
                fileChooser.setDialogTitle(Bundle.SourcesOptionsPanel_SelectRootsCaption());
                fileChooser.setApproveButtonText(Bundle.SourcesOptionsPanel_SelectButton());
                fileChooser.setMultiSelectionEnabled(true);
                fileChooser.setFileSelectionMode(2);
                fileChooser.setAcceptAllFileFilterUsed(false);
                fileChooser.addChoosableFileFilter(new javax.swing.filechooser.FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().endsWith(".zip") || f.getName().endsWith(".jar");
                    }

                    @Override
                    public String getDescription() {
                        return Bundle.SourcesOptionsPanel_SourceDirectoriesFilter() + " (*.zip, *.jar)";
                    }
                });
                String aFile = System.getProperties().getProperty("netbeans.home");
                Icon fileIcon = fileChooser.getIcon(new File(aFile));
                SourceRootsCustomizer customizer = new SourceRootsCustomizer(fileIcon);
                fileChooser.setAccessory(customizer);
                fileChooser.addPropertyChangeListener("SelectedFilesChangedProperty", customizer);
                String lastDirS = NbPreferences.forModule(SourcesOptionsPanel.class).get(SourcesOptionsPanel.PROP_LAST_SOURCES_DIR, null);
                File file = lastDir = lastDirS == null ? null : new File(lastDirS);
                if (lastDir != null && lastDir.isDirectory()) {
                    fileChooser.setCurrentDirectory(lastDir);
                }
                if (fileChooser.showOpenDialog(WindowManager.getDefault().getMainWindow()) == 0) {
                    String first = null;
                    String firstC = null;
                    for (File selected : fileChooser.getSelectedFiles()) {
                        String path = selected.getAbsolutePath();
                        String pathC = customizer.createRootString(path);
                        if (first == null) {
                            first = path;
                            firstC = pathC;
                        }
                        if (SourcesOptionsPanel.this.rootsListModel.contains(pathC)) continue;
                        SourcesOptionsPanel.this.rootsListModel.addElement(pathC);
                    }
                    if (first != null) {
                        String dirS;
                        SourcesOptionsPanel.this.rootsList.setSelectedValue(firstC, true);
                        File dir = new File(first).getParentFile();
                        String string = dirS = dir.isDirectory() ? dir.getAbsolutePath() : null;
                        if (dirS != null) {
                            NbPreferences.forModule(SourcesOptionsPanel.class).put(SourcesOptionsPanel.PROP_LAST_SOURCES_DIR, dirS);
                        }
                    }
                }
            }
        };
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = y++;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(0, htab, 0, 0);
        this.add((Component)this.addButton, c);
        this.removeButton = new SmallButton(Icons.getIcon((String)"GeneralIcons.Remove")){
            {
                this.setToolTipText(Bundle.SourcesOptionsPanel_Delete());
            }

            protected void fireActionPerformed(ActionEvent e) {
                for (Object selected : SourcesOptionsPanel.this.rootsList.getSelectedValuesList()) {
                    SourcesOptionsPanel.this.rootsListModel.removeElement(selected);
                }
            }
        };
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = y++;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(0, htab, vgap * 2, 0);
        this.add((Component)this.removeButton, c);
        final boolean[] internalSelectionChange = new boolean[]{false};
        this.upButton = new SmallButton(Icons.getIcon((String)"GeneralIcons.Up")){
            {
                super(x0);
                this.setToolTipText(Bundle.SourcesOptionsPanel_MoveUp());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void fireActionPerformed(ActionEvent e) {
                int selected = SourcesOptionsPanel.this.rootsList.getSelectedIndex();
                if (selected < 1) {
                    return;
                }
                String selectedRoot = (String)SourcesOptionsPanel.this.rootsListModel.get(selected);
                internalSelectionChange[0] = true;
                try {
                    SourcesOptionsPanel.this.rootsListModel.remove(selected);
                    SourcesOptionsPanel.this.rootsListModel.add(selected - 1, selectedRoot);
                }
                finally {
                    internalSelectionChange[0] = false;
                }
                SourcesOptionsPanel.this.rootsList.setSelectedValue(selectedRoot, true);
            }
        };
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = y++;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(0, htab, 0, 0);
        this.add((Component)this.upButton, c);
        this.downButton = new SmallButton(Icons.getIcon((String)"GeneralIcons.Down")){
            {
                super(x0);
                this.setToolTipText(Bundle.SourcesOptionsPanel_MoveDown());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void fireActionPerformed(ActionEvent e) {
                int selected = SourcesOptionsPanel.this.rootsList.getSelectedIndex();
                if (selected == -1 || selected > SourcesOptionsPanel.this.rootsListModel.size() - 2) {
                    return;
                }
                String selectedRoot = (String)SourcesOptionsPanel.this.rootsListModel.get(selected);
                internalSelectionChange[0] = true;
                try {
                    SourcesOptionsPanel.this.rootsListModel.remove(selected);
                    SourcesOptionsPanel.this.rootsListModel.add(selected + 1, selectedRoot);
                }
                finally {
                    internalSelectionChange[0] = false;
                }
                SourcesOptionsPanel.this.rootsList.setSelectedValue(selectedRoot, true);
            }
        };
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = y++;
        c.anchor = 18;
        c.fill = 2;
        c.insets = new Insets(0, htab, 0, 0);
        this.add((Component)this.downButton, c);
        this.rootsForcedHint = new JLabel(Bundle.SourcesOptionsPanel_ForcedRoots(), Icons.getIcon((String)"GeneralIcons.Info"), 10);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 0;
        c.fill = 2;
        c.insets = new Insets(-vgap, htab, vgap * 3, 0);
        this.add((Component)this.rootsForcedHint, c);
        SectionSeparator gotoSection = UISupport.createSectionSeparator((String)Bundle.SourcesOptionsPanel_ViewerCaption());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 0;
        c.fill = 2;
        c.insets = new Insets(0, 0, vgap * 3, 0);
        this.add((Component)gotoSection, c);
        final JPanel chooserPanel = new JPanel(new GridBagLayout());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(0, htab, vgap * 2, 0);
        this.add((Component)chooserPanel, c);
        JLabel openInLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)openInLabel, (String)Bundle.SourcesOptionsPanel_OpenIn());
        chooserPanel.add(openInLabel);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, vgap);
        chooserPanel.add((Component)openInLabel, c);
        this.viewerSelector = new JComboBox();
        openInLabel.setLabelFor(this.viewerSelector);
        this.viewerSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SourcesOptionsPanel.this.viewerSelected((SourcesViewer)e.getItem());
                }
            }
        });
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, htab);
        chooserPanel.add(this.viewerSelector, c);
        this.viewerDescription = new JLabel();
        this.viewerDescription.setEnabled(false);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 0;
        c.weightx = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        chooserPanel.add((Component)this.viewerDescription, c);
        this.viewerSettings = new JPanel(new BorderLayout()){

            @Override
            public Dimension getMinimumSize() {
                Dimension dim = super.getMinimumSize();
                dim.height = this.getPreferredSize().height;
                return dim;
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.height = Math.max(dim.height, chooserPanel.getPreferredSize().height + 10);
                return dim;
            }
        };
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y++;
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(0, htab, 0, 0);
        this.add((Component)this.viewerSettings, c);
        this.viewerForcedHint = new JLabel(Bundle.SourcesOptionsPanel_ForcedViewer(), Icons.getIcon((String)"GeneralIcons.Info"), 10);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 0;
        c.fill = 2;
        c.insets = new Insets(0, htab, 0, 0);
        this.add((Component)this.viewerForcedHint, c);
        ListSelectionListener selection = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!internalSelectionChange[0] && !e.getValueIsAdjusting()) {
                    SourcesOptionsPanel.this.updateRootsButtons();
                }
            }
        };
        this.rootsList.addListSelectionListener(selection);
        this.updateRootsButtons();
    }

    private static final class SourceRootsCustomizer
    extends JPanel
    implements PropertyChangeListener {
        private static final String PREDEFINED_JDKSRC_DIR1 = "java.base";
        private static final String PREDEFINED_JDKSRC_DIR2 = "java.se";
        private static final String PREDEFINED_SRC_DIR = "src";
        private RequestProcessor processor;
        private JRadioButton selectedFolderChoice;
        private JRadioButton commonFolderChoice;
        private JRadioButton customFolderChoice;
        private JList<String> subdirectoryList;
        private JTextField customFolderField;
        private JComboBox<Object> encodingSelector;

        SourceRootsCustomizer(Icon fileIcon) {
            super(null);
            this.initUI(fileIcon);
        }

        String createRootString(String root) {
            String[] subpaths = this.commonFolderChoice.isSelected() ? this.subdirectoryList.getSelectedValuesList().toArray(new String[0]) : (this.customFolderChoice.isSelected() ? this.customFolderField.getText().trim().replace(File.separator, "/").replace(File.pathSeparator, ":").split(":") : null);
            String encoding = this.encodingSelector.getEditor().getItem().toString().trim();
            return SourcesRoot.createString(root, subpaths, encoding);
        }

        private void initUI(Icon fileIcon) {
            this.setLayout(new GridBagLayout());
            int y = 0;
            int htab = 15;
            int vgap = 5;
            SectionSeparator foldersSection = UISupport.createSectionSeparator((String)Bundle.SourcesOptionsPanel_SourcesLocation());
            foldersSection.setFont(foldersSection.getFont().deriveFont(0));
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = y++;
            c.gridwidth = 0;
            c.fill = 2;
            c.insets = new Insets(0, htab, htab - vgap, vgap);
            this.add((Component)foldersSection, c);
            this.selectedFolderChoice = new JRadioButton();
            Mnemonics.setLocalizedText((AbstractButton)this.selectedFolderChoice, (String)Bundle.SourcesOptionsPanel_SelectedRootsChoice());
            this.selectedFolderChoice.setToolTipText(Bundle.SourcesOptionsPanel_SelectedRootsToolTip());
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = y++;
            c.gridwidth = 0;
            c.fill = 2;
            c.insets = new Insets(0, htab, vgap, vgap);
            this.add((Component)this.selectedFolderChoice, c);
            int htab2 = htab + 16 + this.selectedFolderChoice.getIconTextGap();
            this.commonFolderChoice = new JRadioButton();
            Mnemonics.setLocalizedText((AbstractButton)this.commonFolderChoice, (String)Bundle.SourcesOptionsPanel_SubdirectoriesChoice());
            this.commonFolderChoice.setToolTipText(Bundle.SourcesOptionsPanel_SubdirectoriesToolTip());
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = y++;
            c.gridwidth = 0;
            c.fill = 2;
            c.insets = new Insets(0, htab, 0, vgap);
            this.add((Component)this.commonFolderChoice, c);
            this.subdirectoryList = new JList();
            DefaultListCellRenderer renderer = new DefaultListCellRenderer(){

                @Override
                public void setIcon(Icon icon) {
                    if (icon != null) {
                        super.setIcon(icon);
                    }
                }
            };
            renderer.setIcon(fileIcon);
            this.subdirectoryList.setCellRenderer(renderer);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = y++;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridwidth = 0;
            c.fill = 1;
            c.insets = new Insets(0, htab2, htab - vgap, vgap);
            this.add((Component)new JScrollPane(this.subdirectoryList), c);
            this.customFolderChoice = new JRadioButton();
            Mnemonics.setLocalizedText((AbstractButton)this.customFolderChoice, (String)Bundle.SourcesOptionsPanel_CustomSubpathsChoice());
            this.customFolderChoice.setToolTipText(Bundle.SourcesOptionsPanel_CustomSubpathsToolTip("*modules*"));
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = y++;
            c.gridwidth = 0;
            c.fill = 2;
            c.insets = new Insets(0, htab, 0, vgap);
            this.add((Component)this.customFolderChoice, c);
            this.customFolderField = new JTextField();
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = y++;
            c.gridwidth = 0;
            c.fill = 2;
            c.insets = new Insets(0, htab2, htab + vgap, vgap);
            this.add((Component)this.customFolderField, c);
            SectionSeparator encodingSection = UISupport.createSectionSeparator((String)Bundle.SourcesOptionsPanel_SourcesEncoding());
            encodingSection.setFont(foldersSection.getFont());
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = y++;
            c.gridwidth = 0;
            c.fill = 2;
            c.insets = new Insets(0, htab, htab - vgap, vgap);
            this.add((Component)encodingSection, c);
            this.encodingSelector = new JComboBox<Object>(Charset.availableCharsets().keySet().toArray());
            this.encodingSelector.setSelectedItem(StandardCharsets.UTF_8.name());
            this.encodingSelector.setEditable(true);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = y++;
            c.fill = 2;
            c.insets = new Insets(0, htab2, htab + vgap, vgap);
            this.add(this.encodingSelector, c);
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.selectedFolderChoice);
            bg.add(this.commonFolderChoice);
            bg.add(this.customFolderChoice);
            this.selectedFolderChoice.setSelected(true);
            this.subdirectoryList.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    commonFolderChoice.setSelected(true);
                }
            });
            this.customFolderField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    customFolderChoice.setSelected(true);
                }
            });
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            boolean empty = this.subdirectoryList.getModel().getSize() == 0;
            final List<String> selected = empty ? null : this.subdirectoryList.getSelectedValuesList();
            this.subdirectoryList.setEnabled(false);
            final File[] subdirs = (File[])evt.getNewValue();
            if (this.processor == null) {
                this.processor = new RequestProcessor("Source Roots Subfoldes Processor");
            }
            this.processor.post(new Runnable(){

                @Override
                public void run() {
                    final List subdirsL = SourceRootsCustomizer.getCommonSubDirs(subdirs);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            subdirectoryList.setListData(subdirsL.toArray(new String[0]));
                            subdirectoryList.setEnabled(true);
                            if (selected != null && !selected.isEmpty()) {
                                ArrayList<Integer> sel = new ArrayList<Integer>();
                                ListModel model = subdirectoryList.getModel();
                                for (int i = 0; i < model.getSize(); ++i) {
                                    if (!selected.contains(model.getElementAt(i))) continue;
                                    sel.add(i);
                                }
                                int[] selidx = new int[sel.size()];
                                for (int i = 0; i < selidx.length; ++i) {
                                    selidx[i] = (Integer)sel.get(i);
                                }
                                subdirectoryList.setSelectedIndices(selidx);
                            }
                            if (subdirectoryList.getSelectedValue() == null) {
                                if (subdirsL.contains(SourceRootsCustomizer.PREDEFINED_JDKSRC_DIR1) && subdirsL.contains(SourceRootsCustomizer.PREDEFINED_JDKSRC_DIR2)) {
                                    subdirectoryList.setSelectionInterval(0, subdirectoryList.getModel().getSize() - 1);
                                } else if (subdirsL.contains(SourceRootsCustomizer.PREDEFINED_SRC_DIR)) {
                                    subdirectoryList.setSelectedValue(SourceRootsCustomizer.PREDEFINED_SRC_DIR, false);
                                }
                            }
                        }
                    });
                }
            });
        }

        private static List<String> getCommonSubDirs(File[] roots) {
            if (roots == null || roots.length == 0) {
                return Collections.emptyList();
            }
            List<String> subdirs = null;
            for (File root : roots) {
                List<String> rootSubdirs = SourceRootsCustomizer.getSubDirs(root);
                Collections.sort(rootSubdirs);
                if (subdirs == null) {
                    subdirs = rootSubdirs;
                    continue;
                }
                subdirs.retainAll(rootSubdirs);
            }
            return subdirs == null ? Collections.emptyList() : subdirs;
        }

        private static List<String> getSubDirs(File root) {
            if (root.isDirectory()) {
                return SourceRootsCustomizer.getFolderSubDirs(root);
            }
            if (root.isFile()) {
                return SourceRootsCustomizer.getArchiveSubDirs(root);
            }
            return Collections.emptyList();
        }

        private static List<String> getFolderSubDirs(File root) {
            File[] rootSubdirsF;
            ArrayList<String> rootSubdirs = new ArrayList<String>();
            for (File f : rootSubdirsF = root.listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory();
                }
            })) {
                rootSubdirs.add(f.getName());
            }
            return rootSubdirs;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static List<String> getArchiveSubDirs(File root) {
            try (FileSystem archiveFileSystem = FileSystems.newFileSystem(root.toPath(), (ClassLoader)null);){
                Path archive = archiveFileSystem.getRootDirectories().iterator().next();
                List subfolders = Files.walk(archive, 1, new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toList());
                ArrayList<String> rootSubDirs = new ArrayList<String>();
                for (Path path : subfolders) {
                    rootSubDirs.add(path.toString().replace("/", ""));
                }
                rootSubDirs.remove(0);
                ArrayList<String> arrayList = rootSubDirs;
                return arrayList;
            }
            catch (Exception e) {
                return Collections.emptyList();
            }
        }
    }
}

