/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.Popup;
import jalview.Sequence;
import jalview.ThresholdPanel;
import java.awt.Component;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.TextComponent;
import java.util.Vector;

public class RedundancyPopup
extends Popup {
    ThresholdPanel tp;

    public RedundancyPopup(Frame frame, String string, String string2, int n, int n2, int n3) {
        super(frame, string);
        this.tp = new ThresholdPanel(frame, string2, n, n2, n3);
        this.status.setText("Enter the redundancy threshold");
        this.gbc.fill = 0;
        this.gbc.insets = new Insets(20, 20, 20, 20);
        this.add(this.tp, this.gb, this.gbc, 0, 0, 2, 1);
        this.add(this.status, this.gb, this.gbc, 0, 1, 2, 1);
        this.add(this.apply, this.gb, this.gbc, 0, 2, 1, 1);
        this.add(this.close, this.gb, this.gbc, 1, 2, 1, 1);
        this.pack();
        this.show();
    }

    public boolean handleEvent(Event event) {
        if (event.target == this.apply && event.id == 1001) {
            int n = 0;
            try {
                n = Integer.valueOf(this.tp.tf.getText());
            }
            catch (Exception exception) {
                n = this.tp.sb.getValue();
                ((TextComponent)this.tp.tf).setText(new Integer(n).toString());
            }
            System.out.println("Threshold = " + n);
            System.out.println(this.parent);
            if (this.parent instanceof AlignFrame) {
                AlignFrame alignFrame = (AlignFrame)this.parent;
                alignFrame.status.setText("Removing redundancy...");
                alignFrame.status.validate();
                if (alignFrame.ap.sel != null && alignFrame.ap.sel.size() != 0) {
                    System.out.println("Sel = " + alignFrame.ap.sel);
                    if (alignFrame.ap.sel.size() == 1) {
                        alignFrame.status.setText("ERROR: Only one sequence selected");
                        alignFrame.status.validate();
                    } else {
                        this.status.setText("Removing redundancy for " + alignFrame.ap.sel.size() + " sequences");
                        Vector vector = alignFrame.ap.seqPanel.align.removeRedundancy(n, alignFrame.ap.sel);
                        int n2 = 0;
                        while (n2 < vector.size()) {
                            if (alignFrame.ap.sel.contains(vector.elementAt(n2))) {
                                alignFrame.ap.sel.removeElement(vector.elementAt(n2));
                            }
                            ++n2;
                        }
                    }
                } else {
                    System.out.println("Creating vector");
                    Vector<Sequence> vector = new Vector<Sequence>();
                    int n3 = 0;
                    while (n3 < alignFrame.ap.seqPanel.align.sequences.length && alignFrame.ap.seqPanel.align.sequences[n3] != null) {
                        vector.addElement(alignFrame.ap.seqPanel.align.sequences[n3]);
                        ++n3;
                    }
                    System.out.println("Removing redundancy for " + vector.size() + " sequences");
                    Vector vector2 = alignFrame.ap.seqPanel.align.removeRedundancy(n, vector);
                    int n4 = 0;
                    while (n4 < vector2.size()) {
                        alignFrame.status.setText("Removing sequence " + ((Sequence)vector2.elementAt(n4)).getName());
                        alignFrame.status.validate();
                        if (alignFrame.ap.sel.contains(vector2.elementAt(n4))) {
                            alignFrame.ap.sel.removeElement(vector2.elementAt(n4));
                        }
                        ++n4;
                    }
                }
                alignFrame.status.setText("Done");
                alignFrame.updateFont();
            }
            return true;
        }
        if (event.target == this.close && event.id == 1001) {
            ((Component)this).hide();
            this.dispose();
            return true;
        }
        return super.handleEvent(event);
    }
}

