/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.smali;

import com.googlecode.d2j.DexLabel;
import com.googlecode.d2j.node.DexCodeNode;
import com.googlecode.d2j.reader.Op;
import com.googlecode.d2j.visitors.DexCodeVisitor;
import java.util.ArrayList;
import java.util.List;

public class SmaliCodeVisitor
extends DexCodeNode {
    private List<DexCodeNode.DexStmtNode> needCareStmts = new ArrayList<DexCodeNode.DexStmtNode>();

    public SmaliCodeVisitor(DexCodeVisitor visitor) {
        super(visitor);
    }

    public void visitConstStmt(Op op, int ra, Object value) {
        switch (op) {
            case CONST_WIDE_16: {
                short v = ((Number)value).shortValue();
                super.visitConstStmt(op, ra, (Object)v);
                break;
            }
            case CONST_WIDE_HIGH16: {
                short v = ((Number)value).shortValue();
                super.visitConstStmt(op, ra, (Object)((long)v << 48));
                break;
            }
            case CONST_WIDE_32: {
                int v = ((Number)value).intValue();
                super.visitConstStmt(op, ra, (Object)v);
                break;
            }
            case CONST_HIGH16: {
                int v = ((Number)value).intValue();
                super.visitConstStmt(op, ra, (Object)(v << 16));
                break;
            }
            default: {
                super.visitConstStmt(op, ra, value);
            }
        }
    }

    public void visitEnd() {
        if (this.visitor != null) {
            super.accept(this.visitor);
        }
        this.needCareStmts = null;
        this.stmts = null;
        this.tryStmts = null;
        super.visitEnd();
    }

    private void addCare(DexCodeNode.DexStmtNode stmt) {
        this.needCareStmts.add(stmt);
        super.add(stmt);
    }

    void dArrayData(int length, byte[] obj) {
        this.addCare(new ArrayDataStmt(length, obj));
    }

    void dPackedSwitch(int first, DexLabel[] labels) {
        this.addCare(new PackedSwitchStmt(first, labels));
    }

    void dSparseSwitch(int[] cases, DexLabel[] labels) {
        this.addCare(new SparseSwitchStmt(cases, labels));
    }

    int findLabelIndex(DexLabel label) {
        int labelIndex = -1;
        int i = 0;
        while (i < this.needCareStmts.size()) {
            DexCodeNode.DexStmtNode s = this.needCareStmts.get(i);
            if (s instanceof DexCodeNode.DexLabelStmtNode) {
                DexCodeNode.DexLabelStmtNode ss = (DexCodeNode.DexLabelStmtNode)s;
                if (ss.label == label) {
                    labelIndex = i;
                }
            }
            ++i;
        }
        return labelIndex;
    }

    void visitF31tStmt(final Op op, final int reg, final DexLabel label) {
        this.add(new DexCodeNode.DexStmtNode(){

            public void accept(DexCodeVisitor cv) {
                int labelIndex = SmaliCodeVisitor.this.findLabelIndex(label);
                if (labelIndex < 0 || labelIndex >= SmaliCodeVisitor.this.needCareStmts.size()) {
                    throw new RuntimeException("can't find label for " + op + " " + label);
                }
                switch (op) {
                    case PACKED_SWITCH: {
                        PackedSwitchStmt packedSwitchStmt = (PackedSwitchStmt)((Object)SmaliCodeVisitor.this.needCareStmts.get(labelIndex + 1));
                        cv.visitPackedSwitchStmt(op, reg, packedSwitchStmt.firstCase, packedSwitchStmt.labels);
                        break;
                    }
                    case SPARSE_SWITCH: {
                        SparseSwitchStmt sparseSwitchStmt = (SparseSwitchStmt)((Object)SmaliCodeVisitor.this.needCareStmts.get(labelIndex + 1));
                        cv.visitSparseSwitchStmt(op, reg, sparseSwitchStmt.cases, sparseSwitchStmt.labels);
                        break;
                    }
                    case FILL_ARRAY_DATA: {
                        Object[] v;
                        ArrayDataStmt arrayDataStmt = (ArrayDataStmt)((Object)SmaliCodeVisitor.this.needCareStmts.get(labelIndex + 1));
                        byte[] vs = arrayDataStmt.objs;
                        switch (arrayDataStmt.length) {
                            case 1: {
                                v = vs;
                                break;
                            }
                            case 2: {
                                short[] vs1 = new short[vs.length / 2];
                                int i = 0;
                                while (i < vs1.length) {
                                    vs1[i] = (short)(vs[i * 2] & 0xFF | (vs[i * 2 + 1] & 0xFF) << 8);
                                    ++i;
                                }
                                v = vs1;
                                break;
                            }
                            case 4: {
                                int[] vs1 = new int[vs.length / 4];
                                int i = 0;
                                while (i < vs1.length) {
                                    int base = i * 4;
                                    vs1[i] = vs[base + 0] & 0xFF | (vs[base + 1] & 0xFF) << 8 | (vs[base + 2] & 0xFF) << 16 | (vs[base + 3] & 0xFF) << 24;
                                    ++i;
                                }
                                v = vs1;
                                break;
                            }
                            case 8: {
                                long[] vs1 = new long[vs.length / 8];
                                int i = 0;
                                while (i < vs1.length) {
                                    int base = i * 8;
                                    int a = (vs[base + 0] & 0xFF) << 0 | (vs[base + 1] & 0xFF) << 8 | (vs[base + 2] & 0xFF) << 16 | (vs[base + 3] & 0xFF) << 24;
                                    int b = (vs[base + 4] & 0xFF) << 0 | (vs[base + 5] & 0xFF) << 8 | (vs[base + 6] & 0xFF) << 16 | (vs[base + 7] & 0xFF) << 24;
                                    vs1[i] = (long)b << 32 | (long)a;
                                    ++i;
                                }
                                v = vs1;
                                break;
                            }
                            default: {
                                throw new RuntimeException();
                            }
                        }
                        cv.visitFillArrayDataStmt(Op.FILL_ARRAY_DATA, reg, (Object)v);
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
            }
        });
    }

    public void visitLabel(DexLabel label) {
        this.addCare((DexCodeNode.DexStmtNode)new DexCodeNode.DexLabelStmtNode(label));
    }

    public static class ArrayDataStmt
    extends DexCodeNode.DexStmtNode {
        int length;
        byte[] objs;

        public ArrayDataStmt(int length, byte[] obj) {
            this.length = length;
            this.objs = obj;
        }

        public void accept(DexCodeVisitor cv) {
        }
    }

    public static class PackedSwitchStmt
    extends DexCodeNode.DexStmtNode {
        int firstCase;
        DexLabel[] labels;

        public PackedSwitchStmt(int reg, DexLabel[] labels) {
            this.firstCase = reg;
            this.labels = labels;
        }

        public void accept(DexCodeVisitor cv) {
        }
    }

    public static class SparseSwitchStmt
    extends DexCodeNode.DexStmtNode {
        int[] cases;
        DexLabel[] labels;

        public SparseSwitchStmt(int[] cases, DexLabel[] labels) {
            this.cases = cases;
            this.labels = labels;
        }

        public void accept(DexCodeVisitor cv) {
        }
    }
}

