/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Comparator;
import org.openide.util.lookup.AbstractLookup;

final class ALPairComparator
implements Comparator<AbstractLookup.Pair<?>> {
    public static final Comparator<AbstractLookup.Pair<?>> DEFAULT = new ALPairComparator();

    private ALPairComparator() {
    }

    @Override
    public int compare(AbstractLookup.Pair<?> pair, AbstractLookup.Pair<?> pair2) {
        int n = pair.getIndex() - pair2.getIndex();
        if (n == 0) {
            if (pair != pair2) {
                throw new DuplicatedPairException(pair, pair2);
            }
            return 0;
        }
        return n;
    }

    private static final class DuplicatedPairException
    extends IllegalStateException {
        private final AbstractLookup.Pair<?> i1;
        private final AbstractLookup.Pair<?> i2;

        public DuplicatedPairException(AbstractLookup.Pair<?> pair, AbstractLookup.Pair<?> pair2) {
            this.i1 = pair;
            this.i2 = pair2;
        }

        @Override
        public String getMessage() {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            printStream.println("Duplicate pair in treePair1: " + this.i1 + " pair2: " + this.i2 + " index1: " + this.i1.getIndex() + " index2: " + this.i2.getIndex() + " item1: " + this.i1.getInstance() + " item2: " + this.i2.getInstance() + " id1: " + Integer.toHexString(System.identityHashCode(this.i1)) + " id2: " + Integer.toHexString(System.identityHashCode(this.i2)));
            printStream.close();
            return byteArrayOutputStream.toString();
        }
    }
}

