/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.armedbear.lisp.AbstractString;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.Environment;
import org.armedbear.lisp.FileError;
import org.armedbear.lisp.FileStream;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.JarPathname;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispInteger;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.LogicalPathname;
import org.armedbear.lisp.Nil;
import org.armedbear.lisp.Pathname;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SimpleError;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.Site;
import org.armedbear.lisp.SpecialBinding;
import org.armedbear.lisp.SpecialBindingsMark;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.URLPathname;
import org.armedbear.lisp.Utilities;
import org.armedbear.lisp.ZipCache;
import org.armedbear.lisp.probe_file;

public final class Load {
    private static final Symbol FASL_LOADER = Lisp.PACKAGE_SYS.intern("*FASL-LOADER*");
    static final LispObject COMPILE_FILE_INIT_FASL_TYPE = new SimpleString("_");
    static final Symbol _FASL_VERSION_ = Lisp.exportConstant("*FASL-VERSION*", Lisp.PACKAGE_SYS, Fixnum.getInstance(43));
    private static final Symbol _FASL_EXTERNAL_FORMAT_ = Lisp.internConstant("*FASL-EXTERNAL-FORMAT*", Lisp.PACKAGE_SYS, new SimpleString("UTF-8"));
    public static final Symbol _FASL_UNINTERNED_SYMBOLS_ = Lisp.internSpecial("*FASL-UNINTERNED-SYMBOLS*", Lisp.PACKAGE_SYS, Lisp.NIL);
    private static final Primitive INIT_FASL = new init_fasl();
    private static Symbol[] savedSpecials = new Symbol[]{Symbol.CURRENT_READTABLE, Symbol._PACKAGE_, Lisp._SPEED_, Lisp._SPACE_, Lisp._SAFETY_, Lisp._DEBUG_, Lisp._EXPLAIN_};
    private static final Primitive _LOAD = new _load();
    private static final Primitive _LOAD_RETURNING_LAST_RESULT = new _load_returning_last_result();
    public static final Primitive LOAD_SYSTEM_FILE = new pf_load_system_file();

    public static final LispObject load(String filename) {
        LispThread thread = LispThread.currentThread();
        return Load.load(Pathname.create(filename), Symbol.LOAD_VERBOSE.symbolValue(thread) != Lisp.NIL, Symbol.LOAD_PRINT.symbolValue(thread) != Lisp.NIL, true);
    }

    private static final Pathname findLoadableFile(Pathname name) {
        Pathname t;
        LispObject truename = Symbol.PROBE_FILE.execute(name);
        if (truename instanceof Pathname && (t = (Pathname)truename).getName() != Lisp.NIL && t.getName() != null) {
            return t;
        }
        String COMPILE_FILE_TYPE = Lisp._COMPILE_FILE_TYPE_.symbolValue().getStringValue();
        if (name.getType() == Lisp.NIL && (name.getName() != Lisp.NIL || name.getName() != null)) {
            Pathname lispPathname = Pathname.create(name);
            lispPathname.setType(new SimpleString("lisp"));
            LispObject lisp = Symbol.PROBE_FILE.execute(lispPathname);
            Pathname abclPathname = Pathname.create(name);
            abclPathname.setType(new SimpleString(COMPILE_FILE_TYPE));
            LispObject abcl = Symbol.PROBE_FILE.execute(abclPathname);
            if (lisp instanceof Pathname && abcl instanceof Pathname) {
                lispPathname = (Pathname)lisp;
                abclPathname = (Pathname)abcl;
                long lispLastModified = lispPathname.getLastModified();
                long abclLastModified = abclPathname.getLastModified();
                if (abclLastModified > lispLastModified) {
                    return abclPathname;
                }
                return lispPathname;
            }
            if (abcl instanceof Pathname) {
                return (Pathname)abcl;
            }
            if (lisp instanceof Pathname) {
                return (Pathname)lisp;
            }
        }
        if (name.isJar() && name.getType().equals(Lisp.NIL)) {
            name.setType(COMPILE_FILE_INIT_FASL_TYPE);
            Pathname result = Load.findLoadableFile(name);
            if (result != null) {
                return result;
            }
            name.setType(new SimpleString(COMPILE_FILE_TYPE));
            result = Load.findLoadableFile(name);
            if (result != null) {
                return result;
            }
        }
        return null;
    }

    public static final LispObject load(Pathname pathname, boolean verbose, boolean print, boolean ifDoesNotExist) {
        return Load.load(pathname, verbose, print, ifDoesNotExist, false, (LispObject)Keyword.DEFAULT);
    }

    public static final LispObject load(InputStream in) {
        return Load.load(in, new SimpleString("UTF-8"));
    }

    public static final LispObject load(InputStream in, LispObject format) {
        Stream stream = new Stream(Symbol.SYSTEM_STREAM, in, (LispObject)Symbol.CHARACTER, format);
        LispThread thread = LispThread.currentThread();
        return Load.loadFileFromStream(null, null, stream, Symbol.LOAD_VERBOSE.symbolValue(thread) != Lisp.NIL, Symbol.LOAD_PRINT.symbolValue(thread) != Lisp.NIL, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final LispObject load(Pathname pathname, boolean verbose, boolean print, boolean ifDoesNotExist, boolean returnLastResult, LispObject externalFormat) {
        InputStream in;
        Pathname truename;
        Pathname mergedPathname = null;
        if (!pathname.isAbsolute() && !pathname.isJar()) {
            Pathname pathnameDefaults = Lisp.coerceToPathname(Symbol.DEFAULT_PATHNAME_DEFAULTS.symbolValue());
            mergedPathname = Pathname.mergePathnames(pathname, pathnameDefaults);
        }
        Pathname loadableFile = Load.findLoadableFile(mergedPathname != null ? mergedPathname : pathname);
        Pathname pathname2 = truename = loadableFile != null ? (Pathname)Symbol.PROBE_FILE.execute(loadableFile) : null;
        if (truename == null || truename.equals(Lisp.NIL)) {
            if (ifDoesNotExist) {
                return Lisp.error(new FileError("File not found: " + pathname.princToString(), pathname));
            }
            Debug.warn("Failed to load " + pathname.getNamestring());
            return Lisp.NIL;
        }
        if (ZipCache.checkZipFile(truename)) {
            truename = truename instanceof JarPathname ? JarPathname.createFromEntry((JarPathname)truename) : JarPathname.createFromPathname(truename);
            Pathname loader = Pathname.create("__loader__._");
            mergedPathname = (Pathname)Symbol.MERGE_PATHNAMES.execute((LispObject)loader, truename);
            LispObject initTruename = Symbol.PROBE_FILE.execute(mergedPathname);
            if (initTruename.equals(Lisp.NIL)) {
                Pathname p = Pathname.create(mergedPathname);
                p.setName(Keyword.WILD);
                LispObject result = Symbol.MATCH_WILD_JAR_PATHNAME.execute(p);
                if (result instanceof Cons && ((Cons)result).length() == 1 && ((Cons)result).car() instanceof Pathname) {
                    initTruename = (Pathname)result.car();
                } else {
                    String errorMessage = "Loadable FASL not found for " + pathname.printObject() + " in " + mergedPathname.printObject();
                    if (ifDoesNotExist) {
                        return Lisp.error(new FileError(errorMessage, mergedPathname));
                    }
                    Debug.trace(errorMessage);
                    return Lisp.NIL;
                }
            }
            truename = (Pathname)initTruename;
        }
        Debug.assertTrue((in = truename.getInputStream()) != null);
        try {
            LispObject lispObject = Load.loadFileFromStream(pathname, truename, new Stream(Symbol.SYSTEM_STREAM, in, (LispObject)Symbol.CHARACTER, externalFormat), verbose, print, false, returnLastResult);
            return lispObject;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    return Lisp.error(new LispError(e.getMessage()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LispObject loadSystemFile(String filename, boolean auto) {
        LispThread thread = LispThread.currentThread();
        if (auto) {
            SpecialBindingsMark mark = thread.markSpecialBindings();
            thread.bindSpecial(Symbol.CURRENT_READTABLE, Lisp.STANDARD_READTABLE.symbolValue(thread));
            thread.bindSpecial(Symbol.READ_BASE, Fixnum.constants[10]);
            thread.bindSpecial(Symbol.READ_SUPPRESS, Lisp.NIL);
            thread.bindSpecial(Symbol.READ_EVAL, Lisp.T);
            thread.bindSpecial(Symbol.READ_DEFAULT_FLOAT_FORMAT, Symbol.SINGLE_FLOAT);
            thread.bindSpecial(Symbol._PACKAGE_, Lisp.PACKAGE_CL_USER);
            try {
                LispObject lispObject = Load.loadSystemFile(filename, Lisp._AUTOLOAD_VERBOSE_.symbolValue(thread) != Lisp.NIL, Symbol.LOAD_PRINT.symbolValue(thread) != Lisp.NIL, auto);
                return lispObject;
            }
            finally {
                thread.resetSpecialBindings(mark);
            }
        }
        return Load.loadSystemFile(filename, Symbol.LOAD_VERBOSE.symbolValue(thread) != Lisp.NIL, Symbol.LOAD_PRINT.symbolValue(thread) != Lisp.NIL, auto);
    }

    private static final Pathname coercePathnameOrNull(LispObject p) {
        if (p == null) {
            return null;
        }
        Pathname result = null;
        try {
            result = (Pathname)p;
        }
        catch (Throwable t) {
            return null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final LispObject loadSystemFile(String filename, boolean verbose, boolean print, boolean auto) {
        Pathname mergedPathname;
        InputStream in = null;
        Pathname pathname = null;
        Pathname truename = null;
        pathname = Pathname.create(filename);
        LispObject bootPath = Site.getLispHome();
        if (bootPath instanceof Pathname) {
            mergedPathname = (Pathname)Symbol.MERGE_PATHNAMES.execute((LispObject)pathname, bootPath);
            if (mergedPathname.getDevice().equals(Lisp.NIL) && !Utilities.isPlatformWindows) {
                mergedPathname.setDevice(Keyword.UNSPECIFIC);
            }
        } else {
            mergedPathname = pathname;
        }
        URL url = null;
        Pathname loadableFile = Load.findLoadableFile(mergedPathname);
        truename = loadableFile == null ? null : (Pathname)Symbol.PROBE_FILE.execute(loadableFile);
        String COMPILE_FILE_TYPE = Lisp._COMPILE_FILE_TYPE_.symbolValue().getStringValue();
        if (truename == null || truename.equals(Lisp.NIL) || bootPath.equals(Lisp.NIL)) {
            String path = pathname.asEntryPath();
            url = Lisp.class.getResource(path);
            if ((url == null || url.toString().endsWith("/")) && (url = Lisp.class.getResource(path.replace('-', '_') + "." + COMPILE_FILE_TYPE)) == null) {
                url = Lisp.class.getResource(path + ".lisp");
            }
            if (url == null) {
                return Lisp.error(new LispError("Failed to find loadable system file '" + path + "' in boot classpath."));
            }
            if (!bootPath.equals(Lisp.NIL)) {
                URLPathname urlPathname = URLPathname.create(url);
                loadableFile = Load.findLoadableFile(urlPathname);
                truename = (Pathname)Symbol.PROBE_FILE.execute(loadableFile);
                if (truename.equals(Lisp.NIL)) {
                    return Lisp.error(new LispError("Failed to find loadable system file in boot classpath '" + String.valueOf(url) + "'"));
                }
            } else {
                truename = null;
            }
        }
        if (truename != null && truename.getType().princToString().equals(COMPILE_FILE_TYPE) && ZipCache.checkZipFile(truename)) {
            Pathname init = Pathname.create(truename.getNamestring());
            init.setType(COMPILE_FILE_INIT_FASL_TYPE);
            init.setName(new SimpleString("__loader__"));
            LispObject t = Symbol.PROBE_FILE.execute(init);
            if (t instanceof Pathname) {
                truename = (Pathname)t;
            } else {
                return Lisp.error(new LispError("Failed to find loadable init FASL in '" + init.getNamestring() + "'"));
            }
        }
        if (truename != null) {
            in = truename.getInputStream();
        } else {
            try {
                Debug.assertTrue(url != null);
                in = url.openStream();
            }
            catch (IOException e) {
                Lisp.error(new FileError("Failed to load system file: '" + filename + "' from URL: '" + String.valueOf(url) + "'"));
            }
        }
        if (in != null) {
            LispThread thread = LispThread.currentThread();
            SpecialBindingsMark mark = thread.markSpecialBindings();
            thread.bindSpecial(Lisp._WARN_ON_REDEFINITION_, Lisp.NIL);
            thread.bindSpecial(FASL_LOADER, Lisp.NIL);
            try {
                Stream stream = new Stream(Symbol.SYSTEM_STREAM, in, (LispObject)Symbol.CHARACTER);
                LispObject lispObject = Load.loadFileFromStream(pathname, truename, stream, verbose, print, auto);
                return lispObject;
            }
            finally {
                thread.resetSpecialBindings(mark);
                try {
                    in.close();
                }
                catch (IOException e) {
                    return Lisp.error(new LispError(e.getMessage()));
                }
            }
        }
        return Lisp.error(new FileError("Failed to load system file: '" + filename + "' resolved as '" + String.valueOf(mergedPathname) + "'", truename));
    }

    public static final LispObject getUninternedSymbol(int n) {
        LispThread thread = LispThread.currentThread();
        LispObject uninternedSymbols = _FASL_UNINTERNED_SYMBOLS_.symbolValue(thread);
        if (!(uninternedSymbols instanceof Cons)) {
            return uninternedSymbols.AREF(n);
        }
        LispInteger label = LispInteger.getInstance(n);
        while (uninternedSymbols != Lisp.NIL) {
            LispObject item = uninternedSymbols.car();
            if (label.eql(item.cdr())) {
                return item.car();
            }
            uninternedSymbols = uninternedSymbols.cdr();
        }
        return Lisp.error(new LispError("No entry for uninterned symbol."));
    }

    private static final LispObject loadFileFromStream(Pathname pathname, Pathname truename, Stream in, boolean verbose, boolean print, boolean auto) {
        return Load.loadFileFromStream(pathname == null ? Lisp.NIL : pathname, truename == null ? Lisp.NIL : truename, in, verbose, print, auto, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final LispObject loadFileFromStream(LispObject pathname, LispObject truename, Stream in, boolean verbose, boolean print, boolean auto, boolean returnLastResult) {
        long start = System.currentTimeMillis();
        LispThread thread = LispThread.currentThread();
        SpecialBindingsMark mark = thread.markSpecialBindings();
        for (Symbol special : savedSpecials) {
            thread.bindSpecialToCurrentValue(special);
        }
        thread.bindSpecial(Lisp._BACKQUOTE_COUNT_, Fixnum.getInstance(0));
        int loadDepth = Fixnum.getValue(Lisp._LOAD_DEPTH_.symbolValue(thread));
        thread.bindSpecial(Lisp._LOAD_DEPTH_, Fixnum.getInstance(++loadDepth));
        String prefix = Load.getLoadVerbosePrefix(loadDepth);
        try {
            thread.bindSpecial(Symbol.LOAD_PATHNAME, pathname);
            Pathname truePathname = null;
            if (!truename.equals(Lisp.NIL)) {
                if (truename instanceof Pathname) {
                    truePathname = truename instanceof JarPathname ? new JarPathname() : (truename instanceof URLPathname ? new URLPathname() : new Pathname());
                    truePathname.copyFrom((Pathname)truename);
                } else if (truename instanceof AbstractString) {
                    truePathname = Pathname.create(truename.getStringValue());
                } else {
                    Debug.assertTrue(false);
                }
                if (truePathname.getType().equal(Lisp._COMPILE_FILE_TYPE_.symbolValue(thread)) || truePathname.getType().equal(COMPILE_FILE_INIT_FASL_TYPE)) {
                    Pathname truenameFasl = Pathname.create(truePathname);
                    thread.bindSpecial(Symbol.LOAD_TRUENAME_FASL, truenameFasl);
                }
                if (truePathname.getType().equal(COMPILE_FILE_INIT_FASL_TYPE) && truePathname.isJar()) {
                    LispObject possibleTruePathname = probe_file.PROBE_FILE.execute(pathname);
                    if (!possibleTruePathname.equals(Lisp.NIL)) {
                        truePathname = (Pathname)possibleTruePathname;
                    }
                    thread.bindSpecial(Symbol.LOAD_TRUENAME, truePathname);
                } else {
                    thread.bindSpecial(Symbol.LOAD_TRUENAME, truename);
                }
            } else {
                thread.bindSpecial(Symbol.LOAD_TRUENAME, truename);
            }
            thread.bindSpecial(Lisp._SOURCE_, pathname != null ? pathname : Lisp.NIL);
            if (verbose) {
                Stream out = Lisp.getStandardOutput();
                out.freshLine();
                out._writeString(prefix);
                out._writeString(auto ? " Autoloading " : " Loading ");
                out._writeString(!truename.equals(Lisp.NIL) ? truePathname.princToString() : "stream");
                out._writeLine(" ...");
                out._finishOutput();
                LispObject result = Load.loadStream(in, print, thread, returnLastResult);
                long elapsed = System.currentTimeMillis() - start;
                out.freshLine();
                out._writeString(prefix);
                out._writeString(auto ? " Autoloaded " : " Loaded ");
                out._writeString(!truename.equals(Lisp.NIL) ? truePathname.princToString() : "stream");
                out._writeString(" (");
                out._writeString(String.valueOf((float)elapsed / 1000.0f));
                out._writeLine(" seconds)");
                out._finishOutput();
                LispObject lispObject = result;
                return lispObject;
            }
            LispObject lispObject = Load.loadStream(in, print, thread, returnLastResult);
            return lispObject;
        }
        finally {
            thread.resetSpecialBindings(mark);
        }
    }

    public static String getLoadVerbosePrefix(int loadDepth) {
        StringBuilder sb = new StringBuilder(";");
        int i = loadDepth - 1;
        while (i-- > 0) {
            sb.append(' ');
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final LispObject loadStream(Stream in, boolean print, LispThread thread, boolean returnLastResult) {
        SpecialBindingsMark mark = thread.markSpecialBindings();
        thread.bindSpecial(Lisp._LOAD_STREAM_, in);
        SpecialBinding sourcePositionBinding = thread.bindSpecial(Lisp._SOURCE_POSITION_, Fixnum.ZERO);
        try {
            Symbol symbol;
            Environment env = new Environment();
            LispObject result = Lisp.NIL;
            while (true) {
                sourcePositionBinding.value = Fixnum.getInstance(in.getOffset());
                LispObject obj = in.read(false, Lisp.EOF, false, thread, Stream.currentReadtable);
                if (obj == Lisp.EOF) break;
                result = Lisp.eval(obj, env, thread);
                if (!print) continue;
                Stream out = Lisp.checkCharacterOutputStream(Symbol.STANDARD_OUTPUT.symbolValue(thread));
                out._writeLine(result.printObject());
                out._finishOutput();
            }
            if (returnLastResult) {
                symbol = result;
                return symbol;
            }
            symbol = Lisp.T;
            return symbol;
        }
        finally {
            thread.resetSpecialBindings(mark);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final LispObject faslLoadStream(LispThread thread) {
        Stream in = (Stream)Lisp._LOAD_STREAM_.symbolValue(thread);
        Environment env = new Environment();
        SpecialBindingsMark mark = thread.markSpecialBindings();
        LispObject result = Lisp.NIL;
        try {
            LispObject obj;
            thread.bindSpecial(Symbol.READ_BASE, LispInteger.getInstance(10));
            thread.bindSpecial(Symbol.READ_EVAL, Symbol.T);
            thread.bindSpecial(Symbol.READ_SUPPRESS, Nil.NIL);
            in.setExternalFormat(_FASL_EXTERNAL_FORMAT_.symbolValue(thread));
            while ((obj = in.read(false, Lisp.EOF, false, thread, Stream.faslReadtable)) != Lisp.EOF) {
                result = Lisp.eval(obj, env, thread);
            }
        }
        finally {
            thread.resetSpecialBindings(mark);
        }
        return result;
    }

    static final LispObject load(LispObject filespec, LispObject verbose, LispObject print, LispObject ifDoesNotExist, LispObject returnLastResult, LispObject externalFormat) {
        if (filespec instanceof Stream && ((Stream)filespec).isOpen()) {
            LispObject pathname = filespec instanceof FileStream ? ((FileStream)filespec).getPathname() : Lisp.NIL;
            LispObject truename = pathname instanceof Pathname ? pathname : Lisp.NIL;
            return Load.loadFileFromStream(pathname, truename, (Stream)filespec, verbose != Lisp.NIL, print != Lisp.NIL, false, returnLastResult != Lisp.NIL);
        }
        Pathname pathname = Lisp.coerceToPathname(filespec);
        if (pathname instanceof LogicalPathname) {
            pathname = LogicalPathname.translateLogicalPathname((LogicalPathname)pathname);
        }
        return Load.load(pathname, verbose != Lisp.NIL, print != Lisp.NIL, ifDoesNotExist != Lisp.NIL, returnLastResult != Lisp.NIL, externalFormat);
    }

    private static class pf_load_system_file
    extends Primitive {
        pf_load_system_file() {
            super("load-system-file", Lisp.PACKAGE_SYS, true);
        }

        @Override
        public LispObject execute(LispObject arg) {
            LispThread thread = LispThread.currentThread();
            return Load.loadSystemFile(arg.getStringValue(), Symbol.LOAD_VERBOSE.symbolValue(thread) != Lisp.NIL || System.getProperty("abcl.autoload.verbose") != null, Symbol.LOAD_PRINT.symbolValue(thread) != Lisp.NIL, false);
        }
    }

    private static class _load_returning_last_result
    extends Primitive {
        _load_returning_last_result() {
            super("%load-returning-last-result", Lisp.PACKAGE_SYS, false, "filespec verbose print if-does-not-exist external-format");
        }

        @Override
        public LispObject execute(LispObject filespec, LispObject verbose, LispObject print, LispObject ifDoesNotExist, LispObject externalFormat) {
            return Load.load(filespec, verbose, print, ifDoesNotExist, Lisp.T, externalFormat);
        }
    }

    private static class _load
    extends Primitive {
        _load() {
            super("%load", Lisp.PACKAGE_SYS, false, "filespec verbose print if-does-not-exist external-format");
        }

        @Override
        public LispObject execute(LispObject filespec, LispObject verbose, LispObject print, LispObject ifDoesNotExist, LispObject externalFormat) {
            return Load.load(filespec, verbose, print, ifDoesNotExist, Lisp.NIL, externalFormat);
        }
    }

    private static class init_fasl
    extends Primitive {
        init_fasl() {
            super("init-fasl", Lisp.PACKAGE_SYS, true, "&key version");
        }

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            LispThread thread = LispThread.currentThread();
            if (first == Keyword.VERSION && second.eql(_FASL_VERSION_.getSymbolValue())) {
                thread.bindSpecial(_FASL_UNINTERNED_SYMBOLS_, Lisp.NIL);
                thread.bindSpecial(Lisp._SOURCE_, Lisp.NIL);
                return Load.faslLoadStream(thread);
            }
            return Lisp.error(new SimpleError("FASL version mismatch; found '" + second.princToString() + "' but expected '" + _FASL_VERSION_.getSymbolValue().princToString() + "' in " + Symbol.LOAD_PATHNAME.symbolValue(thread).princToString() + " (try recompiling the file)"));
        }
    }
}

