/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.variables;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.JupyterRemoteSessionHistoryRetriever;
import com.intellij.jupyter.core.editor.NotebookMarkdownEditorManagerKt;
import com.intellij.jupyter.core.editor.utils.JupyterEditorCellExtensionsKt;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSession;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterListenersKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutputSchema;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutputs;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutputsBase;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterStreamOutput;
import com.intellij.jupyter.core.jupyter.nbformat.schema.v4.V4JupyterOutputSchema;
import com.intellij.jupyter.py.variables.PythonJupyterVarsCommandExecutor;
import com.intellij.notebooks.visualization.NotebookCellInlayManager;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.ProgressStatus;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.DigestUtilKt;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0001%B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016J0\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0018H\u0002J\u0018\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001a2\u0006\u0010\u001c\u001a\u00020\u0016H\u0002J\u001e\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u0016H\u0002J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u0016H\u0002J\b\u0010\"\u001a\u00020\u0016H\u0002J\u0010\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/jupyter/py/variables/PythonRemoteSessionHistoryRetriever;", "Lcom/intellij/jupyter/core/editor/JupyterRemoteSessionHistoryRetriever;", "session", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterNotebookSession;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "<init>", "(Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterNotebookSession;Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "executor", "Lcom/intellij/jupyter/py/variables/PythonJupyterVarsCommandExecutor;", "inlayManager", "Lcom/intellij/notebooks/visualization/NotebookCellInlayManager;", "virtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "retrieveHistory", "", "processMatchesCell", "matchIndex", "", "pointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "matchOutput", "", "outputUpdater", "Lkotlin/Function0;", "parseHistory", "", "Lcom/intellij/jupyter/py/variables/PythonRemoteSessionHistoryRetriever$HistoryEntry;", "rawString", "parseOutputs", "", "jsonRaw", "sha256Hex", "input", "getHistoryCommand", "getOutputCommand", "minExecCount", "HistoryEntry", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nPythonRemoteSessionHistoryRetriever.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonRemoteSessionHistoryRetriever.kt\ncom/intellij/jupyter/py/variables/PythonRemoteSessionHistoryRetriever\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,158:1\n1617#2,9:159\n1869#2:168\n1870#2:170\n1626#2:171\n1208#2,2:172\n1236#2,4:174\n1617#2,9:178\n1869#2:187\n1870#2:189\n1626#2:190\n1#3:169\n1#3:188\n1#3:193\n32#4,2:191\n*S KotlinDebug\n*F\n+ 1 PythonRemoteSessionHistoryRetriever.kt\ncom/intellij/jupyter/py/variables/PythonRemoteSessionHistoryRetriever\n*L\n41#1:159,9\n41#1:168\n41#1:170\n41#1:171\n44#1:172,2\n44#1:174,4\n89#1:178,9\n89#1:187\n89#1:189\n89#1:190\n41#1:169\n89#1:188\n105#1:191,2\n*E\n"})
public final class PythonRemoteSessionHistoryRetriever
implements JupyterRemoteSessionHistoryRetriever {
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final PythonJupyterVarsCommandExecutor executor;
    @Nullable
    private final NotebookCellInlayManager inlayManager;
    @NotNull
    private final BackedNotebookVirtualFile virtualFile;

    public PythonRemoteSessionHistoryRetriever(@NotNull JupyterNotebookSession session, @NotNull EditorImpl editor) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
        this.executor = PythonJupyterVarsCommandExecutor.Companion.getInstance(session.getProject());
        this.inlayManager = NotebookCellInlayManager.Companion.get((Editor)this.editor);
        this.virtualFile = JupyterEditorExtensionsKt.getNotebookFile((Editor)((Editor)this.editor));
    }

    /*
     * WARNING - void declaration
     */
    public void retrieveHistory() {
        void $this$associateByTo$iv$iv;
        Object element$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        String historyResult = PythonJupyterVarsCommandExecutor.executeCommand$default(this.executor, this.getHistoryCommand(), this.virtualFile, null, 4, null);
        List<HistoryEntry> list = this.parseHistory(historyResult);
        if (list == null) {
            return;
        }
        List<HistoryEntry> historyEntries = list;
        List cells = this.virtualFile.getNotebook().computeCells();
        Iterable $this$mapNotNull$iv = cells;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo22 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            JupyterCell it = (JupyterCell)element$iv$iv;
            boolean bl2 = false;
            if (it.getExecutionCount() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Integer n = (Integer)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
        int maxExecCountInNotebook = n != null ? n : 0;
        List pointers = NotebookMarkdownEditorManagerKt.getAllIntervalPointers((Editor)((Editor)this.editor));
        Iterable $this$associateBy$iv = pointers;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable $i$f$mapNotNullTo22 = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv2 : $this$associateByTo$iv$iv) {
            void it;
            element$iv$iv = (NotebookIntervalPointer)element$iv$iv2;
            Map map = destination$iv$iv2;
            boolean bl = false;
            Object object = it.get();
            if (object == null || (object = object.getContentText((Editor)this.editor)) == null) {
                object = "";
            }
            map.put(this.sha256Hex((String)object), element$iv$iv2);
        }
        Map pointersByHash = destination$iv$iv2;
        String outputResult = PythonJupyterVarsCommandExecutor.executeCommand$default(this.executor, this.getOutputCommand(maxExecCountInNotebook), this.virtualFile, null, 4, null);
        Map map = this.parseOutputs(outputResult);
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Map outputByExecNum = map;
        for (HistoryEntry entry : historyEntries) {
            NotebookIntervalPointer matchedPtr;
            if (entry.getNum() <= maxExecCountInNotebook || (NotebookIntervalPointer)pointersByHash.get(entry.getHash()) == null) continue;
            String matchOutput = (String)outputByExecNum.get(entry.getNum());
            this.processMatchesCell(entry.getNum(), matchedPtr, matchOutput, (Function0<Unit>)((Function0)() -> PythonRemoteSessionHistoryRetriever.retrieveHistory$lambda$2(this, matchedPtr)));
        }
    }

    private final void processMatchesCell(int matchIndex, NotebookIntervalPointer pointer, String matchOutput, Function0<Unit> outputUpdater) {
        NotebookCellInlayManager notebookCellInlayManager = this.inlayManager;
        if (notebookCellInlayManager == null || (notebookCellInlayManager = notebookCellInlayManager.getCell(pointer)) == null) {
            return;
        }
        NotebookCellInlayManager editorCell = notebookCellInlayManager;
        JupyterCell jupyterCell = JupyterEditorCellExtensionsKt.getJupyterCell((EditorCell)editorCell);
        if (jupyterCell == null) {
            return;
        }
        JupyterCell jupyterCell2 = jupyterCell;
        ProgressStatus progressStatus = ProgressStatus.STOPPED_OK;
        ZonedDateTime zonedDateTime = jupyterCell2.getExecutionStartTime();
        ZonedDateTime zonedDateTime2 = jupyterCell2.getExecutionEndTime();
        EditorCell.ExecutionStatus status = new EditorCell.ExecutionStatus(progressStatus, Integer.valueOf(matchIndex), zonedDateTime, zonedDateTime2);
        editorCell.getExecutionStatus().set((Object)status);
        if (matchOutput == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> PythonRemoteSessionHistoryRetriever.processMatchesCell$lambda$4(jupyterCell2, matchOutput, outputUpdater));
    }

    /*
     * WARNING - void declaration
     */
    private final List<HistoryEntry> parseHistory(String rawString) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = StringsKt.lines((CharSequence)rawString);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            HistoryEntry historyEntry;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String line = (String)element$iv$iv;
            boolean bl2 = false;
            String[] stringArray = new String[]{"\t"};
            List parts = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)line)).toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (parts.size() == 2) {
                Integer lineNum = StringsKt.toIntOrNull((String)((String)parts.get(0)));
                String hash = (String)parts.get(1);
                historyEntry = lineNum != null ? new HistoryEntry(lineNum, hash) : null;
            } else {
                historyEntry = null;
            }
            if (historyEntry == null) continue;
            HistoryEntry it$iv$iv = historyEntry;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Map<Integer, String> parseOutputs(String jsonRaw) {
        Map map;
        try {
            JsonNode jsonNode = new ObjectMapper().readTree(jsonRaw);
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"readTree(...)");
            JsonNode root = jsonNode;
            if (!root.isObject()) {
                return null;
            }
            Map result2 = new LinkedHashMap();
            Iterator iterator = ((ObjectNode)root).fields();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"fields(...)");
            Iterator $this$forEach$iv = iterator;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv;
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)entry);
                String key = (String)entry.getKey();
                JsonNode value = (JsonNode)entry.getValue();
                Intrinsics.checkNotNull((Object)key);
                Integer n = StringsKt.toIntOrNull((String)key);
                if (n == null) continue;
                int execNum = ((Number)n).intValue();
                boolean bl2 = false;
                result2.put(execNum, value.asText());
            }
            map = result2;
        }
        catch (Exception exception) {
            map = null;
        }
        return map;
    }

    private final String sha256Hex(String input) {
        String string = ((Object)StringsKt.trim((CharSequence)input)).toString();
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] bytes = byArray;
        byte[] byArray2 = DigestUtil.sha256().digest(bytes);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"digest(...)");
        return DigestUtilKt.bytesToHex((byte[])byArray2);
    }

    private final String getHistoryCommand() {
        return "import hashlib\nfrom IPython.core.history import HistoryAccessor\n\ndef _print_history_hashes():\n    def get_hash(s):\n        return hashlib.sha256(s.strip().encode()).hexdigest()\n\n    hist = HistoryAccessor()\n    session_id = get_ipython().history_manager.session_number\n\n    for _, num, input_text in hist.get_range(session=session_id):\n        code = input_text.strip()\n        if code:\n            print(f\"{num}\\t{get_hash(code)}\")\n\n_print_history_hashes()\ndel _print_history_hashes";
    }

    private final String getOutputCommand(int minExecCount) {
        return StringsKt.trimIndent((String)("\n      import json\n      from IPython import get_ipython\n  \n      def _print_serialized_outputs(min_num):\n          ip = get_ipython()\n          out = getattr(ip, 'user_ns', {}).get('Out', {})\n          result = {str(k): repr(v) for k, v in out.items() if isinstance(k, int) and k > min_num}\n          print(json.dumps(result))\n  \n      _print_serialized_outputs(" + minExecCount + ")\n      del _print_serialized_outputs\n  "));
    }

    private static final Unit retrieveHistory$lambda$2(PythonRemoteSessionHistoryRetriever this$0, NotebookIntervalPointer $matchedPtr) {
        JupyterListenersKt.outputUpdated((JupyterNotebook)this$0.virtualFile.getNotebook(), (NotebookIntervalPointer)$matchedPtr);
        return Unit.INSTANCE;
    }

    private static final void processMatchesCell$lambda$4(JupyterCell $jupyterCell, String $matchOutput, Function0 $outputUpdater) {
        JupyterOutputs jupyterOutputs = $jupyterCell.getOutputs();
        if (jupyterOutputs == null) {
            JupyterOutputsBase jupyterOutputsBase;
            JupyterOutputsBase it = jupyterOutputsBase = new JupyterOutputsBase(null, (JupyterOutputSchema)V4JupyterOutputSchema.INSTANCE, 1, null);
            boolean bl = false;
            $jupyterCell.setOutputs((JupyterOutputs)it);
            jupyterOutputs = (JupyterOutputs)jupyterOutputsBase;
        }
        JupyterOutputs outputs = jupyterOutputs;
        JupyterStreamOutput.Companion.fromText$default((JupyterStreamOutput.Companion)JupyterStreamOutput.Companion, (String)$matchOutput, null, (int)2, null).copyTo(outputs, null);
        $outputUpdater.invoke();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/jupyter/py/variables/PythonRemoteSessionHistoryRetriever$HistoryEntry;", "", "num", "", "hash", "", "<init>", "(ILjava/lang/String;)V", "getNum", "()I", "getHash", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "intellij.jupyter.py"})
    private static final class HistoryEntry {
        private final int num;
        @NotNull
        private final String hash;

        public HistoryEntry(int num, @NotNull String hash) {
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            this.num = num;
            this.hash = hash;
        }

        public final int getNum() {
            return this.num;
        }

        @NotNull
        public final String getHash() {
            return this.hash;
        }

        public final int component1() {
            return this.num;
        }

        @NotNull
        public final String component2() {
            return this.hash;
        }

        @NotNull
        public final HistoryEntry copy(int num, @NotNull String hash) {
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            return new HistoryEntry(num, hash);
        }

        public static /* synthetic */ HistoryEntry copy$default(HistoryEntry historyEntry, int n, String string, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = historyEntry.num;
            }
            if ((n2 & 2) != 0) {
                string = historyEntry.hash;
            }
            return historyEntry.copy(n, string);
        }

        @NotNull
        public String toString() {
            return "HistoryEntry(num=" + this.num + ", hash=" + this.hash + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.num);
            result2 = result2 * 31 + this.hash.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HistoryEntry)) {
                return false;
            }
            HistoryEntry historyEntry = (HistoryEntry)other;
            if (this.num != historyEntry.num) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.hash, (Object)historyEntry.hash);
        }
    }
}

