/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.builder.presentation.Defaults;
import org.jetbrains.letsPlot.core.spec.FigKind;
import org.jetbrains.letsPlot.core.spec.PlotConfigUtil;
import org.jetbrains.letsPlot.core.spec.config.PlotConfig;
import org.jetbrains.letsPlot.core.spec.front.PlotConfigFrontend;
import org.jetbrains.letsPlot.core.util.MonolithicCommon;
import org.jetbrains.letsPlot.core.util.PlotHtmlExport;
import org.jetbrains.letsPlot.core.util.PlotHtmlHelper;
import org.jetbrains.letsPlot.core.util.PlotSizeHelper;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0002J\u001e\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0006H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/core/util/PlotHtmlExport;", "", "()V", "buildHtmlFromRawSpecs", "", "plotSpec", "", "scriptUrl", "iFrame", "", "plotSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "escapeHtmlAttr", "value", "preferredPlotSizeFromRawSpec", "plot-stem"})
public final class PlotHtmlExport {
    @NotNull
    public static final PlotHtmlExport INSTANCE = new PlotHtmlExport();

    private PlotHtmlExport() {
    }

    @NotNull
    public final String buildHtmlFromRawSpecs(@NotNull Map<String, Object> plotSpec, @NotNull String scriptUrl, boolean iFrame, @Nullable DoubleVector plotSize2) {
        String string;
        DoubleVector doubleVector;
        DoubleVector doubleVector2;
        DoubleVector doubleVector3;
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        Intrinsics.checkNotNullParameter((Object)scriptUrl, (String)"scriptUrl");
        if (iFrame) {
            doubleVector3 = plotSize2;
            if (doubleVector3 == null && (doubleVector3 = this.preferredPlotSizeFromRawSpec(plotSpec)) == null) {
                doubleVector3 = Defaults.INSTANCE.getDEF_PLOT_SIZE();
            }
        } else {
            doubleVector3 = null;
        }
        if ((doubleVector2 = doubleVector3) != null) {
            DoubleVector it = doubleVector2;
            boolean bl = false;
            doubleVector = new DoubleVector(Math.floor(it.getX()), Math.floor(it.getY()));
        } else {
            doubleVector = null;
        }
        DoubleVector fixedSizeQ = doubleVector;
        String configureHtml = PlotHtmlHelper.INSTANCE.getStaticConfigureHtml(scriptUrl);
        String displayHtml = PlotHtmlHelper.INSTANCE.getStaticDisplayHtmlForRawSpec(plotSpec, fixedSizeQ, true, true);
        String style = iFrame ? "<style> html, body { margin: 0; padding: 0; overflow: hidden; } </style>" : "<style> html, body { margin: 0; padding: 0; } </style>";
        String html = StringsKt.trimMargin$default((String)("\n            |<html lang=\"en\">\n            |   <head>\n            |       <meta charset=\"UTF-8\">\n            |       " + style + "\n            |       " + configureHtml + "\n            |   </head>\n            |   <body>\n            |       " + displayHtml + "\n            |   </body>\n            |</html>\n        "), null, (int)1, null);
        if (iFrame) {
            Intrinsics.checkNotNull((Object)fixedSizeQ);
            int it = (int)fixedSizeQ.getY();
            boolean bl = false;
            int frameHeight = PlotConfigUtil.INSTANCE.containsToolbar(plotSpec) ? it + 33 : it;
            ArrayList<String> attributes2 = new ArrayList<String>();
            attributes2.add("src='about:blank'");
            attributes2.add("style='border:none !important;'");
            attributes2.add("width='" + (int)fixedSizeQ.getX() + '\'');
            attributes2.add("height='" + frameHeight + '\'');
            attributes2.add("srcdoc=\"" + this.escapeHtmlAttr(html) + '\"');
            string = StringsKt.trimIndent((String)("\n            <iframe " + CollectionsKt.joinToString$default((Iterable)attributes2, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "></iframe>    \n            "));
        } else {
            string = html;
        }
        return string;
    }

    public static /* synthetic */ String buildHtmlFromRawSpecs$default(PlotHtmlExport plotHtmlExport, Map map2, String string, boolean bl, DoubleVector doubleVector, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            doubleVector = null;
        }
        return plotHtmlExport.buildHtmlFromRawSpecs(map2, string, bl, doubleVector);
    }

    private final String escapeHtmlAttr(String value) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)value, (String)"&", (String)"&amp;", (boolean)false, (int)4, null), (String)"<", (String)"&lt;", (boolean)false, (int)4, null), (String)"\"", (String)"&quot;", (boolean)false, (int)4, null);
    }

    private final DoubleVector preferredPlotSizeFromRawSpec(Map<String, Object> plotSpec) {
        try {
            PlotConfigFrontend config2;
            Map plotSpec2 = MonolithicCommon.processRawSpecs$default(MonolithicCommon.INSTANCE, plotSpec, false, 2, null);
            if (PlotConfig.Companion.isFailure(plotSpec2)) {
                return null;
            }
            switch (WhenMappings.$EnumSwitchMapping$0[PlotConfig.Companion.figSpecKind(plotSpec2).ordinal()]) {
                case 1: 
                case 2: {
                    config2 = PlotConfigFrontend.Companion.create(plotSpec2, null, (Function1<? super List<String>, Unit>)((Function1)preferredPlotSizeFromRawSpec.config.1.INSTANCE));
                    break;
                }
                case 3: {
                    throw new IllegalStateException("Unsupported: GGBunch");
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return PlotSizeHelper.INSTANCE.singlePlotSizeDefault(plotSpec2, config2.getFacets(), config2.getContainsLiveMap());
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FigKind.values().length];
            try {
                nArray[FigKind.PLOT_SPEC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FigKind.SUBPLOTS_SPEC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FigKind.GG_BUNCH_SPEC.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

