/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.api.JupyterClientType;
import org.jetbrains.kotlinx.jupyter.api.KernelLoggerFactory;
import org.jetbrains.kotlinx.jupyter.api.KernelLoggerFactoryKt;
import org.jetbrains.kotlinx.jupyter.util.JupyterClientDetector;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000C\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\f\u0018\u00002\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u00020\tH\u0002J5\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u001e\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u0011\u0012\u0004\u0012\u00020\u00120\u000fH\u0002\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlinx/jupyter/util/JupyterClientDetector;", "", "loggerFactory", "Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;", "<init>", "(Lorg/jetbrains/kotlinx/jupyter/api/KernelLoggerFactory;)V", "logger", "Lorg/slf4j/Logger;", "detect", "Lorg/jetbrains/kotlinx/jupyter/api/JupyterClientType;", "doDetect", "detector", "org/jetbrains/kotlinx/jupyter/util/JupyterClientDetector$detector$1", "type", "predicate", "Lkotlin/Function2;", "", "", "", "(Lorg/jetbrains/kotlinx/jupyter/api/JupyterClientType;Lkotlin/jvm/functions/Function2;)Lorg/jetbrains/kotlinx/jupyter/util/JupyterClientDetector$detector$1;", "detectors", "Lorg/jetbrains/kotlinx/jupyter/util/JupyterClientDetector$Detector;", "Detector", "shared-compiler"})
@SourceDebugExtension(value={"SMAP\nJupyterClientDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterClientDetector.kt\norg/jetbrains/kotlinx/jupyter/util/JupyterClientDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n295#2,2:76\n1761#2,3:78\n1761#2,3:81\n*S KotlinDebug\n*F\n+ 1 JupyterClientDetector.kt\norg/jetbrains/kotlinx/jupyter/util/JupyterClientDetector\n*L\n31#1:76,2\n65#1:78,3\n68#1:81,3\n*E\n"})
public final class JupyterClientDetector {
    @NotNull
    private final Logger logger;
    @NotNull
    private final List<Detector> detectors;

    public JupyterClientDetector(@NotNull KernelLoggerFactory loggerFactory) {
        Intrinsics.checkNotNullParameter((Object)loggerFactory, (String)"loggerFactory");
        this.logger = KernelLoggerFactoryKt.getLogger(loggerFactory, Reflection.getOrCreateKotlinClass(this.getClass()));
        Object[] objectArray = new Detector[]{this.detector(JupyterClientType.JUPYTER_NOTEBOOK, (Function2<? super String, ? super List<String>, Boolean>)((Function2)JupyterClientDetector::detectors$lambda$0)), this.detector(JupyterClientType.JUPYTER_LAB, (Function2<? super String, ? super List<String>, Boolean>)((Function2)JupyterClientDetector::detectors$lambda$1)), this.detector(JupyterClientType.KERNEL_TESTS, (Function2<? super String, ? super List<String>, Boolean>)((Function2)JupyterClientDetector::detectors$lambda$2))};
        this.detectors = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final JupyterClientType detect() {
        JupyterClientType jupyterClientType;
        try {
            jupyterClientType = this.doDetect();
        }
        catch (LinkageError e) {
            this.logger.error("Unable to detect Jupyter client type because of incompatible JVM version", (Throwable)e);
            jupyterClientType = JupyterClientType.UNKNOWN;
        }
        return jupyterClientType;
    }

    private final JupyterClientType doDetect() {
        this.logger.info("Detecting Jupyter client type");
        ProcessHandle currentHandle = ProcessHandle.current();
        List ancestors2 = SequencesKt.toList((Sequence)SequencesKt.generateSequence((Object)currentHandle, JupyterClientDetector::doDetect$lambda$0));
        for (ProcessHandle handle : ancestors2) {
            Object v1;
            block2: {
                ProcessHandle.Info info = handle.info();
                String command = info.command().orElse("");
                String[] stringArray = info.arguments().orElse(new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"orElse(...)");
                List arguments = ArraysKt.toList((Object[])stringArray);
                this.logger.info("Inspecting process: " + command + " " + CollectionsKt.joinToString$default((Iterable)arguments, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                Iterable $this$firstOrNull$iv = this.detectors;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Detector it = (Detector)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)command);
                    if (!it.isThisClient(command, arguments)) continue;
                    v1 = element$iv;
                    break block2;
                }
                v1 = null;
            }
            Detector detector2 = v1;
            if (detector2 == null) continue;
            Detector correctDetector = detector2;
            this.logger.info("Detected type is " + correctDetector.getType());
            return correctDetector.getType();
        }
        this.logger.info("Client type has not been detected");
        return JupyterClientType.UNKNOWN;
    }

    private final detector.1 detector(JupyterClientType type2, Function2<? super String, ? super List<String>, Boolean> predicate) {
        return new Detector(type2, predicate){
            final /* synthetic */ JupyterClientType $type;
            final /* synthetic */ Function2<String, List<String>, Boolean> $predicate;
            {
                this.$type = $type;
                this.$predicate = $predicate;
            }

            public JupyterClientType getType() {
                return this.$type;
            }

            public boolean isThisClient(String command, List<String> arguments) {
                Intrinsics.checkNotNullParameter((Object)command, (String)"command");
                Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
                return (Boolean)this.$predicate.invoke((Object)command, arguments);
            }
        };
    }

    private static final ProcessHandle doDetect$lambda$0(ProcessHandle it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.parent().orElse(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean detectors$lambda$0(String command, List args) {
        String it;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (StringsKt.contains$default((CharSequence)command, (CharSequence)"jupyter-notebook", (boolean)false, (int)2, null)) return true;
        Iterable $this$any$iv = args;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (!StringsKt.contains$default((CharSequence)it, (CharSequence)"jupyter-notebook", (boolean)false, (int)2, null));
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean detectors$lambda$1(String command, List args) {
        String it;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (StringsKt.contains$default((CharSequence)command, (CharSequence)"jupyter-lab", (boolean)false, (int)2, null)) return true;
        Iterable $this$any$iv = args;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (!StringsKt.contains$default((CharSequence)it, (CharSequence)"jupyter-lab", (boolean)false, (int)2, null));
        return true;
    }

    private static final boolean detectors$lambda$2(String command, List list) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)list, (String)"<unused var>");
        return StringsKt.endsWith$default((String)command, (String)"idea64.exe", (boolean)false, (int)2, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\bb\u0018\u00002\u00020\u0001J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\f\u00c0\u0006\u0003"}, d2={"Lorg/jetbrains/kotlinx/jupyter/util/JupyterClientDetector$Detector;", "", "type", "Lorg/jetbrains/kotlinx/jupyter/api/JupyterClientType;", "getType", "()Lorg/jetbrains/kotlinx/jupyter/api/JupyterClientType;", "isThisClient", "", "command", "", "arguments", "", "shared-compiler"})
    private static interface Detector {
        @NotNull
        public JupyterClientType getType();

        public boolean isThisClient(@NotNull String var1, @NotNull List<String> var2);
    }
}

