/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

class RegularEnumSet<E extends Enum<E>>
extends EnumSet<E> {
    private static final long serialVersionUID = 3411599620347842686L;
    private long elements = 0L;

    RegularEnumSet(Class<E> clazz, Enum<?>[] enumArray) {
        super(clazz, enumArray);
    }

    @Override
    void addRange(E e, E e2) {
        this.elements = -1L >>> ((Enum)e).ordinal() - ((Enum)e2).ordinal() - 1 << ((Enum)e).ordinal();
    }

    @Override
    void addAll() {
        if (this.universe.length != 0) {
            this.elements = -1L >>> -this.universe.length;
        }
    }

    @Override
    void complement() {
        if (this.universe.length != 0) {
            this.elements ^= 0xFFFFFFFFFFFFFFFFL;
            this.elements &= -1L >>> -this.universe.length;
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new EnumSetIterator();
    }

    @Override
    public int size() {
        return Long.bitCount(this.elements);
    }

    @Override
    public boolean isEmpty() {
        return this.elements == 0L;
    }

    @Override
    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        Class<?> clazz = object.getClass();
        if (clazz != this.elementType && clazz.getSuperclass() != this.elementType) {
            return false;
        }
        return (this.elements & 1L << ((Enum)object).ordinal()) != 0L;
    }

    @Override
    public boolean add(E e) {
        this.typeCheck(e);
        long l = this.elements;
        this.elements |= 1L << ((Enum)e).ordinal();
        return this.elements != l;
    }

    @Override
    public boolean remove(Object object) {
        if (object == null) {
            return false;
        }
        Class<?> clazz = object.getClass();
        if (clazz != this.elementType && clazz.getSuperclass() != this.elementType) {
            return false;
        }
        long l = this.elements;
        this.elements &= 1L << ((Enum)object).ordinal() ^ 0xFFFFFFFFFFFFFFFFL;
        return this.elements != l;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (!(collection instanceof RegularEnumSet)) {
            return super.containsAll(collection);
        }
        RegularEnumSet regularEnumSet = (RegularEnumSet)collection;
        if (regularEnumSet.elementType != this.elementType) {
            return regularEnumSet.isEmpty();
        }
        return (regularEnumSet.elements & (this.elements ^ 0xFFFFFFFFFFFFFFFFL)) == 0L;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        if (!(collection instanceof RegularEnumSet)) {
            return super.addAll(collection);
        }
        RegularEnumSet regularEnumSet = (RegularEnumSet)collection;
        if (regularEnumSet.elementType != this.elementType) {
            if (regularEnumSet.isEmpty()) {
                return false;
            }
            throw new ClassCastException(regularEnumSet.elementType + " != " + this.elementType);
        }
        long l = this.elements;
        this.elements |= regularEnumSet.elements;
        return this.elements != l;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        if (!(collection instanceof RegularEnumSet)) {
            return super.removeAll(collection);
        }
        RegularEnumSet regularEnumSet = (RegularEnumSet)collection;
        if (regularEnumSet.elementType != this.elementType) {
            return false;
        }
        long l = this.elements;
        this.elements &= regularEnumSet.elements ^ 0xFFFFFFFFFFFFFFFFL;
        return this.elements != l;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        if (!(collection instanceof RegularEnumSet)) {
            return super.retainAll(collection);
        }
        RegularEnumSet regularEnumSet = (RegularEnumSet)collection;
        if (regularEnumSet.elementType != this.elementType) {
            boolean bl = this.elements != 0L;
            this.elements = 0L;
            return bl;
        }
        long l = this.elements;
        this.elements &= regularEnumSet.elements;
        return this.elements != l;
    }

    @Override
    public void clear() {
        this.elements = 0L;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof RegularEnumSet)) {
            return super.equals(object);
        }
        RegularEnumSet regularEnumSet = (RegularEnumSet)object;
        if (regularEnumSet.elementType != this.elementType) {
            return this.elements == 0L && regularEnumSet.elements == 0L;
        }
        return regularEnumSet.elements == this.elements;
    }

    private class EnumSetIterator<E extends Enum<E>>
    implements Iterator<E> {
        long unseen;
        long lastReturned = 0L;

        EnumSetIterator() {
            this.unseen = RegularEnumSet.this.elements;
        }

        @Override
        public boolean hasNext() {
            return this.unseen != 0L;
        }

        @Override
        public E next() {
            if (this.unseen == 0L) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.unseen & -this.unseen;
            this.unseen -= this.lastReturned;
            return (E)RegularEnumSet.this.universe[Long.numberOfTrailingZeros(this.lastReturned)];
        }

        @Override
        public void remove() {
            if (this.lastReturned == 0L) {
                throw new IllegalStateException();
            }
            RegularEnumSet.this.elements = RegularEnumSet.this.elements & (this.lastReturned ^ 0xFFFFFFFFFFFFFFFFL);
            this.lastReturned = 0L;
        }
    }
}

