/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public abstract class ConvertToDataLayerAction<T extends Layer>
extends AbstractAction {
    protected final transient T layer;

    protected ConvertToDataLayerAction(T layer) {
        super(I18n.tr("Convert to data layer", new Object[0]));
        new ImageProvider("converttoosm").getResource().attachImageIcon(this, true);
        this.layer = layer;
        this.putValue("help", HelpUtil.ht("/Action/ConvertToDataLayer"));
    }

    public abstract DataSet convert();

    @Override
    public void actionPerformed(ActionEvent e) {
        JPanel msg = new JPanel(new GridBagLayout());
        msg.add((Component)new JLabel(I18n.tr("<html>Upload of unprocessed GPS data as map data is considered harmful.<br>If you want to upload traces, look here:</html>", new Object[0])), GBC.eol());
        msg.add((Component)new UrlLabel(Config.getUrls().getOSMWebsite() + "/traces", 2), GBC.eop());
        if (!ConditionalOptionPaneUtil.showConfirmationDialog("convert_to_data", MainApplication.getMainFrame(), msg, I18n.tr("Warning", new Object[0]), 2, 2, 0)) {
            return;
        }
        DataSet ds = this.convert();
        if (ds != null) {
            OsmDataLayer osmLayer = new OsmDataLayer(ds, I18n.tr("Converted from: {0}", ((Layer)this.layer).getName()), null);
            if (((Layer)this.layer).getAssociatedFile() != null) {
                osmLayer.setAssociatedFile(new File(((Layer)this.layer).getAssociatedFile().getParentFile(), ((Layer)this.layer).getAssociatedFile().getName() + ".osm"));
            }
            osmLayer.setUploadDiscouraged(true);
            MainApplication.getLayerManager().addLayer(osmLayer, false);
            MainApplication.getLayerManager().removeLayer((Layer)this.layer);
        }
    }
}

