/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.httpcore;

import io.undertow.httpcore.UndertowOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class UndertowOptionMap
implements Iterable<Map.Entry<UndertowOption<?>, Object>> {
    public static final UndertowOptionMap EMPTY = new UndertowOptionMap(Collections.emptyMap());
    private final Map<UndertowOption<?>, Object> values;

    UndertowOptionMap(Map<UndertowOption<?>, Object> values) {
        this.values = values;
    }

    public <T> T get(UndertowOption<T> option, T defaultValue) {
        return (T)this.values.getOrDefault(option, defaultValue);
    }

    public boolean get(UndertowOption<Boolean> option, boolean defaultValue) {
        return (Boolean)this.values.getOrDefault(option, defaultValue);
    }

    public <T> T get(UndertowOption<T> option) {
        return (T)this.values.get(option);
    }

    public boolean contains(UndertowOption<?> option) {
        return this.values.containsKey(option);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Iterator<Map.Entry<UndertowOption<?>, Object>> iterator() {
        return this.values.entrySet().iterator();
    }

    public static <T> UndertowOptionMap create(UndertowOption<T> key, T val) {
        return UndertowOptionMap.builder().set(key, val).getMap();
    }

    public static <T1, T2> UndertowOptionMap create(UndertowOption<T1> key1, T1 val1, UndertowOption<T2> key2, T2 val2) {
        return UndertowOptionMap.builder().set(key1, val1).set(key2, val2).getMap();
    }

    public static class Builder {
        private final Map<UndertowOption<?>, Object> values = new HashMap();

        public <T> Builder set(UndertowOption<T> option, T value) {
            this.values.put(option, value);
            return this;
        }

        public Builder addAll(UndertowOptionMap workerOptions) {
            this.values.putAll(workerOptions.values);
            return this;
        }

        public UndertowOptionMap getMap() {
            return new UndertowOptionMap(new HashMap(this.values));
        }
    }
}

