/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.web;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class ResponseWrapper
extends HttpServletResponseWrapper {
    private final ByteArrayOutputStream capture;
    private ServletOutputStream output;

    public ResponseWrapper(HttpServletResponse response) {
        super(response);
        this.capture = new ByteArrayOutputStream(response.getBufferSize());
    }

    public ServletOutputStream getOutputStream() {
        if (this.output == null) {
            this.output = new ServletOutputStream(){

                public boolean isReady() {
                    return true;
                }

                public void setWriteListener(WriteListener writeListener) {
                }

                public void write(int b) {
                    ResponseWrapper.this.capture.write(b);
                }

                public void flush() throws IOException {
                    ResponseWrapper.this.capture.flush();
                }

                public void close() throws IOException {
                    ResponseWrapper.this.capture.close();
                }
            };
        }
        return this.output;
    }

    public void flushBuffer() throws IOException {
        super.flushBuffer();
        if (this.output != null) {
            this.output.flush();
        }
    }

    public byte[] getCapture() throws IOException {
        if (this.output != null) {
            this.output.close();
            return this.capture.toByteArray();
        }
        return null;
    }
}

