/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.util.zip;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class AutoSTOREDZipOutputStream
extends ZipOutputStream {
    private CRC32 crc = new CRC32();
    private ZipEntry delayedEntry;
    private AccessBufByteArrayOutputStream delayedOutputStream;

    public AutoSTOREDZipOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void putNextEntry(ZipEntry e) throws IOException {
        if (e.getMethod() != 0) {
            super.putNextEntry(e);
        } else {
            this.delayedEntry = e;
            if (this.delayedOutputStream == null) {
                this.delayedOutputStream = new AccessBufByteArrayOutputStream();
            }
        }
    }

    @Override
    public void closeEntry() throws IOException {
        ZipEntry delayedEntry = this.delayedEntry;
        if (delayedEntry != null) {
            AccessBufByteArrayOutputStream delayedOutputStream = this.delayedOutputStream;
            byte[] buf = delayedOutputStream.getBuf();
            int size = delayedOutputStream.size();
            delayedEntry.setSize(size);
            delayedEntry.setCompressedSize(size);
            this.crc.reset();
            this.crc.update(buf, 0, size);
            delayedEntry.setCrc(this.crc.getValue());
            super.putNextEntry(delayedEntry);
            super.write(buf, 0, size);
            this.delayedEntry = null;
            delayedOutputStream.reset();
        }
        super.closeEntry();
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (this.delayedEntry != null) {
            this.delayedOutputStream.write(b, off, len);
        } else {
            super.write(b, off, len);
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.delayedEntry != null) {
            this.delayedOutputStream.write(b);
        } else {
            super.write(b);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.delayedEntry != null) {
            this.delayedOutputStream.write(b);
        } else {
            super.write(b);
        }
    }

    @Override
    public void close() throws IOException {
        this.delayedOutputStream = null;
        super.close();
    }

    static class AccessBufByteArrayOutputStream
    extends ByteArrayOutputStream {
        AccessBufByteArrayOutputStream() {
        }

        public byte[] getBuf() {
            return this.buf;
        }
    }
}

