/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.VariantIdentityUniquenessVerifier;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.LocalVariantGraphResolveStateBuilder;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.internal.Describables;
import org.gradle.internal.component.local.model.DefaultLocalComponentGraphResolveState;
import org.gradle.internal.component.local.model.DefaultLocalVariantGraphResolveState;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveMetadata;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.component.local.model.LocalVariantGraphResolveMetadata;
import org.gradle.internal.component.local.model.LocalVariantGraphResolveState;
import org.gradle.internal.component.local.model.LocalVariantGraphResolveStateFactory;
import org.gradle.internal.component.local.model.LocalVariantMetadata;
import org.gradle.internal.component.model.ComponentIdGenerator;
import org.gradle.internal.model.CalculatedValue;
import org.gradle.internal.model.CalculatedValueContainer;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.InMemoryCacheFactory;
import org.gradle.internal.model.ModelContainer;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.BuildTree.class})
public class LocalComponentGraphResolveStateFactory {
    private final AttributeDesugaring attributeDesugaring;
    private final ComponentIdGenerator idGenerator;
    private final LocalVariantGraphResolveStateBuilder metadataBuilder;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private final InMemoryCacheFactory cacheFactory;

    public LocalComponentGraphResolveStateFactory(AttributeDesugaring attributeDesugaring, ComponentIdGenerator idGenerator, LocalVariantGraphResolveStateBuilder metadataBuilder, CalculatedValueContainerFactory calculatedValueContainerFactory, InMemoryCacheFactory cacheFactory) {
        this.attributeDesugaring = attributeDesugaring;
        this.idGenerator = idGenerator;
        this.metadataBuilder = metadataBuilder;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        this.cacheFactory = cacheFactory;
    }

    public LocalComponentGraphResolveState realizedStateFor(LocalComponentGraphResolveMetadata metadata, List<? extends LocalVariantGraphResolveState> variants) {
        RealizedListVariantFactory configurationFactory = new RealizedListVariantFactory(variants);
        return this.createLocalComponentState(false, metadata, configurationFactory);
    }

    public LocalVariantGraphResolveState realizedVariantStateFor(ComponentIdentifier componentId, LocalVariantGraphResolveMetadata metadata, DefaultLocalVariantGraphResolveState.VariantDependencyMetadata dependencyMetadata, Set<LocalVariantMetadata> variants) {
        CalculatedValueContainer calculatedDependencies = this.calculatedValueContainerFactory.create(Describables.of((Object)"dependencies for", (Object)metadata), context -> dependencyMetadata);
        return new DefaultLocalVariantGraphResolveState(this.idGenerator.nextVariantId(), componentId, metadata, this.idGenerator, this.calculatedValueContainerFactory, (CalculatedValue<DefaultLocalVariantGraphResolveState.VariantDependencyMetadata>)calculatedDependencies, variants);
    }

    public LocalComponentGraphResolveState stateFor(ModelContainer<?> model, LocalComponentGraphResolveMetadata metadata, ConfigurationsProvider configurations) {
        return this.lazyStateFor(model, metadata, configurations, false);
    }

    public LocalComponentGraphResolveState adHocStateFor(ModelContainer<?> model, LocalComponentGraphResolveMetadata metadata, ConfigurationsProvider configurations) {
        return this.lazyStateFor(model, metadata, configurations, true);
    }

    private LocalComponentGraphResolveState lazyStateFor(ModelContainer<?> model, LocalComponentGraphResolveMetadata metadata, ConfigurationsProvider configurations, boolean adHoc) {
        ConfigurationsProviderVariantFactory variantsFactory = new ConfigurationsProviderVariantFactory(metadata.getId(), configurations, this.metadataBuilder, model, this.calculatedValueContainerFactory);
        return this.createLocalComponentState(adHoc, metadata, variantsFactory);
    }

    private DefaultLocalComponentGraphResolveState createLocalComponentState(boolean adHoc, LocalComponentGraphResolveMetadata metadata, LocalVariantGraphResolveStateFactory variantsFactory) {
        return new DefaultLocalComponentGraphResolveState(this.idGenerator.nextComponentId(), metadata, this.attributeDesugaring, this.idGenerator, adHoc, variantsFactory, this.calculatedValueContainerFactory, this.cacheFactory, null);
    }

    private static class RealizedListVariantFactory
    implements LocalVariantGraphResolveStateFactory {
        private final List<? extends LocalVariantGraphResolveState> variants;

        public RealizedListVariantFactory(List<? extends LocalVariantGraphResolveState> variants) {
            this.variants = variants;
        }

        @Override
        public void visitConsumableVariants(Consumer<LocalVariantGraphResolveState> visitor) {
            for (LocalVariantGraphResolveState localVariantGraphResolveState : this.variants) {
                visitor.accept(localVariantGraphResolveState);
            }
        }

        @Override
        public void invalidate() {
        }

        @Override
        public LocalVariantGraphResolveState getVariantByConfigurationName(String name) {
            return this.variants.stream().filter(variant -> name.equals(variant.getMetadata().getConfigurationName())).findFirst().orElse(null);
        }
    }

    private static class ConfigurationsProviderVariantFactory
    implements LocalVariantGraphResolveStateFactory {
        private final ComponentIdentifier componentId;
        private final ConfigurationsProvider configurationsProvider;
        private final LocalVariantGraphResolveStateBuilder stateBuilder;
        private final ModelContainer<?> model;
        private final CalculatedValueContainerFactory calculatedValueContainerFactory;
        private final LocalVariantGraphResolveStateBuilder.DependencyCache cache;

        public ConfigurationsProviderVariantFactory(ComponentIdentifier componentId, ConfigurationsProvider configurationsProvider, LocalVariantGraphResolveStateBuilder stateBuilder, ModelContainer<?> model, CalculatedValueContainerFactory calculatedValueContainerFactory) {
            this.componentId = componentId;
            this.configurationsProvider = configurationsProvider;
            this.stateBuilder = stateBuilder;
            this.model = model;
            this.calculatedValueContainerFactory = calculatedValueContainerFactory;
            this.cache = new LocalVariantGraphResolveStateBuilder.DependencyCache();
        }

        @Override
        public void visitConsumableVariants(Consumer<LocalVariantGraphResolveState> visitor) {
            this.model.applyToMutableState(p -> {
                VariantIdentityUniquenessVerifier.buildReport(this.configurationsProvider).assertNoConflicts();
                this.configurationsProvider.visitConsumable(configuration -> visitor.accept(this.createVariantState((ConfigurationInternal)configuration)));
            });
        }

        @Override
        public void invalidate() {
            this.cache.invalidate();
        }

        @Override
        @Nullable
        public LocalVariantGraphResolveState getVariantByConfigurationName(String name) {
            return (LocalVariantGraphResolveState)this.model.fromMutableState(p -> {
                ConfigurationInternal configuration = this.configurationsProvider.findByName(name);
                if (configuration == null) {
                    return null;
                }
                return this.createVariantState(configuration);
            });
        }

        private LocalVariantGraphResolveState createVariantState(ConfigurationInternal configuration) {
            return this.stateBuilder.createConsumableVariantState(configuration, this.componentId, this.cache, this.model, this.calculatedValueContainerFactory);
        }
    }
}

