/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.internal.validation;

import java.util.Objects;
import org.gradle.api.artifacts.ModuleVersionIdentifier;

final class PublicationWithProject {
    private final String projectDisplayText;
    private final String publicationName;
    private final ModuleVersionIdentifier coordinates;

    public PublicationWithProject(String projectDisplayText, String publicationName, ModuleVersionIdentifier coordinates) {
        this.projectDisplayText = projectDisplayText;
        this.publicationName = publicationName;
        this.coordinates = coordinates;
    }

    public ModuleVersionIdentifier getCoordinates() {
        return this.coordinates;
    }

    public String toString() {
        return "'" + this.publicationName + "' in " + this.projectDisplayText;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicationWithProject that = (PublicationWithProject)o;
        return Objects.equals(this.projectDisplayText, that.projectDisplayText) && Objects.equals(this.publicationName, that.publicationName) && Objects.equals(this.coordinates, that.coordinates);
    }

    public int hashCode() {
        return Objects.hash(this.projectDisplayText, this.publicationName, this.coordinates);
    }
}

