/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSourceUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;

public class PsiExpressionListImpl
extends CompositePsiElement
implements PsiExpressionList {
    private static final Logger LOG = Logger.getInstance(PsiExpressionListImpl.class);
    private volatile PsiExpression[] myExpressions;

    public PsiExpressionListImpl() {
        super(JavaElementType.EXPRESSION_LIST);
    }

    @Override
    public PsiExpression @NotNull [] getExpressions() {
        PsiExpression[] expressions = this.myExpressions;
        if (expressions == null && (expressions = (PsiExpression[])this.getChildrenAsPsiElements(ElementType.EXPRESSION_BIT_SET, PsiExpression.ARRAY_FACTORY)).length > 10) {
            this.myExpressions = expressions;
        }
        if (expressions == null) {
            PsiExpressionListImpl.$$$reportNull$$$0(0);
        }
        return expressions;
    }

    public void clearCaches() {
        super.clearCaches();
        this.myExpressions = null;
    }

    @Override
    public int getExpressionCount() {
        PsiExpression[] expressions = this.myExpressions;
        if (expressions != null) {
            return expressions.length;
        }
        return this.countChildren(ElementType.EXPRESSION_BIT_SET);
    }

    @Override
    public boolean isEmpty() {
        return this.findChildByType(ElementType.EXPRESSION_BIT_SET) == null;
    }

    @Override
    public PsiType @NotNull [] getExpressionTypes() {
        PsiExpression[] expressions = this.getExpressions();
        PsiType[] types = PsiType.createArray(expressions.length);
        for (int i = 0; i < types.length; ++i) {
            types[i] = expressions[i].getType();
        }
        if (types == null) {
            PsiExpressionListImpl.$$$reportNull$$$0(1);
        }
        return types;
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            case 24: {
                return this.getFirstChildNode() != null && this.getFirstChildNode().getElementType() == JavaTokenType.LPARENTH ? this.getFirstChildNode() : null;
            }
            case 25: {
                if (this.getLastChildNode() != null && this.getLastChildNode().getElementType() == JavaTokenType.RPARENTH) {
                    return this.getLastChildNode();
                }
                return null;
            }
        }
        return null;
    }

    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiExpressionListImpl.$$$reportNull$$$0(2);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaTokenType.COMMA) {
            return 23;
        }
        if (i == JavaTokenType.LPARENTH) {
            return 24;
        }
        if (i == JavaTokenType.RPARENTH) {
            return 25;
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 59;
        }
        return 0;
    }

    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before) {
        CharTable treeCharTab = SharedImplUtil.findCharTableByTree((ASTNode)this);
        if (anchor == null) {
            LeafElement rparenth;
            LeafElement lparenth;
            if (before == null || before.booleanValue()) {
                anchor = this.findChildByRole(25);
                if (anchor == null) {
                    lparenth = Factory.createSingleLeafElement((IElementType)JavaTokenType.LPARENTH, (CharSequence)"(", (int)0, (int)1, (CharTable)treeCharTab, (PsiManager)this.getManager());
                    super.addInternal((TreeElement)lparenth, (ASTNode)lparenth, null, Boolean.FALSE);
                    rparenth = Factory.createSingleLeafElement((IElementType)JavaTokenType.RPARENTH, (CharSequence)")", (int)0, (int)1, (CharTable)treeCharTab, (PsiManager)this.getManager());
                    super.addInternal((TreeElement)rparenth, (ASTNode)rparenth, null, Boolean.TRUE);
                    anchor = this.findChildByRole(25);
                    LOG.assertTrue(anchor != null);
                }
                before = Boolean.TRUE;
            } else {
                anchor = this.findChildByRole(24);
                if (anchor == null) {
                    lparenth = Factory.createSingleLeafElement((IElementType)JavaTokenType.LPARENTH, (CharSequence)"(", (int)0, (int)1, (CharTable)treeCharTab, (PsiManager)this.getManager());
                    super.addInternal((TreeElement)lparenth, (ASTNode)lparenth, null, Boolean.FALSE);
                    rparenth = Factory.createSingleLeafElement((IElementType)JavaTokenType.RPARENTH, (CharSequence)")", (int)0, (int)1, (CharTable)treeCharTab, (PsiManager)this.getManager());
                    super.addInternal((TreeElement)rparenth, (ASTNode)rparenth, null, Boolean.TRUE);
                    anchor = this.findChildByRole(24);
                    LOG.assertTrue(anchor != null);
                }
                before = Boolean.FALSE;
            }
        }
        TreeElement firstAdded = super.addInternal(first, last, anchor, before);
        TreeElement element = first;
        while (true) {
            if (ElementType.EXPRESSION_BIT_SET.contains(element.getElementType())) {
                JavaSourceUtil.addSeparatingComma((CompositeElement)this, (ASTNode)element, ElementType.EXPRESSION_BIT_SET);
                break;
            }
            if (element == last) break;
            element = element.getTreeNext();
        }
        return firstAdded;
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            PsiExpressionListImpl.$$$reportNull$$$0(3);
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            JavaSourceUtil.deleteSeparatingComma((CompositeElement)this, child);
        }
        super.deleteChildInternal(child);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiExpressionListImpl.$$$reportNull$$$0(4);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitExpressionList(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiExpressionList";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/java/PsiExpressionListImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionTypes";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/java/PsiExpressionListImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getChildRole";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

