/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.derby.catalog.types.ReferencedColumnsDescriptorImpl;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AccessPathImpl;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.BaseColumnNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.HashTableNode;
import org.apache.derby.impl.sql.compile.JoinNode;
import org.apache.derby.impl.sql.compile.MaterializeResultSetNode;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ReferencedTablesVisitor;
import org.apache.derby.impl.sql.compile.RemapCRsVisitor;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RowResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SetOperatorNode;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UnionNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class ProjectRestrictNode
extends SingleChildResultSetNode {
    ValueNode restriction;
    ValueNode constantRestriction = null;
    PredicateList restrictionList;
    SubqueryList projectSubquerys;
    SubqueryList restrictSubquerys;
    private boolean accessPathModified;
    private boolean getTableNumberHere;
    private boolean validatingCheckConstraints = false;
    private String validatingBaseTableUUIDString;

    ProjectRestrictNode(ResultSetNode childResult, ResultColumnList projection, ValueNode restriction, PredicateList restrictionList, SubqueryList projectSubquerys, SubqueryList restrictSubquerys, Properties tableProperties, ContextManager cm) {
        super(childResult, tableProperties, cm);
        this.setResultColumns(projection);
        this.restriction = restriction;
        this.restrictionList = restrictionList;
        this.projectSubquerys = projectSubquerys;
        this.restrictSubquerys = restrictSubquerys;
        if (tableProperties != null && childResult instanceof Optimizable) {
            ((Optimizable)((Object)childResult)).setProperties(this.getProperties());
            this.setProperties(null);
        }
    }

    @Override
    public boolean nextAccessPath(Optimizer optimizer, OptimizablePredicateList predList, RowOrdering rowOrdering) throws StandardException {
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).nextAccessPath(optimizer, this.restrictionList, rowOrdering);
        }
        return super.nextAccessPath(optimizer, predList, rowOrdering);
    }

    @Override
    public void rememberAsBest(int planType, Optimizer optimizer) throws StandardException {
        super.rememberAsBest(planType, optimizer);
        if (this.childResult instanceof Optimizable) {
            ((Optimizable)((Object)this.childResult)).rememberAsBest(planType, optimizer);
        }
    }

    @Override
    public void startOptimizing(Optimizer optimizer, RowOrdering rowOrdering) {
        if (this.childResult instanceof Optimizable) {
            ((Optimizable)((Object)this.childResult)).startOptimizing(optimizer, rowOrdering);
        } else {
            super.startOptimizing(optimizer, rowOrdering);
        }
    }

    @Override
    public int getTableNumber() {
        if (this.getTableNumberHere) {
            return super.getTableNumber();
        }
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).getTableNumber();
        }
        return super.getTableNumber();
    }

    @Override
    public CostEstimate optimizeIt(Optimizer optimizer, OptimizablePredicateList predList, CostEstimate outerCost, RowOrdering rowOrdering) throws StandardException {
        this.setCostEstimate(this.getCostEstimate(optimizer));
        this.updateBestPlanMap((short)1, this);
        if (this.childResult instanceof Optimizable) {
            CostEstimate childCost = ((Optimizable)((Object)this.childResult)).optimizeIt(optimizer, this.restrictionList, outerCost, rowOrdering);
            this.getCostEstimate().setCost(childCost.getEstimatedCost(), childCost.rowCount(), childCost.singleScanRowCount());
        } else if (!this.accessPathModified) {
            if (!(this.childResult instanceof SelectNode) && !(this.childResult instanceof RowResultSetNode)) {
                SanityManager.THROWASSERT((String)("childResult is expected to be instanceof SelectNode or RowResultSetNode - it is a " + this.childResult.getClass().getName()));
            }
            this.childResult = this.childResult.optimize(optimizer.getDataDictionary(), this.restrictionList, outerCost.rowCount());
            CostEstimate childCost = this.childResult.getCostEstimate();
            this.getCostEstimate().setCost(childCost.getEstimatedCost(), childCost.rowCount(), childCost.singleScanRowCount());
            optimizer.considerCost(this, this.restrictionList, this.getCostEstimate(), outerCost);
        }
        return this.getCostEstimate();
    }

    @Override
    public boolean feasibleJoinStrategy(OptimizablePredicateList predList, Optimizer optimizer) throws StandardException {
        if (this.childResult instanceof Optimizable) {
            if (this.childResult instanceof UnionNode) {
                ((UnionNode)this.childResult).pullOptPredicates(this.restrictionList);
            }
            return ((Optimizable)((Object)this.childResult)).feasibleJoinStrategy(this.restrictionList, optimizer);
        }
        return super.feasibleJoinStrategy(this.restrictionList, optimizer);
    }

    @Override
    public AccessPath getCurrentAccessPath() {
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).getCurrentAccessPath();
        }
        return super.getCurrentAccessPath();
    }

    @Override
    public AccessPath getBestAccessPath() {
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).getBestAccessPath();
        }
        return super.getBestAccessPath();
    }

    @Override
    public AccessPath getBestSortAvoidancePath() {
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).getBestSortAvoidancePath();
        }
        return super.getBestSortAvoidancePath();
    }

    @Override
    public AccessPath getTrulyTheBestAccessPath() {
        if (this.hasTrulyTheBestAccessPath) {
            return super.getTrulyTheBestAccessPath();
        }
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).getTrulyTheBestAccessPath();
        }
        return super.getTrulyTheBestAccessPath();
    }

    @Override
    public void rememberSortAvoidancePath() {
        if (this.childResult instanceof Optimizable) {
            ((Optimizable)((Object)this.childResult)).rememberSortAvoidancePath();
        } else {
            super.rememberSortAvoidancePath();
        }
    }

    @Override
    public boolean considerSortAvoidancePath() {
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).considerSortAvoidancePath();
        }
        return super.considerSortAvoidancePath();
    }

    @Override
    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        SanityManager.ASSERT((boolean)(optimizablePredicate instanceof Predicate), (String)"optimizablePredicate expected to be instanceof Predicate");
        SanityManager.ASSERT((!optimizablePredicate.hasSubquery() && !optimizablePredicate.hasMethodCall() ? 1 : 0) != 0, (String)"optimizablePredicate either has a subquery or a method call");
        if (this.restrictionList == null) {
            this.restrictionList = new PredicateList(this.getContextManager());
        }
        this.restrictionList.addPredicate((Predicate)optimizablePredicate);
        Predicate pred = (Predicate)optimizablePredicate;
        if (!pred.remapScopedPred()) {
            RemapCRsVisitor rcrv = new RemapCRsVisitor(true);
            pred.getAndNode().accept(rcrv);
        }
        return true;
    }

    @Override
    public void pullOptPredicates(OptimizablePredicateList optimizablePredicates) throws StandardException {
        if (this.restrictionList != null && !this.isNotExists()) {
            if (this.childResult instanceof UnionNode) {
                ((UnionNode)this.childResult).pullOptPredicates(this.restrictionList);
            }
            RemapCRsVisitor rcrv = new RemapCRsVisitor(false);
            for (int i = this.restrictionList.size() - 1; i >= 0; --i) {
                OptimizablePredicate optPred = this.restrictionList.getOptPredicate(i);
                ((Predicate)optPred).getAndNode().accept(rcrv);
                optimizablePredicates.addOptPredicate(optPred);
                this.restrictionList.removeOptPredicate(i);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Optimizable modifyAccessPath(JBitSet outerTables) throws StandardException {
        boolean hashJoinWithThisPRN;
        boolean origChildOptimizable = true;
        if (this.accessPathModified) {
            return this;
        }
        boolean alreadyPushed = false;
        if (!(this.childResult instanceof Optimizable)) {
            origChildOptimizable = false;
            this.childResult = this.childResult.modifyAccessPaths(this.restrictionList);
            this.hasTrulyTheBestAccessPath = true;
            if (!this.trulyTheBestAccessPath.getJoinStrategy().isHashJoin()) return (Optimizable)((Object)this.considerMaterialization(outerTables));
            SanityManager.ASSERT((this.restrictionList != null ? 1 : 0) != 0, (String)"restrictionList expected to be non-null");
            SanityManager.ASSERT((this.restrictionList.size() != 0 ? 1 : 0) != 0, (String)"restrictionList.size() expected to be non-zero");
            this.getTableNumberHere = true;
        } else if (!(this.childResult instanceof FromBaseTable)) {
            if (this.trulyTheBestAccessPath.getJoinStrategy() == null) {
                this.trulyTheBestAccessPath = (AccessPathImpl)((Optimizable)((Object)this.childResult)).getTrulyTheBestAccessPath();
            }
            if (this.childResult instanceof SetOperatorNode) {
                this.childResult = (ResultSetNode)((Object)((SetOperatorNode)this.childResult).modifyAccessPath(outerTables, this.restrictionList));
                alreadyPushed = true;
            } else {
                this.childResult = (ResultSetNode)((Object)((FromTable)this.childResult).modifyAccessPath(outerTables));
            }
        }
        boolean bl = hashJoinWithThisPRN = this.hasTrulyTheBestAccessPath && this.trulyTheBestAccessPath.getJoinStrategy() != null && this.trulyTheBestAccessPath.getJoinStrategy().isHashJoin();
        if (!(this.restrictionList == null || alreadyPushed || hashJoinWithThisPRN || this.validatingCheckConstraints)) {
            this.restrictionList.pushUsefulPredicates((Optimizable)((Object)this.childResult));
        }
        if (origChildOptimizable) {
            this.childResult = this.childResult.changeAccessPath();
        }
        this.accessPathModified = true;
        if (this.trulyTheBestAccessPath.getJoinStrategy() == null || !this.trulyTheBestAccessPath.getJoinStrategy().isHashJoin()) return (Optimizable)((Object)this.considerMaterialization(outerTables));
        return this.replaceWithHashTableNode();
    }

    private Optimizable replaceWithHashTableNode() throws StandardException {
        if (this.hasTrulyTheBestAccessPath) {
            ((FromTable)this.childResult).trulyTheBestAccessPath = (AccessPathImpl)this.getTrulyTheBestAccessPath();
            if (this.childResult instanceof SingleChildResultSetNode) {
                ((SingleChildResultSetNode)this.childResult).hasTrulyTheBestAccessPath = this.hasTrulyTheBestAccessPath;
                this.childResult.getReferencedTableMap().set(this.tableNumber);
            }
        }
        PredicateList searchRestrictionList = new PredicateList(this.getContextManager());
        PredicateList joinQualifierList = new PredicateList(this.getContextManager());
        PredicateList requalificationRestrictionList = new PredicateList(this.getContextManager());
        this.trulyTheBestAccessPath.getJoinStrategy().divideUpPredicateLists(this, this.restrictionList, searchRestrictionList, joinQualifierList, requalificationRestrictionList, this.getDataDictionary());
        this.restrictionList = new PredicateList(this.getContextManager());
        for (Predicate p : searchRestrictionList) {
            requalificationRestrictionList.removeOptPredicate(p);
        }
        for (Predicate p : joinQualifierList) {
            requalificationRestrictionList.removeOptPredicate(p);
        }
        joinQualifierList.transferNonQualifiers(this, this.restrictionList);
        requalificationRestrictionList.copyPredicatesToOtherList(this.restrictionList);
        ResultColumnList htRCList = this.childResult.getResultColumns();
        this.childResult.setResultColumns(htRCList.copyListAndObjects());
        htRCList.genVirtualColumnNodes(this.childResult, this.childResult.getResultColumns(), false);
        RemapCRsVisitor rcrv = new RemapCRsVisitor(true);
        searchRestrictionList.accept(rcrv);
        this.childResult = new HashTableNode(this.childResult, this.tableProperties, htRCList, searchRestrictionList, joinQualifierList, this.trulyTheBestAccessPath, this.getCostEstimate(), this.projectSubquerys, this.restrictSubquerys, this.hashKeyColumns(), this.getContextManager());
        return this;
    }

    @Override
    public void verifyProperties(DataDictionary dDictionary) throws StandardException {
        if (this.childResult instanceof Optimizable) {
            ((Optimizable)((Object)this.childResult)).verifyProperties(dDictionary);
        } else {
            super.verifyProperties(dDictionary);
        }
    }

    @Override
    public boolean legalJoinOrder(JBitSet assignedTableMap) {
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).legalJoinOrder(assignedTableMap);
        }
        return true;
    }

    @Override
    public double uniqueJoin(OptimizablePredicateList predList) throws StandardException {
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).uniqueJoin(predList);
        }
        return super.uniqueJoin(predList);
    }

    PredicateList getRestrictionList() {
        return this.restrictionList;
    }

    @Override
    String getUserSpecifiedJoinStrategy() {
        if (this.childResult instanceof FromTable) {
            return ((FromTable)this.childResult).getUserSpecifiedJoinStrategy();
        }
        return this.userSpecifiedJoinStrategy;
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.restriction != null) {
            this.printLabel(depth, "restriction: ");
            this.restriction.treePrint(depth + 1);
        }
        if (this.restrictionList != null) {
            this.printLabel(depth, "restrictionList: ");
            this.restrictionList.treePrint(depth + 1);
        }
        if (this.projectSubquerys != null) {
            this.printLabel(depth, "projectSubquerys: ");
            this.projectSubquerys.treePrint(depth + 1);
        }
        if (this.restrictSubquerys != null) {
            this.printLabel(depth, "restrictSubquerys: ");
            this.restrictSubquerys.treePrint(depth + 1);
        }
    }

    @Override
    ResultSetNode preprocess(int numTables, GroupByList gbl, FromList fromList) throws StandardException {
        this.childResult = this.childResult.preprocess(numTables, gbl, fromList);
        this.setReferencedTableMap((JBitSet)this.childResult.getReferencedTableMap().clone());
        return this;
    }

    @Override
    void pushExpressions(PredicateList predicateList) throws StandardException {
        SelectNode childSelect;
        PredicateList pushPList;
        SanityManager.ASSERT((predicateList != null ? 1 : 0) != 0, (String)"predicateList is expected to be non-null");
        if (this.childResult instanceof JoinNode) {
            ((FromTable)this.childResult).pushExpressions(predicateList);
        }
        if ((pushPList = predicateList.getPushablePredicates(this.getReferencedTableMap())) != null && this.childResult instanceof SelectNode && !(childSelect = (SelectNode)this.childResult).hasWindows() && !childSelect.hasOffsetFetchFirst()) {
            pushPList.pushExpressionsIntoSelect((SelectNode)this.childResult, false);
        }
        if (pushPList != null && this.childResult instanceof UnionNode) {
            ((UnionNode)this.childResult).pushExpressions(pushPList);
        }
        if (this.restrictionList == null) {
            this.restrictionList = pushPList;
        } else if (pushPList != null && pushPList.size() != 0) {
            this.restrictionList.destructiveAppend(pushPList);
        }
    }

    @Override
    ResultSetNode addNewPredicate(Predicate predicate) throws StandardException {
        if (this.restrictionList == null) {
            this.restrictionList = new PredicateList(this.getContextManager());
        }
        this.restrictionList.addPredicate(predicate);
        return this;
    }

    @Override
    boolean flattenableInFromSubquery(FromList fromList) {
        return false;
    }

    @Override
    ResultSetNode ensurePredicateList(int numTables) throws StandardException {
        return this;
    }

    @Override
    ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicates, double outerRows) throws StandardException {
        this.childResult = this.childResult.optimize(dataDictionary, this.restrictionList, outerRows);
        this.setCostEstimate(this.getOptimizerFactory().getCostEstimate());
        this.getCostEstimate().setCost(this.childResult.getCostEstimate().getEstimatedCost(), this.childResult.getCostEstimate().rowCount(), this.childResult.getCostEstimate().singleScanRowCount());
        return this;
    }

    @Override
    CostEstimate getCostEstimate() {
        if (super.getCostEstimate() == null) {
            return this.childResult.getCostEstimate();
        }
        return super.getCostEstimate();
    }

    @Override
    CostEstimate getFinalCostEstimate() throws StandardException {
        if (this.getCandidateFinalCostEstimate() != null) {
            return this.getCandidateFinalCostEstimate();
        }
        if (this.childResult instanceof Optimizable) {
            this.setCandidateFinalCostEstimate(this.childResult.getFinalCostEstimate());
        } else {
            this.setCandidateFinalCostEstimate(this.getTrulyTheBestAccessPath().getCostEstimate());
        }
        return this.getCandidateFinalCostEstimate();
    }

    @Override
    void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.ASSERT((this.getResultColumns() != null ? 1 : 0) != 0, (String)"Tree structure bad");
        if (this.childResult instanceof FromVTI) {
            ((FromVTI)this.childResult).computeProjectionAndRestriction(this.restrictionList);
        }
        this.generateMinion(acb, mb, false);
    }

    @Override
    void generateResultSet(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.generateMinion(acb, mb, true);
    }

    private void generateMinion(ExpressionClassBuilder acb, MethodBuilder mb, boolean genChildResultSet) throws StandardException {
        if (this.restrictionList != null && this.restrictionList.size() > 0) {
            this.restrictionList.eliminateBooleanTrueAndBooleanTrue();
        }
        if (this.nopProjectRestrict()) {
            this.generateNOPProjectRestrict();
            if (genChildResultSet) {
                this.childResult.generateResultSet(acb, mb);
            } else {
                this.childResult.generate((ActivationClassBuilder)acb, mb);
            }
            this.setCostEstimate(this.childResult.getFinalCostEstimate());
            return;
        }
        if (this.restrictionList != null) {
            this.constantRestriction = this.restrictionList.restoreConstantPredicates();
            this.restrictionList.removeRedundantPredicates();
            this.restriction = this.restrictionList.restorePredicates();
            this.restrictionList = null;
        }
        ResultColumnList.ColumnMapping mappingArrays = this.getResultColumns().mapSourceColumns();
        int[] mapArray = mappingArrays.mapArray;
        boolean[] cloneMap = mappingArrays.cloneMap;
        int mapArrayItem = acb.addItem(new ReferencedColumnsDescriptorImpl(mapArray));
        int cloneMapItem = acb.addItem(cloneMap);
        boolean doesProjection = true;
        if (!this.reflectionNeededForProjection() && mapArray != null && mapArray.length == this.childResult.getResultColumns().size()) {
            int index;
            for (index = 0; index < mapArray.length && mapArray[index] == index + 1; ++index) {
            }
            if (index == mapArray.length) {
                doesProjection = false;
            }
        }
        acb.pushGetResultSetFactoryExpression(mb);
        if (genChildResultSet) {
            this.childResult.generateResultSet(acb, mb);
        } else {
            this.childResult.generate((ActivationClassBuilder)acb, mb);
        }
        this.assignResultSetNumber();
        if (this.projectSubquerys != null && this.projectSubquerys.size() > 0) {
            this.projectSubquerys.setPointOfAttachment(this.getResultSetNumber());
        }
        if (this.restrictSubquerys != null && this.restrictSubquerys.size() > 0) {
            this.restrictSubquerys.setPointOfAttachment(this.getResultSetNumber());
        }
        this.setCostEstimate(this.getFinalCostEstimate());
        if (this.restriction == null) {
            mb.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        } else {
            MethodBuilder userExprFun = acb.newUserExprFun();
            this.restriction.generateExpression(acb, userExprFun);
            userExprFun.methodReturn();
            userExprFun.complete();
            acb.pushMethodReference(mb, userExprFun);
        }
        if (this.reflectionNeededForProjection()) {
            this.getResultColumns().generateCore(acb, mb, false);
        } else {
            mb.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        }
        mb.push(this.getResultSetNumber());
        if (this.constantRestriction == null) {
            mb.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        } else {
            MethodBuilder userExprFun = acb.newUserExprFun();
            this.constantRestriction.generateExpression(acb, userExprFun);
            userExprFun.methodReturn();
            userExprFun.complete();
            acb.pushMethodReference(mb, userExprFun);
        }
        mb.push(mapArrayItem);
        mb.push(cloneMapItem);
        mb.push(this.getResultColumns().reusableResult());
        mb.push(doesProjection);
        mb.push(this.validatingCheckConstraints);
        if (this.validatingBaseTableUUIDString == null) {
            mb.push("NULL");
        } else {
            mb.push(this.validatingBaseTableUUIDString);
        }
        mb.push(this.getCostEstimate().rowCount());
        mb.push(this.getCostEstimate().getEstimatedCost());
        mb.callMethod((short)185, null, "getProjectRestrictResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 13);
    }

    boolean nopProjectRestrict() {
        if (this.restriction != null || this.constantRestriction != null || this.restrictionList != null && this.restrictionList.size() > 0) {
            return false;
        }
        ResultColumnList childColumns = this.childResult.getResultColumns();
        ResultColumnList PRNColumns = this.getResultColumns();
        return PRNColumns.nopProjection(childColumns);
    }

    void generateNOPProjectRestrict() throws StandardException {
        this.getResultColumns().setRedundant();
    }

    @Override
    ResultSetNode considerMaterialization(JBitSet outerTables) throws StandardException {
        this.childResult = this.childResult.considerMaterialization(outerTables);
        if (this.childResult.performMaterialization(outerTables)) {
            boolean emptyRestrictionList;
            ReferencedTablesVisitor rtv = new ReferencedTablesVisitor((JBitSet)this.childResult.getReferencedTableMap().clone());
            boolean bl = emptyRestrictionList = this.restrictionList == null || this.restrictionList.size() == 0;
            if (!emptyRestrictionList) {
                this.restrictionList.accept(rtv);
            }
            if (emptyRestrictionList || this.childResult.getReferencedTableMap().contains(rtv.getTableMap())) {
                ResultColumnList prRCList = this.getResultColumns();
                this.setResultColumns(this.getResultColumns().copyListAndObjects());
                prRCList.genVirtualColumnNodes(this, this.getResultColumns());
                MaterializeResultSetNode mrsn = new MaterializeResultSetNode(this, prRCList, this.tableProperties, this.getContextManager());
                if (this.getReferencedTableMap() != null) {
                    mrsn.setReferencedTableMap((JBitSet)this.getReferencedTableMap().clone());
                }
                return mrsn;
            }
            ResultColumnList prRCList = this.childResult.getResultColumns();
            this.childResult.setResultColumns(prRCList.copyListAndObjects());
            prRCList.genVirtualColumnNodes(this.childResult, this.childResult.getResultColumns());
            MaterializeResultSetNode mrsn = new MaterializeResultSetNode(this.childResult, prRCList, this.tableProperties, this.getContextManager());
            if (this.childResult.getReferencedTableMap() != null) {
                mrsn.setReferencedTableMap((JBitSet)this.childResult.getReferencedTableMap().clone());
            }
            this.childResult = mrsn;
        }
        return this;
    }

    @Override
    FromTable getFromTableByName(String name, String schemaName, boolean exactMatch) throws StandardException {
        return this.childResult.getFromTableByName(name, schemaName, exactMatch);
    }

    @Override
    int updateTargetLockMode() {
        if (this.restriction != null || this.constantRestriction != null) {
            return 6;
        }
        return this.childResult.updateTargetLockMode();
    }

    @Override
    boolean isPossibleDistinctScan(Set<BaseColumnNode> distinctColumns) {
        if (this.restriction != null || this.restrictionList != null && this.restrictionList.size() != 0) {
            return false;
        }
        HashSet<BaseColumnNode> columns = new HashSet<BaseColumnNode>();
        for (ResultColumn rc : this.getResultColumns()) {
            BaseColumnNode bc = rc.getBaseColumnNode();
            if (bc == null) {
                return false;
            }
            columns.add(bc);
        }
        return columns.equals(distinctColumns) && this.childResult.isPossibleDistinctScan(distinctColumns);
    }

    @Override
    void markForDistinctScan() {
        this.childResult.markForDistinctScan();
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.restriction != null) {
            this.restriction = (ValueNode)this.restriction.accept(v);
        }
        if (this.restrictionList != null) {
            this.restrictionList = (PredicateList)this.restrictionList.accept(v);
        }
    }

    @Override
    void setRefActionInfo(long fkIndexConglomId, int[] fkColArray, String parentResultSetId, boolean dependentScan) {
        this.childResult.setRefActionInfo(fkIndexConglomId, fkColArray, parentResultSetId, dependentScan);
    }

    void setRestriction(ValueNode restriction) {
        this.restriction = restriction;
    }

    @Override
    public void pushQueryExpressionSuffix() {
        this.childResult.pushQueryExpressionSuffix();
    }

    @Override
    void pushOrderByList(OrderByList orderByList) {
        this.childResult.pushOrderByList(orderByList);
    }

    @Override
    void pushOffsetFetchFirst(ValueNode offset, ValueNode fetchFirst, boolean hasJDBClimitClause) {
        this.childResult.pushOffsetFetchFirst(offset, fetchFirst, hasJDBClimitClause);
    }

    void setValidatingCheckConstraints(String baseTableUUIDString) {
        this.validatingCheckConstraints = true;
        this.validatingBaseTableUUIDString = baseTableUUIDString;
    }
}

