/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.dissect.fields;

import org.logstash.dissect.Delimiter;
import org.logstash.dissect.fields.AppendField;
import org.logstash.dissect.fields.Field;
import org.logstash.dissect.fields.IndirectField;
import org.logstash.dissect.fields.InvalidFieldException;
import org.logstash.dissect.fields.NormalField;
import org.logstash.dissect.fields.SkipField;

public final class FieldFactory {
    private static final String MIXED_PREFIXES = "Field cannot prefix with both Append and Indirect Prefix (%s): %s";
    private static final String PREFIXED_EMPTY = "Field cannot be a prefix on its own without further text";
    private static final String NAME_EMPTY = "Field cannot be a prefix and a suffix without a name section";

    private FieldFactory() {
    }

    public static Field create(int id, String field, Delimiter previous, Delimiter next) {
        if (field.isEmpty() || field.charAt(0) == '?') {
            String[] nameSuffix = Field.extractNameSuffix(FieldFactory.removeLeadingCharIfPresent(field));
            return SkipField.create(id, nameSuffix[0], nameSuffix[1], previous, next);
        }
        if (field.startsWith("+&")) {
            throw new InvalidFieldException(String.format(MIXED_PREFIXES, "+&", field));
        }
        if (field.startsWith("&+")) {
            throw new InvalidFieldException(String.format(MIXED_PREFIXES, "&+", field));
        }
        if (field.charAt(0) == '+') {
            String shorterField = FieldFactory.removeLeadingCharIfPresent(field);
            if (shorterField.isEmpty()) {
                throw new InvalidFieldException(PREFIXED_EMPTY);
            }
            String[] nameSuffix = Field.extractNameSuffix(shorterField);
            if (nameSuffix[0].isEmpty()) {
                throw new InvalidFieldException(NAME_EMPTY);
            }
            return AppendField.create(id, nameSuffix[0], nameSuffix[1], previous, next);
        }
        if (field.charAt(0) == '&') {
            String shorterField = FieldFactory.removeLeadingCharIfPresent(field);
            if (shorterField.isEmpty()) {
                throw new InvalidFieldException(PREFIXED_EMPTY);
            }
            String[] nameSuffix = Field.extractNameSuffix(shorterField);
            if (nameSuffix[0].isEmpty()) {
                throw new InvalidFieldException(NAME_EMPTY);
            }
            return IndirectField.create(id, nameSuffix[0], nameSuffix[1], previous, next);
        }
        String[] nameSuffix = Field.extractNameSuffix(field);
        return NormalField.create(id, nameSuffix[0], nameSuffix[1], previous, next);
    }

    private static String removeLeadingCharIfPresent(String fieldName) {
        return fieldName.isEmpty() ? fieldName : fieldName.substring(1);
    }
}

