/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * greaterThanEqual(ivec4(-5, -5, -5, -5), ivec4(-5, -2, -1, 0)) => bvec4(true, false, false, false)
 * greaterThanEqual(ivec4(-5, -5, -5, -2), ivec4(1, 2, 5, -5)) => bvec4(false, false, false, true)
 * greaterThanEqual(ivec4(-2, -2, -2, -2), ivec4(-2, -1, 0, 1)) => bvec4(true, false, false, false)
 * greaterThanEqual(ivec4(-2, -2, -1, -1), ivec4(2, 5, -5, -2)) => bvec4(false, false, true, true)
 * greaterThanEqual(ivec4(-1, -1, -1, -1), ivec4(-1, 0, 1, 2)) => bvec4(true, false, false, false)
 * greaterThanEqual(ivec4(-1, 0, 0, 0), ivec4(5, -5, -2, -1)) => bvec4(false, true, true, true)
 * greaterThanEqual(ivec4(0, 0, 0, 0), ivec4(0, 1, 2, 5)) => bvec4(true, false, false, false)
 * greaterThanEqual(ivec4(1, 1, 1, 1), ivec4(-5, -2, -1, 0)) => bvec4(true, true, true, true)
 * greaterThanEqual(ivec4(1, 1, 1, 2), ivec4(1, 2, 5, -5)) => bvec4(true, false, false, true)
 * greaterThanEqual(ivec4(2, 2, 2, 2), ivec4(-2, -1, 0, 1)) => bvec4(true, true, true, true)
 * greaterThanEqual(ivec4(2, 2, 5, 5), ivec4(2, 5, -5, -2)) => bvec4(true, false, true, true)
 * greaterThanEqual(ivec4(5, 5, 5, 5), ivec4(-1, 0, 1, 2)) => bvec4(true, true, true, true)
 * greaterThanEqual(ivec4(5, -5, -5, -5), ivec4(5, -5, -2, -1)) => bvec4(true, true, false, false)
 */
#version 150

void main()
{
  float[all(equal(greaterThanEqual(ivec4(-5, -5, -5, -5), ivec4(-5, -2, -1, 0)), bvec4(true, false, false, false))) ? 1 : -1] array0;
  float[all(equal(greaterThanEqual(ivec4(-5, -5, -5, -2), ivec4(1, 2, 5, -5)), bvec4(false, false, false, true))) ? 1 : -1] array1;
  float[all(equal(greaterThanEqual(ivec4(-2, -2, -2, -2), ivec4(-2, -1, 0, 1)), bvec4(true, false, false, false))) ? 1 : -1] array2;
  float[all(equal(greaterThanEqual(ivec4(-2, -2, -1, -1), ivec4(2, 5, -5, -2)), bvec4(false, false, true, true))) ? 1 : -1] array3;
  float[all(equal(greaterThanEqual(ivec4(-1, -1, -1, -1), ivec4(-1, 0, 1, 2)), bvec4(true, false, false, false))) ? 1 : -1] array4;
  float[all(equal(greaterThanEqual(ivec4(-1, 0, 0, 0), ivec4(5, -5, -2, -1)), bvec4(false, true, true, true))) ? 1 : -1] array5;
  float[all(equal(greaterThanEqual(ivec4(0, 0, 0, 0), ivec4(0, 1, 2, 5)), bvec4(true, false, false, false))) ? 1 : -1] array6;
  float[all(equal(greaterThanEqual(ivec4(1, 1, 1, 1), ivec4(-5, -2, -1, 0)), bvec4(true, true, true, true))) ? 1 : -1] array7;
  float[all(equal(greaterThanEqual(ivec4(1, 1, 1, 2), ivec4(1, 2, 5, -5)), bvec4(true, false, false, true))) ? 1 : -1] array8;
  float[all(equal(greaterThanEqual(ivec4(2, 2, 2, 2), ivec4(-2, -1, 0, 1)), bvec4(true, true, true, true))) ? 1 : -1] array9;
  float[all(equal(greaterThanEqual(ivec4(2, 2, 5, 5), ivec4(2, 5, -5, -2)), bvec4(true, false, true, true))) ? 1 : -1] array10;
  float[all(equal(greaterThanEqual(ivec4(5, 5, 5, 5), ivec4(-1, 0, 1, 2)), bvec4(true, true, true, true))) ? 1 : -1] array11;
  float[all(equal(greaterThanEqual(ivec4(5, -5, -5, -5), ivec4(5, -5, -2, -1)), bvec4(true, true, false, false))) ? 1 : -1] array12;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length());
}
