/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.assignment.functor;

import com.projectlibre1.algorithm.CollectionIntervalGenerator;
import com.projectlibre1.pm.assignment.Assignment;
import com.projectlibre1.pm.assignment.contour.AbstractContourBucket;
import com.projectlibre1.pm.assignment.contour.ContourBucketIntervalGenerator;
import com.projectlibre1.pm.assignment.functor.AssignmentFieldOvertimeFunctor;
import com.projectlibre1.pm.calendar.WorkCalendar;
import com.projectlibre1.pm.costing.CostRate;
import com.projectlibre1.pm.time.HasStartAndEnd;

public class CostFunctor
extends AssignmentFieldOvertimeFunctor {
    CollectionIntervalGenerator costRateGenerator;
    long fixedCostDate;
    boolean proratedCost;
    double fixedValue = 0.0;
    double regularWork = 0.0;
    double overtimeWork = 0.0;
    double work = 0.0;

    public static CostFunctor getInstance(Assignment assignment, WorkCalendar workCalendar, ContourBucketIntervalGenerator contourBucketIntervalGenerator, double d, CollectionIntervalGenerator collectionIntervalGenerator, long l, boolean bl) {
        return new CostFunctor(assignment, workCalendar, contourBucketIntervalGenerator, d, collectionIntervalGenerator, l, bl);
    }

    private CostFunctor(Assignment assignment, WorkCalendar workCalendar, ContourBucketIntervalGenerator contourBucketIntervalGenerator, double d, CollectionIntervalGenerator collectionIntervalGenerator, long l, boolean bl) {
        super(assignment, workCalendar, contourBucketIntervalGenerator, d);
        this.costRateGenerator = collectionIntervalGenerator;
        this.fixedCostDate = l;
        this.proratedCost = bl;
    }

    @Override
    public void execute(Object object) {
        HasStartAndEnd hasStartAndEnd = (HasStartAndEnd)object;
        AbstractContourBucket abstractContourBucket = (AbstractContourBucket)this.contourBucketIntervalGenerator.current();
        if (abstractContourBucket != null) {
            CostRate costRate = (CostRate)this.costRateGenerator.current();
            double d = abstractContourBucket.getEffectiveUnits(this.assignment.getUnits());
            if (d != 0.0) {
                long l = this.workCalendar.compare(hasStartAndEnd.getEnd(), hasStartAndEnd.getStart(), false);
                this.regularWork += d * (double)l;
                this.overtimeWork += this.overtimeUnits * (double)l;
                this.work = this.regularWork + this.overtimeWork;
                double d2 = costRate.getOvertimeRate().getValue() * this.overtimeUnits;
                double d3 = costRate.getStandardRate().getValue() * d;
                if (this.assignment.isTemporal()) {
                    d3 *= (double)l;
                    d2 *= (double)l;
                }
                this.overtimeValue += d2;
                this.regularValue += d3;
                this.value += d2 + d3;
                double d4 = costRate.getCostPerUse();
                if (d4 != 0.0) {
                    double d5 = 1.0;
                    if (this.proratedCost) {
                        long l2 = this.assignment.getDuration();
                        if (l2 != 0L) {
                            d5 = (double)l / (double)this.assignment.getDuration();
                        }
                    } else if (hasStartAndEnd.getStart() > this.fixedCostDate || hasStartAndEnd.getEnd() < this.fixedCostDate) {
                        return;
                    }
                    double d6 = d5 * d4 * this.assignment.getUnits();
                    this.fixedValue += d6;
                    this.value += d6;
                }
            }
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.fixedValue = 0.0;
        this.regularWork = 0.0;
        this.overtimeWork = 0.0;
        this.work = 0.0;
    }

    public double getFixedValue() {
        return this.fixedValue;
    }

    @Override
    public String toString() {
        return " total " + this.value + "  regular " + this.regularValue + "  overtime " + this.overtimeValue + "  fixed " + this.fixedValue;
    }

    public final double getOvertimeWork() {
        return this.overtimeWork;
    }

    public final double getRegularWork() {
        return this.regularWork;
    }

    public final double getWork() {
        return this.work;
    }
}

