/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.impl;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.psi.PsiClass;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.java.IJavaElementType;
import com.intellij.util.BitUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiClassStubImpl<T extends PsiClass>
extends StubBase<T>
implements PsiClassStub<T> {
    private static final int DEPRECATED = 1;
    private static final int INTERFACE = 2;
    private static final int ENUM = 4;
    private static final int ENUM_CONSTANT_INITIALIZER = 8;
    private static final int ANONYMOUS = 16;
    private static final int ANON_TYPE = 32;
    private static final int IN_QUALIFIED_NEW = 64;
    private static final int DEPRECATED_ANNOTATION = 128;
    private static final int ANONYMOUS_INNER = 256;
    private static final int LOCAL_CLASS_INNER = 512;
    private static final int HAS_DOC_COMMENT = 1024;
    private static final int RECORD = 2048;
    private static final int IMPLICIT = 4096;
    private static final int VALUE_CLASS = 8192;
    @NotNull
    private final TypeInfo myTypeInfo;
    private final String myQualifiedName;
    private final String myName;
    private final String myBaseRefText;
    private final short myFlags;
    private String mySourceFileName;

    public PsiClassStubImpl(@NotNull IJavaElementType type, StubElement parent, @Nullable String qualifiedName, @Nullable String name, @Nullable String baseRefText, short flags) {
        if (type == null) {
            PsiClassStubImpl.$$$reportNull$$$0(0);
        }
        this(type, parent, TypeInfo.fromString(qualifiedName), name, baseRefText, flags);
    }

    public PsiClassStubImpl(@NotNull IJavaElementType type, StubElement parent, @NotNull TypeInfo typeInfo, @Nullable String name, @Nullable String baseRefText, short flags) {
        if (type == null) {
            PsiClassStubImpl.$$$reportNull$$$0(1);
        }
        if (typeInfo == null) {
            PsiClassStubImpl.$$$reportNull$$$0(2);
        }
        super(parent, (IElementType)type);
        this.myTypeInfo = typeInfo;
        this.myQualifiedName = typeInfo.text();
        this.myName = name;
        this.myBaseRefText = baseRefText;
        this.myFlags = flags;
        if (StubBasedPsiElementBase.ourTraceStubAstBinding) {
            String creationTrace = "Stub creation thread: " + Thread.currentThread() + "\n" + DebugUtil.currentStackTrace();
            this.putUserData(StubBasedPsiElementBase.CREATION_TRACE, creationTrace);
        }
    }

    public String getName() {
        return this.myName;
    }

    @NotNull
    public TypeInfo getQualifiedNameTypeInfo() {
        TypeInfo typeInfo = this.myTypeInfo;
        if (typeInfo == null) {
            PsiClassStubImpl.$$$reportNull$$$0(3);
        }
        return typeInfo;
    }

    @Override
    public String getQualifiedName() {
        return this.myQualifiedName;
    }

    @Override
    public String getBaseClassReferenceText() {
        return this.myBaseRefText;
    }

    @Override
    public boolean isDeprecated() {
        return BitUtil.isSet((int)this.myFlags, (int)1);
    }

    @Override
    public boolean hasDeprecatedAnnotation() {
        return BitUtil.isSet((int)this.myFlags, (int)128);
    }

    @Override
    public boolean isInterface() {
        return BitUtil.isSet((int)this.myFlags, (int)2);
    }

    @Override
    public boolean isEnum() {
        return BitUtil.isSet((int)this.myFlags, (int)4);
    }

    @Override
    public boolean isRecord() {
        return BitUtil.isSet((int)this.myFlags, (int)2048);
    }

    @Override
    public boolean isImplicit() {
        return BitUtil.isSet((int)this.myFlags, (int)4096);
    }

    @Override
    public boolean isValueClass() {
        return BitUtil.isSet((int)this.myFlags, (int)8192);
    }

    @Override
    public boolean isEnumConstantInitializer() {
        return PsiClassStubImpl.isEnumConstInitializer(this.myFlags);
    }

    public static boolean isEnumConstInitializer(short flags) {
        return BitUtil.isSet((int)flags, (int)8);
    }

    public static boolean isImplicit(short flags) {
        return BitUtil.isSet((int)flags, (int)4096);
    }

    @Override
    public boolean isAnonymous() {
        return PsiClassStubImpl.isAnonymous(this.myFlags);
    }

    public static boolean isAnonymous(short flags) {
        return BitUtil.isSet((int)flags, (int)16);
    }

    @Override
    public boolean isAnnotationType() {
        return BitUtil.isSet((int)this.myFlags, (int)32);
    }

    @Override
    public boolean hasDocComment() {
        return BitUtil.isSet((int)this.myFlags, (int)1024);
    }

    @Override
    public String getSourceFileName() {
        return this.mySourceFileName;
    }

    public void setSourceFileName(String sourceFileName) {
        this.mySourceFileName = sourceFileName;
    }

    @Override
    public boolean isAnonymousInQualifiedNew() {
        return BitUtil.isSet((int)this.myFlags, (int)64);
    }

    public short getFlags() {
        return this.myFlags;
    }

    public static short packFlags(boolean isDeprecated, boolean isInterface, boolean isEnum, boolean isEnumConstantInitializer, boolean isAnonymous, boolean isAnnotationType, boolean isInQualifiedNew, boolean hasDeprecatedAnnotation, boolean anonymousInner, boolean localClassInner, boolean hasDocComment) {
        return PsiClassStubImpl.packFlags(isDeprecated, isInterface, isEnum, isEnumConstantInitializer, isAnonymous, isAnnotationType, isInQualifiedNew, hasDeprecatedAnnotation, anonymousInner, localClassInner, hasDocComment, false, false, false);
    }

    public static short packFlags(boolean isDeprecated, boolean isInterface, boolean isEnum, boolean isEnumConstantInitializer, boolean isAnonymous, boolean isAnnotationType, boolean isInQualifiedNew, boolean hasDeprecatedAnnotation, boolean anonymousInner, boolean localClassInner, boolean hasDocComment, boolean isRecord, boolean isImplicit, boolean isValueClass) {
        short flags = 0;
        if (isDeprecated) {
            flags = (short)(flags | 1);
        }
        if (isInterface) {
            flags = (short)(flags | 2);
        }
        if (isEnum) {
            flags = (short)(flags | 4);
        }
        if (isEnumConstantInitializer) {
            flags = (short)(flags | 8);
        }
        if (isAnonymous) {
            flags = (short)(flags | 0x10);
        }
        if (isAnnotationType) {
            flags = (short)(flags | 0x20);
        }
        if (isInQualifiedNew) {
            flags = (short)(flags | 0x40);
        }
        if (hasDeprecatedAnnotation) {
            flags = (short)(flags | 0x80);
        }
        if (anonymousInner) {
            flags = (short)(flags | 0x100);
        }
        if (localClassInner) {
            flags = (short)(flags | 0x200);
        }
        if (hasDocComment) {
            flags = (short)(flags | 0x400);
        }
        if (isRecord) {
            flags = (short)(flags | 0x800);
        }
        if (isImplicit) {
            flags = (short)(flags | 0x1000);
        }
        if (isValueClass) {
            flags = (short)(flags | 0x2000);
        }
        return flags;
    }

    public boolean isAnonymousInner() {
        return BitUtil.isSet((int)this.myFlags, (int)256);
    }

    public boolean isLocalClassInner() {
        return BitUtil.isSet((int)this.myFlags, (int)512);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PsiClassStub[");
        if (this.isInterface()) {
            builder.append("interface ");
        }
        if (this.isAnonymous()) {
            builder.append("anonymous ");
        }
        if (this.isEnum()) {
            builder.append("enum ");
        }
        if (this.isRecord()) {
            builder.append("record ");
        }
        if (this.isAnnotationType()) {
            builder.append("annotation ");
        }
        if (this.isEnumConstantInitializer()) {
            builder.append("enumInit ");
        }
        if (this.isDeprecated()) {
            builder.append("deprecated ");
        }
        if (this.hasDeprecatedAnnotation()) {
            builder.append("deprecatedA ");
        }
        builder.append("name=").append(this.getName()).append(" fqn=").append(this.getQualifiedName());
        if (this.getBaseClassReferenceText() != null) {
            builder.append(" baseref=").append(this.getBaseClassReferenceText());
        }
        if (this.isAnonymousInQualifiedNew()) {
            builder.append(" inqualifnew");
        }
        if (this.isAnonymousInner()) {
            builder.append(" jvmAnonymousInner");
        }
        if (this.isLocalClassInner()) {
            builder.append(" jvmLocalClassInner");
        }
        builder.append("]");
        return builder.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/java/stubs/impl/PsiClassStubImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/java/stubs/impl/PsiClassStubImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedNameTypeInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

