/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.parser.v1;

import java.io.IOException;
import org.openjdk.jmc.common.unit.DecimalPrefix;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.LinearUnit;
import org.openjdk.jmc.common.unit.QuantityRange;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.internal.InvalidJfrFileException;
import org.openjdk.jmc.flightrecorder.internal.parser.Chunk;
import org.openjdk.jmc.flightrecorder.internal.util.DataInputToolkit;
import org.openjdk.jmc.flightrecorder.parser.ByteBufferWrapper;

class ChunkStructure {
    private static final int SIZE = 60;
    private static final int COMPRESSED_INTS = 1;
    private final long chunkSize;
    private final long constantPoolOffset;
    private final long metadataOffset;
    private final long startTimeNanos;
    private final long durationNanos;
    private final long startTicks;
    private final double ticksPerNano;
    private final int features;
    private final int bodyOffset;
    private final LinearUnit ticksUnit;

    ChunkStructure(Chunk chunkInput) throws IOException, InvalidJfrFileException {
        int position = chunkInput.getPosition();
        ByteBufferWrapper buffer = chunkInput.fill(position + 60);
        this.chunkSize = DataInputToolkit.readLong(buffer, position);
        this.constantPoolOffset = DataInputToolkit.readLong(buffer, position += 8);
        this.metadataOffset = DataInputToolkit.readLong(buffer, position += 8);
        this.startTimeNanos = DataInputToolkit.readLong(buffer, position += 8);
        this.durationNanos = DataInputToolkit.readLong(buffer, position += 8);
        this.startTicks = DataInputToolkit.readLong(buffer, position += 8);
        this.ticksPerNano = (double)DataInputToolkit.readLong(buffer, position += 8) / 1.0E9;
        this.features = DataInputToolkit.readInt(buffer, position += 8);
        this.bodyOffset = position + 4;
        this.ticksUnit = UnitLookup.TIMESPAN.makeUnit("ticks", (ITypedQuantity<LinearUnit>)UnitLookup.TIMESPAN.getUnit(DecimalPrefix.NANO).quantity(1.0 / this.ticksPerNano));
    }

    long getBodyStartOffset() {
        return this.bodyOffset;
    }

    long getMetadataOffset() {
        return this.metadataOffset;
    }

    long getChunkSize() {
        return this.chunkSize;
    }

    long getConstantPoolOffset() {
        return this.constantPoolOffset;
    }

    boolean isIntegersCompressed() {
        return (this.features & 1) != 0;
    }

    LinearUnit getTicksTimespanUnit() {
        return this.ticksUnit;
    }

    IQuantity ticsTimestamp(long relativeTicks) {
        return UnitLookup.EPOCH_NS.quantity(this.startTimeNanos + (long)((double)(relativeTicks - this.startTicks) / this.ticksPerNano));
    }

    IRange<IQuantity> getChunkRange() {
        return QuantityRange.createWithExtent(UnitLookup.EPOCH_NS.quantity(this.startTimeNanos), (ITypedQuantity<LinearUnit>)UnitLookup.TIMESPAN.getUnit(DecimalPrefix.NANO).quantity(this.durationNanos));
    }

    long getStartTimeNanos() {
        return this.startTimeNanos;
    }
}

