/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.impl.FileDownloadEventImpl;
import com.intellij.build.events.impl.FileDownloadedEventImpl;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemBuildEvent;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationResult;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.StatusEvent;
import org.gradle.tooling.events.download.FileDownloadProgressEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleBundle;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bJ'\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u000b\u0010\u0012\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00132\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J'\u0010\u0015\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u000b\u0010\u0012\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00132\u0006\u0010\n\u001a\u00020\u0016H\u0002J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0019H\u0002J\u0017\u0010\u001a\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\u00132\u0006\u0010\u001b\u001a\u00020\u0006H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/gradle/service/execution/GradleDownloadProgressMapper;", "", "<init>", "()V", "inFlightDownloads", "", "", "Lorg/gradle/tooling/events/StatusEvent;", "canMap", "", "event", "Lorg/gradle/tooling/events/ProgressEvent;", "map", "Lcom/intellij/openapi/externalSystem/model/task/event/ExternalSystemBuildEvent;", "taskId", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "getDownloadProgressEvent", "Lcom/intellij/build/events/BuildEvent;", "operationName", "Lcom/intellij/openapi/util/NlsSafe;", "newEvent", "getDownloadFinishEvent", "Lorg/gradle/tooling/events/FinishEvent;", "duration", "", "Lorg/gradle/tooling/events/OperationResult;", "getPath", "operation", "Companion", "intellij.gradle"})
@SourceDebugExtension(value={"SMAP\nGradleDownloadProgressMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleDownloadProgressMapper.kt\norg/jetbrains/plugins/gradle/service/execution/GradleDownloadProgressMapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1#2:80\n*E\n"})
public final class GradleDownloadProgressMapper {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, StatusEvent> inFlightDownloads = new HashMap();
    @NotNull
    private static final String BYTES = "bytes";
    @NotNull
    private static final String DOWNLOAD_SPACE = "Download ";

    public final boolean canMap(@NotNull ProgressEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return event instanceof FileDownloadProgressEvent || event instanceof StatusEvent && Intrinsics.areEqual((Object)((StatusEvent)event).getUnit(), (Object)BYTES) || event instanceof FinishEvent && this.inFlightDownloads.containsKey(((FinishEvent)event).getDescriptor().getName());
    }

    @Nullable
    public final ExternalSystemBuildEvent map(@NotNull ExternalSystemTaskId taskId, @NotNull ProgressEvent event) {
        ExternalSystemBuildEvent externalSystemBuildEvent;
        BuildEvent buildEvent;
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String string = event.getDescriptor().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String operationName = string;
        BuildEvent buildEvent2 = event instanceof StatusEvent && Intrinsics.areEqual((Object)BYTES, (Object)((StatusEvent)event).getUnit()) ? this.getDownloadProgressEvent(taskId, operationName, (StatusEvent)event) : (buildEvent = event instanceof FinishEvent ? this.getDownloadFinishEvent(taskId, operationName, (FinishEvent)event) : null);
        if (buildEvent != null) {
            BuildEvent it = buildEvent;
            boolean bl = false;
            externalSystemBuildEvent = new ExternalSystemBuildEvent(taskId, it);
        } else {
            externalSystemBuildEvent = null;
        }
        return externalSystemBuildEvent;
    }

    private final BuildEvent getDownloadProgressEvent(ExternalSystemTaskId taskId, String operationName, StatusEvent newEvent) {
        StatusEvent oldEvent = this.inFlightDownloads.get(operationName);
        this.inFlightDownloads.put(operationName, newEvent);
        if (oldEvent == null || oldEvent.getProgress() <= newEvent.getProgress()) {
            String string = this.getPath(operationName);
            if (string == null) {
                return null;
            }
            String path = string;
            long progress = newEvent.getProgress() > 0L ? newEvent.getProgress() : 0L;
            long total = newEvent.getTotal() > 0L ? newEvent.getTotal() : 0L;
            Object[] objectArray = new Object[]{path};
            String message = GradleBundle.message("progress.title.download", objectArray);
            return (BuildEvent)new FileDownloadEventImpl((Object)taskId, null, newEvent.getEventTime(), message, total, progress, BYTES, oldEvent == null, path);
        }
        return null;
    }

    private final BuildEvent getDownloadFinishEvent(ExternalSystemTaskId taskId, String operationName, FinishEvent event) {
        if (this.inFlightDownloads.remove(operationName) == null) {
            return null;
        }
        String string = this.getPath(operationName);
        if (string == null) {
            return null;
        }
        String path = string;
        long l = event.getEventTime();
        OperationResult operationResult = event.getResult();
        Intrinsics.checkNotNullExpressionValue((Object)operationResult, (String)"getResult(...)");
        return (BuildEvent)new FileDownloadedEventImpl((Object)taskId, null, l, operationName, this.duration(operationResult), path);
    }

    private final long duration(OperationResult $this$duration) {
        long duration = $this$duration.getEndTime() - $this$duration.getStartTime();
        return duration > 0L ? duration : 0L;
    }

    private final String getPath(String operation) {
        String string;
        if (StringsKt.startsWith$default((String)operation, (String)DOWNLOAD_SPACE, (boolean)false, (int)2, null)) {
            String string2 = operation.substring(9);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        } else {
            string = null;
        }
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/gradle/service/execution/GradleDownloadProgressMapper$Companion;", "", "<init>", "()V", "BYTES", "", "DOWNLOAD_SPACE", "intellij.gradle"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

