/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.html.HtmlCompatibleFile;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.DtdResolveUtil;
import com.intellij.psi.impl.source.xml.XmlEntityRefImpl;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.xml.XmlAttlistDecl;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementContentSpec;
import com.intellij.psi.xml.XmlElementDecl;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.util.AddDtdDeclarationFix;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DtdReferencesProvider
extends PsiReferenceProvider {
    private static boolean canHaveAdequateFix(PsiElement element) {
        PsiFile containingFile = element.getContainingFile();
        return containingFile.getLanguage() != HTMLLanguage.INSTANCE && containingFile.getLanguage() != XHTMLLanguage.INSTANCE && !(containingFile instanceof HtmlCompatibleFile) && !(containingFile.getViewProvider() instanceof TemplateLanguageFileViewProvider);
    }

    public PsiReference @NotNull [] getReferencesByElement(final @NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            DtdReferencesProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            DtdReferencesProvider.$$$reportNull$$$0(1);
        }
        XmlElement nameElement = null;
        if (element instanceof XmlDoctype) {
            nameElement = ((XmlDoctype)element).getNameElement();
        } else if (element instanceof XmlElementDecl) {
            nameElement = ((XmlElementDecl)element).getNameElement();
        } else if (element instanceof XmlAttlistDecl) {
            nameElement = ((XmlAttlistDecl)element).getNameElement();
        } else if (element instanceof XmlElementContentSpec) {
            final ArrayList psiRefs = new ArrayList();
            element.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                public void visitElement(@NotNull PsiElement child) {
                    if (child == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (child instanceof XmlToken && ((XmlToken)child).getTokenType() == XmlTokenType.XML_NAME) {
                        psiRefs.add(new ElementReference((XmlElement)element, (XmlElement)child));
                    }
                    super.visitElement(child);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/impl/source/resolve/reference/impl/providers/DtdReferencesProvider$1", "visitElement"));
                }
            });
            PsiReference[] psiReferenceArray = psiRefs.toArray(PsiReference.EMPTY_ARRAY);
            if (psiReferenceArray == null) {
                DtdReferencesProvider.$$$reportNull$$$0(2);
            }
            return psiReferenceArray;
        }
        if (nameElement != null) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new ElementReference((XmlElement)element, nameElement)};
            if (psiReferenceArray == null) {
                DtdReferencesProvider.$$$reportNull$$$0(3);
            }
            return psiReferenceArray;
        }
        if (element instanceof XmlEntityRef || element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_CHAR_ENTITY_REF) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new EntityReference(element)};
            if (psiReferenceArray == null) {
                DtdReferencesProvider.$$$reportNull$$$0(4);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            DtdReferencesProvider.$$$reportNull$$$0(5);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    public ElementFilter getSystemReferenceFilter() {
        return new ElementFilter(){

            public boolean isAcceptable(Object element, PsiElement context) {
                PsiElement parent = context.getParent();
                if (parent instanceof XmlEntityDecl && !((XmlEntityDecl)parent).isInternalReference()) {
                    PsiElement prevSibling = context.getPrevSibling();
                    if (prevSibling instanceof PsiWhiteSpace) {
                        prevSibling = prevSibling.getPrevSibling();
                    }
                    if (prevSibling instanceof XmlToken && ((XmlToken)prevSibling).getTokenType() == XmlTokenType.XML_DOCTYPE_SYSTEM || prevSibling instanceof XmlAttributeValue) {
                        return true;
                    }
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/DtdReferencesProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/DtdReferencesProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }

    static class ElementReference
    implements PsiReference,
    LocalQuickFixProvider,
    EmptyResolveMessageProvider {
        private final XmlElement myElement;
        private XmlElement myNameElement;
        private final TextRange myRange;
        @NonNls
        private static final String ELEMENT_DECLARATION_NAME = "ELEMENT";

        ElementReference(XmlElement element, XmlElement nameElement) {
            this.myElement = element;
            this.myNameElement = nameElement;
            int textOffset = element.getTextRange().getStartOffset();
            int nameTextOffset = nameElement.getTextOffset();
            this.myRange = new TextRange(nameTextOffset - textOffset, nameTextOffset + nameElement.getTextLength() - textOffset);
        }

        @NotNull
        public PsiElement getElement() {
            XmlElement xmlElement = this.myElement;
            if (xmlElement == null) {
                ElementReference.$$$reportNull$$$0(0);
            }
            return xmlElement;
        }

        @NotNull
        public TextRange getRangeInElement() {
            TextRange textRange = this.myRange;
            if (textRange == null) {
                ElementReference.$$$reportNull$$$0(1);
            }
            return textRange;
        }

        @Nullable
        public PsiElement resolve() {
            XmlElementDescriptor descriptor = DtdResolveUtil.resolveElementReference(this.getCanonicalText(), this.myElement);
            return descriptor == null ? null : descriptor.getDeclaration();
        }

        @NotNull
        public String getCanonicalText() {
            XmlElement nameElement = this.myNameElement;
            return nameElement != null ? nameElement.getText() : "";
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            if (newElementName == null) {
                ElementReference.$$$reportNull$$$0(2);
            }
            this.myNameElement = (XmlElement)ElementManipulators.handleContentChange((PsiElement)this.myNameElement, (TextRange)new TextRange(0, this.myNameElement.getTextLength()), (String)newElementName);
            return null;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                ElementReference.$$$reportNull$$$0(3);
            }
            return null;
        }

        public boolean isReferenceTo(@NotNull PsiElement element) {
            if (element == null) {
                ElementReference.$$$reportNull$$$0(4);
            }
            return this.myElement.getManager().areElementsEquivalent(element, this.resolve());
        }

        public Object @NotNull [] getVariants() {
            XmlNSDescriptor rootTagNSDescriptor = DtdResolveUtil.getNsDescriptor(this.myElement);
            Object[] objectArray = rootTagNSDescriptor != null ? rootTagNSDescriptor.getRootElementsDescriptors(((XmlFile)this.getRealFile()).getDocument()) : ArrayUtilRt.EMPTY_OBJECT_ARRAY;
            if (objectArray == null) {
                ElementReference.$$$reportNull$$$0(5);
            }
            return objectArray;
        }

        private PsiFile getRealFile() {
            PsiFile psiFile = this.myElement.getContainingFile();
            if (psiFile != null) {
                psiFile = psiFile.getOriginalFile();
            }
            return psiFile;
        }

        public boolean isSoft() {
            return true;
        }

        public @NotNull LocalQuickFix @Nullable [] getQuickFixes() {
            if (!DtdReferencesProvider.canHaveAdequateFix(this.getElement())) {
                return LocalQuickFix.EMPTY_ARRAY;
            }
            return new LocalQuickFix[]{new AddDtdDeclarationFix("xml.dtd.create.dtd.element.intention.name", ELEMENT_DECLARATION_NAME, this)};
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = XmlBundle.message("xml.inspections.unresolved.element.reference", this.getCanonicalText());
            if (string == null) {
                ElementReference.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/DtdReferencesProvider$ElementReference";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRangeInElement";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/DtdReferencesProvider$ElementReference";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isReferenceTo";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    static class EntityReference
    implements PsiReference,
    LocalQuickFixProvider,
    EmptyResolveMessageProvider {
        private final PsiElement myElement;
        private final TextRange myRange;
        @NonNls
        private static final String ENTITY_DECLARATION_NAME = "ENTITY";

        EntityReference(PsiElement element) {
            this.myElement = element;
            if (element instanceof XmlEntityRef) {
                PsiElement child = element.getLastChild();
                int startOffsetInParent = child.getStartOffsetInParent();
                this.myRange = new TextRange(startOffsetInParent + 1, startOffsetInParent + child.getTextLength() - 1);
            } else {
                this.myRange = new TextRange(1, this.myElement.getTextLength() - 1);
            }
        }

        @NotNull
        public PsiElement getElement() {
            PsiElement psiElement = this.myElement;
            if (psiElement == null) {
                EntityReference.$$$reportNull$$$0(0);
            }
            return psiElement;
        }

        @NotNull
        public TextRange getRangeInElement() {
            TextRange textRange = this.myRange;
            if (textRange == null) {
                EntityReference.$$$reportNull$$$0(1);
            }
            return textRange;
        }

        @Nullable
        public PsiElement resolve() {
            PsiNamedElement element;
            XmlEntityDecl xmlEntityDecl = XmlEntityRefImpl.resolveEntity((XmlElement)this.myElement, (this.myElement instanceof XmlEntityRef ? this.myElement.getLastChild() : this.myElement).getText(), this.myElement.getContainingFile());
            if (xmlEntityDecl != null && !xmlEntityDecl.isPhysical() && (element = XmlUtil.findRealNamedElement((PsiNamedElement)xmlEntityDecl)) != null) {
                xmlEntityDecl = (XmlEntityDecl)element;
            }
            return xmlEntityDecl;
        }

        @NotNull
        public String getCanonicalText() {
            String string = this.myRange.substring(this.myElement.getText());
            if (string == null) {
                EntityReference.$$$reportNull$$$0(2);
            }
            return string;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            if (newElementName == null) {
                EntityReference.$$$reportNull$$$0(3);
            }
            PsiElement elementAt = this.myElement.findElementAt(this.myRange.getStartOffset());
            return ElementManipulators.handleContentChange((PsiElement)elementAt, (TextRange)this.getRangeInElement(), (String)newElementName);
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                EntityReference.$$$reportNull$$$0(4);
            }
            return null;
        }

        public boolean isReferenceTo(@NotNull PsiElement element) {
            if (element == null) {
                EntityReference.$$$reportNull$$$0(5);
            }
            return this.myElement.getManager().areElementsEquivalent(this.resolve(), element);
        }

        public boolean isSoft() {
            return false;
        }

        public @NotNull LocalQuickFix @Nullable [] getQuickFixes() {
            if (!DtdReferencesProvider.canHaveAdequateFix(this.getElement())) {
                return LocalQuickFix.EMPTY_ARRAY;
            }
            return new LocalQuickFix[]{new AddDtdDeclarationFix("xml.dtd.create.entity.intention.name", this.myElement.getText().charAt(this.myRange.getStartOffset() - 1) == '%' ? "ENTITY %" : ENTITY_DECLARATION_NAME, this)};
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = XmlBundle.message("xml.inspections.unresolved.entity.reference", this.getCanonicalText());
            if (string == null) {
                EntityReference.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/DtdReferencesProvider$EntityReference";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRangeInElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/DtdReferencesProvider$EntityReference";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isReferenceTo";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }
}

