/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.scale.breaks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.formatting.string.StringFormat;
import org.jetbrains.letsPlot.commons.intern.datetime.Duration;
import org.jetbrains.letsPlot.core.plot.base.scale.breaks.BreaksHelperBase;
import org.jetbrains.letsPlot.core.plot.base.scale.breaks.DummyBreaksFormatterKt;
import org.jetbrains.letsPlot.core.plot.base.scale.breaks.LinearBreaksHelper;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\b\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\rH\u0002J\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\rJ\u001a\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0002R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/breaks/TimeBreaksHelper;", "Lorg/jetbrains/letsPlot/core/plot/base/scale/breaks/BreaksHelperBase;", "rangeStart", "", "rangeEnd", "count", "", "providedFormatter", "Lkotlin/Function1;", "", "", "(DDILkotlin/jvm/functions/Function1;)V", "breaks", "", "getBreaks", "()Ljava/util/List;", "formatter", "getFormatter", "()Lkotlin/jvm/functions/Function1;", "computeNiceTicks", "formatBreaks", "ticks", "formatString", "v", "", "hideSeconds", "", "Companion", "plot-base"})
@SourceDebugExtension(value={"SMAP\nTimeBreaksHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimeBreaksHelper.kt\norg/jetbrains/letsPlot/core/plot/base/scale/breaks/TimeBreaksHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n1549#2:143\n1620#2,3:144\n1726#2,3:147\n1549#2:150\n1620#2,3:151\n2333#2,14:155\n1#3:154\n*S KotlinDebug\n*F\n+ 1 TimeBreaksHelper.kt\norg/jetbrains/letsPlot/core/plot/base/scale/breaks/TimeBreaksHelper\n*L\n55#1:143\n55#1:144,3\n57#1:147,3\n58#1:150\n58#1:151,3\n118#1:155,14\n*E\n"})
public final class TimeBreaksHelper
extends BreaksHelperBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Function1<Object, String> providedFormatter;
    @NotNull
    private final List<Double> breaks;
    @NotNull
    private final Function1<Object, String> formatter;
    @NotNull
    private static final StringFormat dayFormat = org.jetbrains.letsPlot.core.plot.base.scale.breaks.TimeBreaksHelper$Companion.access$newStringFormat(Companion, "{d}d");
    @NotNull
    private static final StringFormat hmsFormat = org.jetbrains.letsPlot.core.plot.base.scale.breaks.TimeBreaksHelper$Companion.access$newStringFormat(Companion, "{d}:{02d}:{02d}");
    @NotNull
    private static final StringFormat hmFormat = org.jetbrains.letsPlot.core.plot.base.scale.breaks.TimeBreaksHelper$Companion.access$newStringFormat(Companion, "{d}:{02d}");

    public TimeBreaksHelper(double rangeStart, double rangeEnd, int count, @Nullable Function1<Object, String> providedFormatter) {
        super(rangeStart, rangeEnd, count);
        List<Double> list2;
        this.providedFormatter = providedFormatter;
        List<Double> ticks = this.getTargetStep() < 1000.0 ? new LinearBreaksHelper(rangeStart, rangeEnd, count, DummyBreaksFormatterKt.getDUMMY_FORMATTER(), StringFormat.ExponentFormat.Companion.getDEF_EXPONENT_FORMAT(), false, 32, null).getBreaks() : this.computeNiceTicks();
        boolean bl = this.isReversed();
        if (bl) {
            list2 = CollectionsKt.reversed((Iterable)ticks);
        } else if (!bl) {
            list2 = ticks;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.breaks = list2;
        Function1 function1 = this.providedFormatter;
        if (function1 == null) {
            function1 = (Function1)new Function1<Object, String>(){

                @NotNull
                public final String invoke(@NotNull Object v) {
                    Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                    return TimeBreaksHelper.formatString$default(this, ((Number)v).longValue(), false, 2, null);
                }
            };
        }
        this.formatter = function1;
    }

    @Override
    @NotNull
    public List<Double> getBreaks() {
        return this.breaks;
    }

    @NotNull
    public final Function1<Object, String> getFormatter() {
        return this.formatter;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> formatBreaks(@NotNull List<Double> ticks) {
        List list2;
        Intrinsics.checkNotNullParameter(ticks, (String)"ticks");
        if (this.getTargetStep() < 1000.0) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = ticks;
            Function1<Object, String> transform$iv = this.formatter;
            boolean $i$f$map = false;
            void var5_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                destination$iv$iv.add(transform$iv.invoke(item$iv$iv));
            }
            list2 = (List)destination$iv$iv;
        } else {
            boolean bl;
            block7: {
                Iterable $this$all$iv = ticks;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        double it = ((Number)element$iv).doubleValue();
                        boolean bl2 = false;
                        if (it >= (double)Duration.Companion.getDAY().getDuration() || Duration.Companion.getSecond(new Duration((long)it)) == 0L) continue;
                        bl = false;
                        break block7;
                    }
                    bl = true;
                }
            }
            boolean hideSeconds = bl;
            Iterable $this$map$iv = ticks;
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                Object item$iv$iv = iterator2.next();
                double d = ((Number)item$iv$iv).doubleValue();
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(this.formatString((long)it, hideSeconds));
            }
            list2 = (List)destination$iv$iv;
        }
        return list2;
    }

    private final String formatString(long v, boolean hideSeconds) {
        String string;
        String string2;
        if (v == 0L) {
            return "0";
        }
        Duration duration = new Duration(Math.abs(v));
        List parts = new ArrayList();
        if (Duration.Companion.getTotalDays(duration) > 0L) {
            parts.add(TimeBreaksHelper.Companion.formatTotalDays(duration));
        }
        StringBuilder timeParts = new StringBuilder();
        if (hideSeconds) {
            if (Duration.Companion.getHour(duration) > 0L || Duration.Companion.getMinute(duration) > 0L) {
                timeParts.append(TimeBreaksHelper.Companion.formatHm(duration));
            }
        } else {
            if (Duration.Companion.getHour(duration) > 0L || Duration.Companion.getMinute(duration) > 0L || Duration.Companion.getSecond(duration) > 0L) {
                timeParts.append(TimeBreaksHelper.Companion.formatHms(duration));
            }
            if (Duration.Companion.getMillis(duration) > 0L) {
                if (this.getSpan() > (double)Duration.Companion.getSECOND().getDuration() && ((CharSequence)timeParts).length() == 0) {
                    timeParts.append(TimeBreaksHelper.Companion.formatHms(duration));
                }
                if (((CharSequence)timeParts).length() > 0) {
                    timeParts.append(".");
                }
                if (Duration.Companion.getMillis(duration) % (long)10 == 0L && Duration.Companion.getMillis(duration) % (long)100 == 0L) {
                    timeParts.append(Duration.Companion.getMillis(duration) / (long)100);
                } else {
                    timeParts.append(Duration.Companion.getMillis(duration));
                }
            }
        }
        String string3 = timeParts.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        String p0 = string2 = string3;
        boolean bl = false;
        String string4 = !StringsKt.isBlank((CharSequence)p0) ? string2 : null;
        if (string4 != null) {
            p0 = string4;
            boolean bl2 = false;
            parts.add(p0);
        }
        String it = string = "-";
        boolean bl3 = false;
        String string5 = v < 0L ? string : null;
        if (string5 == null) {
            string5 = "";
        }
        String sign = string5;
        return CollectionsKt.joinToString$default((Iterable)parts, (CharSequence)" ", (CharSequence)sign, null, (int)0, null, null, (int)60, null);
    }

    static /* synthetic */ String formatString$default(TimeBreaksHelper timeBreaksHelper, long l, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return timeBreaksHelper.formatString(l, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Double> computeNiceTicks() {
        Object v0;
        void $this$minByOrNull$iv;
        Object object = new Long[]{1L * Duration.Companion.getSECOND().getDuration(), (long)5 * Duration.Companion.getSECOND().getDuration(), (long)15 * Duration.Companion.getSECOND().getDuration(), (long)30 * Duration.Companion.getSECOND().getDuration(), 1L * Duration.Companion.getMINUTE().getDuration(), (long)5 * Duration.Companion.getMINUTE().getDuration(), (long)15 * Duration.Companion.getMINUTE().getDuration(), (long)30 * Duration.Companion.getMINUTE().getDuration(), 1L * Duration.Companion.getHOUR().getDuration(), (long)3 * Duration.Companion.getHOUR().getDuration(), (long)6 * Duration.Companion.getHOUR().getDuration(), (long)12 * Duration.Companion.getHOUR().getDuration(), 1L * Duration.Companion.getDAY().getDuration(), (long)2 * Duration.Companion.getDAY().getDuration(), 1L * Duration.Companion.getWEEK().getDuration(), (long)4 * Duration.Companion.getWEEK().getDuration(), (long)12 * Duration.Companion.getWEEK().getDuration(), (long)48 * Duration.Companion.getWEEK().getDuration()};
        object = CollectionsKt.listOf((Object[])object);
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                long it = ((Number)minElem$iv).longValue();
                boolean bl = false;
                long minValue$iv = Math.abs(it - (long)this.getTargetStep());
                do {
                    Object e$iv = iterator$iv.next();
                    long it2 = ((Number)e$iv).longValue();
                    $i$a$-minByOrNull-TimeBreaksHelper$computeNiceTicks$niceTickInterval$1 = false;
                    long v$iv = Math.abs(it2 - (long)this.getTargetStep());
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        Long l = v0;
        long niceTickInterval = l != null ? l.longValue() : Duration.Companion.getSECOND().getDuration();
        ArrayList<Double> result2 = new ArrayList<Double>();
        for (double tick = Math.ceil(this.getNormalStart() / (double)niceTickInterval) * (double)niceTickInterval; tick <= this.getNormalEnd(); tick += (double)niceTickInterval) {
            result2.add(tick);
        }
        return result2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\bH\u0002J%\u0010\u000f\u001a\u00020\b*\u00020\u00042\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0011\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/breaks/TimeBreaksHelper$Companion;", "", "()V", "dayFormat", "Lorg/jetbrains/letsPlot/commons/formatting/string/StringFormat;", "hmFormat", "hmsFormat", "formatHm", "", "duration", "Lorg/jetbrains/letsPlot/commons/intern/datetime/Duration;", "formatHms", "formatTotalDays", "newStringFormat", "format", "apply", "args", "", "(Lorg/jetbrains/letsPlot/commons/formatting/string/StringFormat;[Ljava/lang/Object;)Ljava/lang/String;", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        private final String formatTotalDays(Duration duration) {
            Object[] objectArray = new Object[]{Duration.Companion.getTotalDays(duration)};
            return this.apply(dayFormat, objectArray);
        }

        private final String formatHms(Duration duration) {
            Object[] objectArray = new Object[]{Duration.Companion.getHour(duration), Duration.Companion.getMinute(duration), Duration.Companion.getSecond(duration)};
            return this.apply(hmsFormat, objectArray);
        }

        private final String formatHm(Duration duration) {
            Object[] objectArray = new Object[]{Duration.Companion.getHour(duration), Duration.Companion.getMinute(duration)};
            return this.apply(hmFormat, objectArray);
        }

        private final StringFormat newStringFormat(String format2) {
            return StringFormat.Companion.forNArgs$default(StringFormat.Companion, format2, -1, null, null, 12, null);
        }

        private final String apply(StringFormat $this$apply, Object ... args) {
            return $this$apply.format(ArraysKt.toList((Object[])args));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ StringFormat access$newStringFormat(Companion $this, String format2) {
            return $this.newStringFormat(format2);
        }
    }
}

