/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.util;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsCallChecker;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0014\u0010\u0007\u001a\u00020\u0001*\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u00a8\u0006\t"}, d2={"hasValidJsCodeBody", "", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "isJsCall", "Lorg/jetbrains/kotlin/psi/KtExpression;", "wasm.frontend"})
public final class JsCodeUtilsKt {
    public static final boolean hasValidJsCodeBody(@NotNull PropertyDescriptor $this$hasValidJsCodeBody, @NotNull BindingContext bindingContext) {
        Intrinsics.checkNotNullParameter((Object)$this$hasValidJsCodeBody, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        SourceElement sourceElement = $this$hasValidJsCodeBody.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"getSource(...)");
        PsiElement psiElement = PsiSourceElementKt.getPsi((SourceElement)sourceElement);
        KtProperty ktProperty = psiElement instanceof KtProperty ? (KtProperty)psiElement : null;
        if (ktProperty == null) {
            return false;
        }
        KtProperty property2 = ktProperty;
        KtExpression ktExpression = property2.getInitializer();
        if (ktExpression == null) {
            return false;
        }
        KtExpression initializer = ktExpression;
        return JsCodeUtilsKt.isJsCall(initializer, bindingContext);
    }

    public static final boolean hasValidJsCodeBody(@NotNull FunctionDescriptor $this$hasValidJsCodeBody, @NotNull BindingContext bindingContext) {
        Intrinsics.checkNotNullParameter((Object)$this$hasValidJsCodeBody, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        SourceElement sourceElement = $this$hasValidJsCodeBody.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"getSource(...)");
        PsiElement psiElement = PsiSourceElementKt.getPsi((SourceElement)sourceElement);
        KtNamedFunction ktNamedFunction = psiElement instanceof KtNamedFunction ? (KtNamedFunction)psiElement : null;
        if (ktNamedFunction == null) {
            return false;
        }
        KtNamedFunction function2 = ktNamedFunction;
        return JsCodeUtilsKt.hasValidJsCodeBody((KtDeclarationWithBody)function2, bindingContext);
    }

    private static final boolean hasValidJsCodeBody(KtDeclarationWithBody $this$hasValidJsCodeBody, BindingContext bindingContext) {
        boolean bl;
        if (!$this$hasValidJsCodeBody.hasBody()) {
            return false;
        }
        KtExpression ktExpression = $this$hasValidJsCodeBody.getBodyExpression();
        Intrinsics.checkNotNull((Object)ktExpression);
        KtExpression body = ktExpression;
        if (!$this$hasValidJsCodeBody.hasBlockBody()) {
            bl = JsCodeUtilsKt.isJsCall(body, bindingContext);
        } else if (body instanceof KtBlockExpression) {
            List list = ((KtBlockExpression)body).getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStatements(...)");
            KtExpression ktExpression2 = (KtExpression)CollectionsKt.singleOrNull((List)list);
            if (ktExpression2 == null) {
                return false;
            }
            KtExpression statement = ktExpression2;
            bl = JsCodeUtilsKt.isJsCall(statement, bindingContext);
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean isJsCall(KtExpression $this$isJsCall, BindingContext bindingContext) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)$this$isJsCall, bindingContext);
        return resolvedCall2 != null ? JsCallChecker.Companion.isJsCall(resolvedCall2) : false;
    }
}

