/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.hierarchy;

import java.awt.Component;
import java.awt.Window;
import java.util.Collection;
import java.util.Map;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.awt.AWT;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.hierarchy.ChildrenFinder;
import org.assertj.swing.hierarchy.ParentFinder;
import org.assertj.swing.util.Maps;

class WindowFilter {
    private final ParentFinder parentFinder;
    private final ChildrenFinder childrenFinder;
    final Map<Component, Boolean> ignored = Maps.newWeakHashMap();
    final Map<Component, Boolean> implicitlyIgnored = Maps.newWeakHashMap();

    WindowFilter() {
        this(new ParentFinder(), new ChildrenFinder());
    }

    WindowFilter(@Nonnull ParentFinder parentFinder, @Nonnull ChildrenFinder childrenFinder) {
        this.parentFinder = parentFinder;
        this.childrenFinder = childrenFinder;
    }

    boolean isImplicitlyIgnored(@Nonnull Component c) {
        return this.implicitlyIgnored.containsKey(c);
    }

    @RunsInCurrentThread
    boolean isIgnored(@Nullable Component c) {
        if (c == null) {
            return false;
        }
        if (this.ignored.containsKey(c)) {
            return true;
        }
        if (c instanceof Window && this.isIgnored(c.getParent())) {
            return true;
        }
        return !(c instanceof Window) && this.isWindowIgnored(c);
    }

    private boolean isWindowIgnored(@Nullable Component c) {
        Window w = this.parentFinder.windowFor(c);
        return w != null && this.isIgnored(w);
    }

    void implicitlyIgnore(@Nonnull Component c) {
        this.implicitlyIgnored.put(c, true);
    }

    @RunsInCurrentThread
    void ignore(@Nonnull Component c) {
        this.filter(c, true);
    }

    @RunsInCurrentThread
    void recognize(@Nonnull Component c) {
        this.filter(c, false);
    }

    @Nonnull
    Collection<Component> filtered() {
        return this.ignored.keySet();
    }

    private void filter(@Nonnull Component c, boolean ignore) {
        if (AWT.isSharedInvisibleFrame(c)) {
            for (Component child : this.childrenFinder.childrenOf(c)) {
                this.filter(child, ignore);
            }
            return;
        }
        this.doFilter(c, ignore);
        this.implicitlyIgnored.remove(c);
        if (!(c instanceof Window)) {
            return;
        }
        for (Window owned : ((Window)c).getOwnedWindows()) {
            if (owned == null) continue;
            this.filter(owned, ignore);
        }
    }

    private void doFilter(@Nonnull Component c, boolean ignore) {
        if (ignore) {
            this.ignored.put(c, true);
            return;
        }
        this.ignored.remove(c);
    }
}

