/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.datagrid.AggregatorWidget;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.run.ui.Aggregator;
import com.intellij.database.run.ui.TableAggregatorWidgetHelper;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetSettings;
import com.intellij.util.ObjectUtils;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import org.jetbrains.annotations.NotNull;

public final class CopyAggregatorResult
extends DumbAwareAction {
    private static final char ABBREVIATION_SUFFIX = '\u2026';
    private static final int MAX_AGGREGATOR_NAME_LENGTH = 10;
    private DataGrid myGrid = null;

    public void setGrid(@NotNull DataGrid grid) {
        if (grid == null) {
            CopyAggregatorResult.$$$reportNull$$$0(0);
        }
        this.myGrid = grid;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            CopyAggregatorResult.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        DataGrid grid;
        if (e == null) {
            CopyAggregatorResult.$$$reportNull$$$0(2);
        }
        if ((grid = GridUtil.getDataGrid(e.getDataContext())) == null) {
            grid = this.myGrid;
        }
        if (grid == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        TableAggregatorWidgetHelper helper = (TableAggregatorWidgetHelper)ObjectUtils.tryCast((Object)grid.getResultView().getComponent().getClientProperty("ResultViewAggregatorWidgetHelper"), TableAggregatorWidgetHelper.class);
        if (helper == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Aggregator aggregator = helper.getAggregator();
        if (aggregator == null) {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(false);
            return;
        }
        AggregatorWidget.Factory t = (AggregatorWidget.Factory)((Object)StatusBarWidgetFactory.EP_NAME.findExtension(AggregatorWidget.Factory.class));
        boolean isWidgetShown = t != null && StatusBarWidgetSettings.getInstance().isEnabled((StatusBarWidgetFactory)t);
        Object aggregatorName = helper.getAggregator().getSimpleName();
        if (((String)aggregatorName).length() >= 10) {
            aggregatorName = ((String)aggregatorName).substring(0, 10) + "\u2026";
        }
        e.getPresentation().setVisible(true);
        e.getPresentation().setEnabled(isWidgetShown);
        e.getPresentation().setText((String)(isWidgetShown ? this.getTemplateText() + " (" + (String)aggregatorName + ")" : this.getTemplateText()));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataGrid grid;
        if (e == null) {
            CopyAggregatorResult.$$$reportNull$$$0(3);
        }
        if ((grid = GridUtil.getDataGrid(e.getDataContext())) == null) {
            grid = this.myGrid;
        }
        if (grid == null) {
            return;
        }
        TableAggregatorWidgetHelper helper = (TableAggregatorWidgetHelper)ObjectUtils.tryCast((Object)grid.getResultView().getComponent().getClientProperty("ResultViewAggregatorWidgetHelper"), TableAggregatorWidgetHelper.class);
        if (helper == null) {
            return;
        }
        helper.getResultText().thenAccept(result -> ApplicationManager.getApplication().invokeLater(() -> CopyPasteManager.getInstance().setContents((Transferable)new StringSelection((String)result))));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/CopyAggregatorResult";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/CopyAggregatorResult";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setGrid";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

