/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.jaxen.function;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import nu.xom.jaxen.Context;
import nu.xom.jaxen.Function;
import nu.xom.jaxen.FunctionCallException;
import nu.xom.jaxen.JaxenRuntimeException;
import nu.xom.jaxen.Navigator;
import nu.xom.jaxen.UnsupportedAxisException;

public class StringFunction
implements Function {
    private static DecimalFormat format = (DecimalFormat)NumberFormat.getInstance(Locale.ENGLISH);

    @Override
    public Object call(Context context, List list) throws FunctionCallException {
        int n = list.size();
        if (n == 0) {
            return StringFunction.evaluate(context.getNodeSet(), context.getNavigator());
        }
        if (n == 1) {
            return StringFunction.evaluate(list.get(0), context.getNavigator());
        }
        throw new FunctionCallException("string() takes at most argument.");
    }

    public static String evaluate(Object object, Navigator navigator) {
        try {
            Object object2;
            if (navigator != null && navigator.isText(object)) {
                return navigator.getTextStringValue(object);
            }
            if (object instanceof List) {
                object2 = (List)object;
                if (object2.isEmpty()) {
                    return "";
                }
                object = object2.get(0);
            }
            if (navigator != null) {
                if (navigator.isElement(object)) {
                    return navigator.getElementStringValue(object);
                }
                if (navigator.isAttribute(object)) {
                    return navigator.getAttributeStringValue(object);
                }
                if (navigator.isDocument(object)) {
                    object2 = navigator.getChildAxisIterator(object);
                    while (object2.hasNext()) {
                        Object e = object2.next();
                        if (!navigator.isElement(e)) continue;
                        return navigator.getElementStringValue(e);
                    }
                } else {
                    if (navigator.isProcessingInstruction(object)) {
                        return navigator.getProcessingInstructionData(object);
                    }
                    if (navigator.isComment(object)) {
                        return navigator.getCommentStringValue(object);
                    }
                    if (navigator.isText(object)) {
                        return navigator.getTextStringValue(object);
                    }
                    if (navigator.isNamespace(object)) {
                        return navigator.getNamespaceStringValue(object);
                    }
                }
            }
            if (object instanceof String) {
                return (String)object;
            }
            if (object instanceof Boolean) {
                return StringFunction.stringValue((Boolean)object);
            }
            if (object instanceof Number) {
                return StringFunction.stringValue(((Number)object).doubleValue());
            }
        }
        catch (UnsupportedAxisException unsupportedAxisException) {
            throw new JaxenRuntimeException(unsupportedAxisException);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String stringValue(double d) {
        if (d == 0.0) {
            return "0";
        }
        String string = null;
        DecimalFormat decimalFormat = format;
        synchronized (decimalFormat) {
            string = format.format(d);
        }
        return string;
    }

    private static String stringValue(boolean bl) {
        return bl ? "true" : "false";
    }

    static {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.ENGLISH);
        decimalFormatSymbols.setNaN("NaN");
        decimalFormatSymbols.setInfinity("Infinity");
        format.setGroupingUsed(false);
        format.setMaximumFractionDigits(32);
        format.setDecimalFormatSymbols(decimalFormatSymbols);
    }
}

