<div align="center">
  <h1><code>wasi</code></h1>

<strong>A <a href="https://bytecodealliance.org/">Bytecode Alliance</a> project</strong>

  <p>
    <strong>WASI API Bindings for Rust</strong>
  </p>

  <p>
    <a href="https://crates.io/crates/wasi"><img src="https://img.shields.io/crates/v/wasi.svg?style=flat-square" alt="Crates.io version" /></a>
    <a href="https://crates.io/crates/wasi"><img src="https://img.shields.io/crates/d/wasi.svg?style=flat-square" alt="Download" /></a>
    <a href="https://docs.rs/wasi/"><img src="https://img.shields.io/badge/docs-latest-blue.svg?style=flat-square" alt="docs.rs docs" /></a>
  </p>
</div>

This repository contains low-level Rust bindings to WASI APIs which are
distributed and published to crates on crates.io. Crates currently are:

* `wasi` - this is a reexport of the latest stable WASI proposal. At this time
  this represents bindings to WASIp2.
* [`wasip2`](./crates/wasip2) - this crate explicitly contains bindings for the
  latest stable WASIp2 release generated by the latest stable `wit-bindgen`
  release.
* [`wasip1`](./crates/wasip1) - this crate explicitly contains bindings for the
  WASIp1 snapshot. Development of the WASIp1 version of the standard has ceased
  and this crate is in maintenance mode.

## The `wasi` crate

The `wasi` crate today is a lightweight reexport of the latest stable version
of the WASI standard. Currently that is WASIp2. The `wasi` crate version number
will be bumped every timet he `wasip2` crate version number is bumped, for
example, and its interface and bindings may change over time as WASIp2 APIs are
added or the `wit-bindgen` tool to generate bindings evolves.

To explicitly indicate which version of the WASI standard you'd like to use it's
recommended to use the `wasip2` crate directly.

## Crate version numbers

The `wasi` crate contains "build metadata" which indicates what version of the
WASI standard it contains bindings for. This metadata is purely informational
and cannot be used to constrain a version requirement in Cargo. This scheme
is mirrored for the `wasip2` crate as well, for example.

## WASIp2 vs WASIp1

In January 2024 the WASI subgroup published WASI 0.2.0, colloquially known as
"WASIp2". Around the same time the subgroup additionally decided to name the
previous iteration of WASI as "WASIp1", historically known as "WASI preview1".
This now-historical snapshot of WASI was defined with an entirely different set
of primitives and worked very differently. The interface of the `wasip1` and
`wasip2` crates are entirely different and the `wasi` crate umbrella no longer
reexports `wasip1`.

## Should I use WASIp1 or WASIp2?

This is a bit of a nuanced question/answer but the short answer is to probably
use the latest release of `wasi` if you're unsure.

The longer-form answer of this is that it depends on the Rust targets that you
want to support. Rust WebAssembly targets include:

* `wasm32-unknown-unknown` - do not use this crate because this target indicates
  that WASI is not desired.
* `wasm32-wasip1` - this target has been present in Rust for quite some time and
  was previously known as `wasm32-wasi`. For this target you probably want the
  `wasip1` crate.
* `wasm32-wasip2` - this target you can use either the `wasi` crate or the
  `wasip2` crate depending on your use case. Using WASIp2 APIs on this target
  is more appropriate than using WASIp1 APIs.

Note that if you use `wasm32-wasip1` it's not necessarily guaranteed you want
the `wasip1` crate. If your users are producing components then you probably
want the `wasip2` or `wasi` crates instead. If you don't know what your users
are producing then you should probably stick with `wasip1`.

Long story short, it's a bit complicated. We're in a development period from
WASIp2-and-beyond and things aren't going to be perfect every step of the way,
so understanding is appreciated!

# License

This project is licensed under the Apache 2.0 license with the LLVM exception.
See [LICENSE](LICENSE) for more details.

### Contribution

Unless you explicitly state otherwise, any contribution intentionally submitted
for inclusion in this project by you, as defined in the Apache-2.0 license,
shall be licensed as above, without any additional terms or conditions.
