"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerQueryRoute = registerQueryRoute;
var _configSchema = require("@osd/config-schema");
var _constants = require("../utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function registerQueryRoute(server, service) {
  server.post({
    path: _constants.ROUTE_PATH_SQL_QUERY,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSQLQuery(context, request);
    if (retVal.data.ok) {
      return response.ok({
        body: retVal
      });
    } else {
      return response.custom({
        body: retVal.data.body,
        statusCode: retVal.data.statusCode
      });
    }
  });
  server.post({
    path: _constants.ROUTE_PATH_PPL_QUERY,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describePPLQuery(context, request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: _constants.ROUTE_PATH_SQL_CSV,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSQLCsv(context, request);
    if (retVal.data.ok) {
      return response.ok({
        body: retVal
      });
    } else {
      return response.custom({
        body: retVal.data.body,
        statusCode: retVal.data.statusCode
      });
    }
  });
  server.post({
    path: _constants.ROUTE_PATH_PPL_CSV,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describePPLCsv(context, request);
    if (retVal.data.ok) {
      return response.ok({
        body: retVal
      });
    } else {
      return response.custom({
        body: retVal.data.body,
        statusCode: retVal.data.statusCode
      });
    }
  });
  server.post({
    path: _constants.ROUTE_PATH_SQL_TEXT,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSQLText(context, request);
    if (retVal.data.ok) {
      return response.ok({
        body: retVal
      });
    } else {
      return response.custom({
        body: retVal.data.body,
        statusCode: retVal.data.statusCode
      });
    }
  });
  server.post({
    path: _constants.ROUTE_PATH_PPL_TEXT,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describePPLText(context, request);
    if (retVal.data.ok) {
      return response.ok({
        body: retVal
      });
    } else {
      return response.custom({
        body: retVal.data.body,
        statusCode: retVal.data.statusCode
      });
    }
  });
  server.post({
    path: _constants.ROUTE_PATH_SPARK_SQL_QUERY,
    validate: {
      body: _configSchema.schema.any(),
      query: _configSchema.schema.object({
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSQLAsyncQuery(context, request);
    if (retVal.data.ok) {
      return response.ok({
        body: retVal
      });
    } else {
      return response.custom({
        body: retVal.data.body,
        statusCode: retVal.data.statusCode
      });
    }
  });
  server.get({
    path: _constants.ROUTE_PATH_SPARK_SQL_JOB_QUERY + '/{id}' + '/{dataSourceMDSId?}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string(),
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSQLAsyncGetQuery(context, request, request.params.id, request.params.dataSourceMDSId);
    if (retVal.data.ok) {
      return response.ok({
        body: retVal
      });
    } else {
      return response.custom({
        body: retVal.data.body,
        statusCode: retVal.data.statusCode
      });
    }
  });
  server.delete({
    path: _constants.ROUTE_PATH_SPARK_SQL_JOB_QUERY + '/{id}' + '/{dataSourceMDSId?}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string(),
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describeAsyncDeleteQuery(context, request, request.params.id, request.params.dataSourceMDSId);
    return response.ok({
      body: retVal
    });
  });
  server.get({
    path: `${_constants.ROUTE_PATH_GET_DATASOURCES}/{dataSourceMDSId?}`,
    validate: {
      params: _configSchema.schema.object({
        dataSourceMDSId: _configSchema.schema.maybe(_configSchema.schema.string({
          defaultValue: ''
        }))
      })
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSyncQueryDataSources(context, request);
    if (retVal.data.ok) {
      return response.ok({
        body: retVal
      });
    } else {
      return response.custom({
        body: retVal.data.body,
        statusCode: retVal.data.statusCode
      });
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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