/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.common;

import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.uno.AnyConverter;

public class NumericalHelper {
    private static final int BYTE_TYPE = 0;
    private static final int SHORT_TYPE = 1;
    private static final int INT_TYPE = 2;
    private static final int LONG_TYPE = 3;
    private static final int FLOAT_TYPE = 4;
    private static final int DOUBLE_TYPE = 5;
    private static final int CHAR_TYPE = 6;
    private static final int STRING_TYPE = -1;
    private static final int BOOLEAN_TYPE = -2;
    private static final int SEQUENCE_TYPE = -3;

    private NumericalHelper() {
    }

    public static int toInt(Object object) throws IllegalArgumentException {
        int n = 0;
        TypeObject typeObject = NumericalHelper.getTypeObject(object);
        switch (typeObject.iType) {
            case 0: {
                n = NumericalHelper.getByte(typeObject);
                break;
            }
            case 6: {
                n = NumericalHelper.getChar(typeObject);
                break;
            }
            case 1: {
                n = NumericalHelper.getShort(typeObject);
                break;
            }
            case 2: {
                n = NumericalHelper.getInt(typeObject);
                break;
            }
            case 3: {
                n = (int)NumericalHelper.getLong(typeObject);
                break;
            }
            case 4: {
                n = (int)NumericalHelper.getFloat(typeObject);
                break;
            }
            case 5: {
                n = (int)NumericalHelper.getDouble(typeObject);
                break;
            }
            case -1: {
                try {
                    n = Integer.parseInt((String)typeObject.aValue);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException((Throwable)numberFormatException, "Cannot convert to int: " + typeObject.aValue);
                }
            }
            case -2: {
                n = NumericalHelper.getBool(typeObject) ? -1 : 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert this type: " + object.getClass().getName());
            }
        }
        return n;
    }

    public static double toDouble(Object object) throws IllegalArgumentException {
        double d = 0.0;
        TypeObject typeObject = NumericalHelper.getTypeObject(object);
        switch (typeObject.iType) {
            case 0: {
                d = NumericalHelper.getByte(typeObject);
                break;
            }
            case 6: {
                d = NumericalHelper.getChar(typeObject);
                break;
            }
            case 1: {
                d = NumericalHelper.getShort(typeObject);
                break;
            }
            case 2: {
                d = NumericalHelper.getInt(typeObject);
                break;
            }
            case 3: {
                d = NumericalHelper.getLong(typeObject);
                break;
            }
            case 4: {
                d = NumericalHelper.getFloat(typeObject);
                break;
            }
            case 5: {
                d = NumericalHelper.getDouble(typeObject);
                break;
            }
            case -1: {
                try {
                    d = Float.parseFloat((String)typeObject.aValue);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException((Throwable)numberFormatException, "Cannot convert to short: " + typeObject.aValue);
                }
            }
            case -2: {
                d = NumericalHelper.getBool(typeObject) ? -1.0 : 0.0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert this type: " + object.getClass().getName());
            }
        }
        return d;
    }

    private static TypeObject getTypeObject(Object object) throws IllegalArgumentException {
        TypeObject typeObject = new TypeObject();
        if (object == null || AnyConverter.isVoid((Object)object)) {
            throw new IllegalArgumentException("Cannot convert a null object.");
        }
        int n = AnyConverter.getType((Object)object).getTypeClass().getValue();
        switch (n) {
            case 1: {
                typeObject.iType = 6;
                typeObject.aValue = Character.valueOf(AnyConverter.toChar((Object)object));
                break;
            }
            case 3: {
                typeObject.iType = 0;
                typeObject.aValue = AnyConverter.toByte((Object)object);
                break;
            }
            case 4: {
                typeObject.iType = 1;
                typeObject.aValue = AnyConverter.toShort((Object)object);
                break;
            }
            case 6: {
                typeObject.iType = 2;
                typeObject.aValue = AnyConverter.toInt((Object)object);
                break;
            }
            case 8: {
                typeObject.iType = 3;
                typeObject.aValue = AnyConverter.toLong((Object)object);
                break;
            }
            case 10: {
                typeObject.iType = 4;
                typeObject.aValue = Float.valueOf(AnyConverter.toFloat((Object)object));
                break;
            }
            case 11: {
                typeObject.iType = 5;
                typeObject.aValue = AnyConverter.toDouble((Object)object);
                break;
            }
            case 12: {
                typeObject.iType = -1;
                typeObject.aValue = AnyConverter.toString((Object)object);
                break;
            }
            case 2: {
                typeObject.iType = -2;
                typeObject.aValue = AnyConverter.toBoolean((Object)object);
                break;
            }
            case 20: {
                typeObject.iType = -3;
                typeObject.aValue = object;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert this type: " + object.getClass().getName());
            }
        }
        return typeObject;
    }

    private static byte getByte(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != 0) {
            throw new IllegalArgumentException("Given argument is not a byte type.");
        }
        return (Byte)typeObject.aValue;
    }

    private static char getChar(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != 6) {
            throw new IllegalArgumentException("Given argument is not a char type.");
        }
        return ((Character)typeObject.aValue).charValue();
    }

    private static short getShort(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != 1) {
            throw new IllegalArgumentException("Given argument is not a short type.");
        }
        return (Short)typeObject.aValue;
    }

    private static int getInt(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != 2) {
            throw new IllegalArgumentException("Given argument is not an int type.");
        }
        return (Integer)typeObject.aValue;
    }

    private static float getFloat(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != 4) {
            throw new IllegalArgumentException("Given argument is not a float type.");
        }
        return ((Float)typeObject.aValue).floatValue();
    }

    private static double getDouble(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != 5) {
            throw new IllegalArgumentException("Given argument is not a double type.");
        }
        return (Double)typeObject.aValue;
    }

    private static long getLong(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != 3) {
            throw new IllegalArgumentException("Given argument is not a long type.");
        }
        return (Long)typeObject.aValue;
    }

    private static boolean getBool(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != -2) {
            throw new IllegalArgumentException("Given argument is not a boolean type.");
        }
        return (Boolean)typeObject.aValue;
    }

    private static class TypeObject {
        public int iType;
        public Object aValue;

        private TypeObject() {
        }
    }
}

