/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.painless.api;

import java.io.IOException;
import java.io.OutputStream;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class Json {
    public static Object load(String json) throws IOException {
        XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, json);
        switch (parser.nextToken()) {
            case START_ARRAY: {
                return parser.list();
            }
            case START_OBJECT: {
                return parser.map();
            }
            case VALUE_NUMBER: {
                return parser.numberValue();
            }
            case VALUE_BOOLEAN: {
                return parser.booleanValue();
            }
            case VALUE_STRING: {
                return parser.text();
            }
        }
        return null;
    }

    public static String dump(Object data) throws IOException {
        return Json.dump(data, false);
    }

    public static String dump(Object data, boolean pretty) throws IOException {
        XContentBuilder builder = JsonXContent.contentBuilder();
        if (pretty) {
            builder.prettyPrint();
        }
        builder.value(data);
        builder.flush();
        try (OutputStream out = builder.getOutputStream();){
            String string = out.toString();
            return string;
        }
    }
}

