/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.model;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.securityanalytics.threatIntel.model.JsonPathIocSchema;

public abstract class IocSchema<Notation>
implements Writeable,
ToXContentObject {
    private static final Logger log = LogManager.getLogger(IocSchema.class);

    abstract String getFormat();

    abstract Notation getId();

    abstract Notation getName();

    abstract Notation getType();

    abstract Notation getValue();

    abstract Notation getSeverity();

    abstract Notation getCreated();

    abstract Notation getModified();

    abstract Notation getDescription();

    abstract Notation getLabels();

    abstract Notation getSpecVersion();

    static JsonPathIocSchema readFrom(StreamInput sin) throws IOException {
        String format;
        switch (format = sin.readString()) {
            case "json_path_schema": {
                return new JsonPathIocSchema(sin);
            }
        }
        throw new IllegalStateException("Unexpected ioc schema format [" + format + "] found while reading parse stream");
    }

    static IocSchema parse(XContentParser xcp) throws IOException {
        JsonPathIocSchema schema = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block6: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "json_path_schema": {
                    schema = JsonPathIocSchema.parse(xcp);
                    continue block6;
                }
            }
            String errorMessage = String.format("Unexpected ioc schema format [%s] found while parsing", fieldName);
            log.error(errorMessage);
            throw new IllegalStateException(errorMessage);
        }
        return schema;
    }
}

