/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.memorycontainer.memory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ml.common.transport.memorycontainer.memory.MemoryResult;

public class MLAddMemoriesResponse
extends ActionResponse
implements ToXContentObject {
    private List<MemoryResult> results;
    private String sessionId;

    public MLAddMemoriesResponse(List<MemoryResult> results, String sessionId) {
        this.results = results != null ? results : new ArrayList();
        this.sessionId = sessionId;
    }

    public MLAddMemoriesResponse(StreamInput in) throws IOException {
        super(in);
        int size = in.readVInt();
        this.results = new ArrayList<MemoryResult>(size);
        for (int i = 0; i < size; ++i) {
            this.results.add(new MemoryResult(in));
        }
        this.sessionId = in.readString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.results.size());
        for (MemoryResult result : this.results) {
            result.writeTo(out);
        }
        out.writeString(this.sessionId);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("results");
        for (MemoryResult result : this.results) {
            result.toXContent(builder, params);
        }
        builder.endArray();
        builder.field("session_id", this.sessionId);
        builder.endObject();
        return builder;
    }

    @Generated
    public static MLAddMemoriesResponseBuilder builder() {
        return new MLAddMemoriesResponseBuilder();
    }

    @Generated
    public List<MemoryResult> getResults() {
        return this.results;
    }

    @Generated
    public String getSessionId() {
        return this.sessionId;
    }

    @Generated
    public String toString() {
        return "MLAddMemoriesResponse(results=" + String.valueOf(this.getResults()) + ", sessionId=" + this.getSessionId() + ")";
    }

    @Generated
    public static class MLAddMemoriesResponseBuilder {
        @Generated
        private List<MemoryResult> results;
        @Generated
        private String sessionId;

        @Generated
        MLAddMemoriesResponseBuilder() {
        }

        @Generated
        public MLAddMemoriesResponseBuilder results(List<MemoryResult> results) {
            this.results = results;
            return this;
        }

        @Generated
        public MLAddMemoriesResponseBuilder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Generated
        public MLAddMemoriesResponse build() {
            return new MLAddMemoriesResponse(this.results, this.sessionId);
        }

        @Generated
        public String toString() {
            return "MLAddMemoriesResponse.MLAddMemoriesResponseBuilder(results=" + String.valueOf(this.results) + ", sessionId=" + this.sessionId + ")";
        }
    }
}

