/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.dao;

import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.StepListener;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.searchrelevance.exception.SearchRelevanceException;
import org.opensearch.searchrelevance.indices.SearchRelevanceIndices;
import org.opensearch.searchrelevance.indices.SearchRelevanceIndicesManager;
import org.opensearch.searchrelevance.model.JudgmentCache;
import org.opensearch.searchrelevance.utils.ParserUtils;

public class JudgmentCacheDao {
    private static final Logger LOGGER = LogManager.getLogger(JudgmentCacheDao.class);
    private final SearchRelevanceIndicesManager searchRelevanceIndicesManager;

    @Inject
    public JudgmentCacheDao(SearchRelevanceIndicesManager searchRelevanceIndicesManager) {
        this.searchRelevanceIndicesManager = searchRelevanceIndicesManager;
    }

    public void createIndexIfAbsent(StepListener<Void> stepListener) {
        this.searchRelevanceIndicesManager.createIndexIfAbsent(SearchRelevanceIndices.JUDGMENT_CACHE, stepListener);
    }

    public void putJudgementCache(JudgmentCache judgmentCache, ActionListener listener) {
        if (judgmentCache == null) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("judgmentCache cannot be null", RestStatus.BAD_REQUEST)));
            return;
        }
        try {
            this.searchRelevanceIndicesManager.putDoc(judgmentCache.id(), judgmentCache.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS), SearchRelevanceIndices.JUDGMENT_CACHE, listener);
        }
        catch (IOException e) {
            throw new SearchRelevanceException("Failed to store judgment", e, RestStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public void upsertJudgmentCache(JudgmentCache judgmentCache, ActionListener listener) {
        if (judgmentCache == null) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("judgmentCache cannot be null", RestStatus.BAD_REQUEST)));
            return;
        }
        try {
            XContentBuilder content = judgmentCache.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS);
            this.searchRelevanceIndicesManager.updateDoc(judgmentCache.id(), content, SearchRelevanceIndices.JUDGMENT_CACHE, ActionListener.wrap(response -> {
                LOGGER.debug("Successfully upserted judgment cache for queryText: {} and documentId: {}", (Object)judgmentCache.queryText(), (Object)judgmentCache.documentId());
                listener.onResponse(response);
            }, e -> {
                LOGGER.error("Failed to upsert judgment cache for queryText: {} and documentId: {}", (Object)judgmentCache.queryText(), (Object)judgmentCache.documentId(), e);
                listener.onFailure((Exception)((Object)new SearchRelevanceException("Failed to upsert judgment cache", (Throwable)e, RestStatus.INTERNAL_SERVER_ERROR)));
            }));
        }
        catch (IOException e2) {
            listener.onFailure((Exception)((Object)new SearchRelevanceException("Failed to prepare judgment cache document", e2, RestStatus.INTERNAL_SERVER_ERROR)));
        }
    }

    public SearchResponse getJudgmentCache(String queryText, String documentId, List<String> contextFields, ActionListener<SearchResponse> listener) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        String contextFieldsStr = contextFields != null ? ParserUtils.convertListToSortedStr(contextFields) : "";
        LOGGER.debug("Building cache search query - queryText: '{}', documentId: '{}', contextFields: '{}'", (Object)queryText, (Object)documentId, (Object)contextFieldsStr);
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"queryText", (Object)queryText)).must((QueryBuilder)QueryBuilders.matchQuery((String)"documentId", (Object)documentId));
        if (contextFields != null && !contextFields.isEmpty()) {
            boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)"contextFieldsStr", (Object)contextFieldsStr));
        }
        searchSourceBuilder.query((QueryBuilder)boolQuery);
        ActionListener wrappedListener = ActionListener.wrap(response -> {
            if (response.getHits().getTotalHits().value() > 0L) {
                SearchHit searchHit = response.getHits().getHits()[0];
            }
            listener.onResponse(response);
        }, e -> {
            LOGGER.debug("Cache lookup failed for docId: {} - continuing without cache", (Object)documentId);
            listener.onFailure(e);
        });
        return this.searchRelevanceIndicesManager.listDocsBySearchRequest(searchSourceBuilder, SearchRelevanceIndices.JUDGMENT_CACHE, (ActionListener<SearchResponse>)wrappedListener);
    }
}

