/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.Query;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryRewriteContext;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.WithFieldName;
import org.opensearch.neuralsearch.settings.NeuralSearchSettingsAccessor;

public final class AgenticSearchQueryBuilder
extends AbstractQueryBuilder<AgenticSearchQueryBuilder>
implements WithFieldName {
    @Generated
    private static final Logger log = LogManager.getLogger(AgenticSearchQueryBuilder.class);
    public static final String NAME = "agentic";
    public static final ParseField QUERY_TEXT_FIELD = new ParseField("query_text", new String[0]);
    public static final ParseField QUERY_FIELDS = new ParseField("query_fields", new String[0]);
    public String queryText;
    public List<String> queryFields;
    private static NeuralSearchSettingsAccessor SETTINGS_ACCESSOR;

    public static void initialize(NeuralSearchSettingsAccessor settingsAccessor) {
        SETTINGS_ACCESSOR = settingsAccessor;
    }

    public AgenticSearchQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.queryText = in.readString();
        this.queryFields = in.readOptionalStringList();
    }

    public String getQueryText() {
        return this.queryText;
    }

    public List<String> getQueryFields() {
        return this.queryFields;
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        if (!SETTINGS_ACCESSOR.isAgenticSearchEnabled()) {
            throw new IllegalStateException("Agentic search is currently disabled. Enable it using the 'plugins.neural_search.agentic_search_enabled' setting.");
        }
        out.writeString(this.queryText);
        out.writeOptionalStringCollection(this.queryFields);
    }

    protected void doXContent(XContentBuilder xContentBuilder, ToXContent.Params params) throws IOException {
        if (!SETTINGS_ACCESSOR.isAgenticSearchEnabled()) {
            throw new IllegalStateException("Agentic search is currently disabled. Enable it using the 'plugins.neural_search.agentic_search_enabled' setting.");
        }
        xContentBuilder.startObject(NAME);
        if (Objects.nonNull(QUERY_TEXT_FIELD)) {
            xContentBuilder.field(QUERY_TEXT_FIELD.getPreferredName(), this.queryText);
        }
        if (Objects.nonNull(this.queryFields) && !this.queryFields.isEmpty()) {
            xContentBuilder.field(QUERY_FIELDS.getPreferredName(), this.queryFields);
        }
        xContentBuilder.endObject();
    }

    public static AgenticSearchQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        AgenticSearchQueryBuilder agenticSearchQueryBuilder = new AgenticSearchQueryBuilder();
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (QUERY_TEXT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    agenticSearchQueryBuilder.queryText = parser.text();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "Unknown field [" + currentFieldName + "]", new Object[0]);
            }
            if (token != XContentParser.Token.START_ARRAY) continue;
            if (QUERY_FIELDS.match(currentFieldName, parser.getDeprecationHandler())) {
                ArrayList<String> fieldsList = new ArrayList<String>();
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    if (fieldsList.size() >= 25) {
                        throw new ParsingException(parser.getTokenLocation(), "Too many query fields. Maximum allowed is 25", new Object[0]);
                    }
                    fieldsList.add(parser.text());
                }
                agenticSearchQueryBuilder.queryFields = fieldsList;
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "Unknown field [" + currentFieldName + "]", new Object[0]);
        }
        if (agenticSearchQueryBuilder.queryText == null || agenticSearchQueryBuilder.queryText.trim().isEmpty()) {
            throw new ParsingException(parser.getTokenLocation(), "[" + QUERY_TEXT_FIELD.getPreferredName() + "] is required", new Object[0]);
        }
        return agenticSearchQueryBuilder;
    }

    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        return this;
    }

    protected Query doToQuery(QueryShardContext context) throws IOException {
        throw new IllegalStateException("Agentic search query must be used as top-level query, not nested inside other queries. Should be used with agentic_query_translator search processor");
    }

    protected boolean doEquals(AgenticSearchQueryBuilder obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != ((Object)((Object)obj)).getClass()) {
            return false;
        }
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        equalsBuilder.append((Object)this.queryText, (Object)obj.queryText);
        equalsBuilder.append(this.queryFields, obj.queryFields);
        return equalsBuilder.isEquals();
    }

    protected int doHashCode() {
        return new HashCodeBuilder().append((Object)this.queryText).append(this.queryFields).toHashCode();
    }

    public String getWriteableName() {
        return NAME;
    }

    public String fieldName() {
        return NAME;
    }

    @Generated
    public AgenticSearchQueryBuilder() {
    }

    @Generated
    public AgenticSearchQueryBuilder(String queryText, List<String> queryFields) {
        this.queryText = queryText;
        this.queryFields = queryFields;
    }

    @Generated
    public String queryText() {
        return this.queryText;
    }

    @Generated
    public List<String> queryFields() {
        return this.queryFields;
    }

    @Generated
    public AgenticSearchQueryBuilder queryText(String queryText) {
        this.queryText = queryText;
        return this;
    }

    @Generated
    public AgenticSearchQueryBuilder queryFields(List<String> queryFields) {
        this.queryFields = queryFields;
        return this;
    }
}

