/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.security.asn1;

import com.ca.commons.security.asn1.ASN1Exception;
import com.ca.commons.security.asn1.ASN1Object;
import com.ca.commons.security.asn1.ASN1Type;
import com.ca.commons.security.asn1.Context;
import com.ca.commons.security.asn1.Name;
import java.util.Hashtable;

public class GeneralName {
    private int generalNameID = -1;
    private String rfc822Name = null;
    private String dNSName = null;
    private Name directoryName = null;
    private String uRID = null;
    private String ipAddress = null;
    private String registeredOID = null;
    private static Hashtable idName = new Hashtable();

    public static String lookUpName(int id) {
        return (String)idName.get(new Integer(id));
    }

    public GeneralName(Object obj, int type) throws ASN1Exception {
        if (type < 0 || type > 8) {
            throw new ASN1Exception("Wrong type");
        }
        if (type == 1 && obj instanceof String) {
            this.rfc822Name = (String)obj;
            this.generalNameID = 1;
        } else if (type == 2 && obj instanceof String) {
            this.dNSName = (String)obj;
            this.generalNameID = 2;
        } else if (type == 4 && obj instanceof Name) {
            this.directoryName = (Name)obj;
            this.generalNameID = 4;
        } else if (type == 6 && obj instanceof String) {
            this.uRID = (String)obj;
            this.generalNameID = 6;
        } else if (type == 7 && obj instanceof String) {
            this.ipAddress = (String)obj;
            this.generalNameID = 7;
        } else if (type == 8 && obj instanceof String) {
            this.registeredOID = (String)obj;
            this.generalNameID = 8;
        } else {
            throw new ASN1Exception("Wrong Type");
        }
    }

    public GeneralName(byte[] data) {
        ASN1Object o = ASN1Object.fromBytes(data);
        this.init(o);
    }

    public GeneralName(ASN1Object o) {
        this.init(o);
    }

    private void init(ASN1Object ss) {
        if (!ss.isASN1Type(ASN1Type.ContextSpecific)) {
            return;
        }
        ASN1Object mm = (ASN1Object)ss.getValue();
        int tag = ss.getTag();
        this.generalNameID = tag >= 0 && tag <= 8 ? tag : tag - 32;
        if (tag == 0) {
            System.out.println("not Implemented");
        } else if (tag == 1) {
            ASN1Object tmp1 = (ASN1Object)ss.getValue();
            if (!tmp1.isASN1Type(ASN1Type.OCTET_STRING)) {
                return;
            }
            byte[] bytearray = (byte[])tmp1.getValue();
            this.rfc822Name = new String(bytearray);
        } else if (tag == 2) {
            ASN1Object tmp1 = (ASN1Object)ss.getValue();
            if (!tmp1.isASN1Type(ASN1Type.OCTET_STRING)) {
                return;
            }
            byte[] bytearray = (byte[])tmp1.getValue();
            this.dNSName = new String(bytearray);
        } else if (tag == 3) {
            System.out.println("not Implemented");
        } else if (tag == 36) {
            this.directoryName = new Name((ASN1Object)ss.getValue());
        } else if (tag == 5) {
            System.out.println("not Implemented");
        } else if (tag == 6) {
            ASN1Object tmp1 = (ASN1Object)ss.getValue();
            if (!tmp1.isASN1Type(ASN1Type.OCTET_STRING)) {
                return;
            }
            byte[] bytearray = (byte[])tmp1.getValue();
            this.uRID = new String(bytearray);
        } else if (tag == 7) {
            ASN1Object tmp1 = (ASN1Object)ss.getValue();
            if (!tmp1.isASN1Type(ASN1Type.OCTET_STRING)) {
                return;
            }
            byte[] bytearray = (byte[])tmp1.getValue();
            this.ipAddress = new String(bytearray);
        } else if (tag == 8) {
            ASN1Object tmp1 = (ASN1Object)ss.getValue();
            if (!tmp1.isASN1Type(ASN1Type.OCTET_STRING)) {
                return;
            }
            try {
                byte[] data = (byte[])tmp1.getValue();
                ASN1Object obj = ASN1Object.create(ASN1Type.OBJECT_ID);
                GeneralName.decodeOBJECTID(obj, data, 0, data.length);
                this.registeredOID = (String)obj.getValue();
            }
            catch (Exception e) {
                System.out.println(e);
                this.registeredOID = null;
            }
        } else {
            return;
        }
    }

    public Object getValue(int type) {
        if (type < 0 || type > 8) {
            return null;
        }
        if (type == 1) {
            return this.rfc822Name;
        }
        if (type == 2) {
            return this.dNSName;
        }
        if (type == 4) {
            return this.directoryName;
        }
        if (type == 6) {
            return this.uRID;
        }
        if (type == 7) {
            return this.ipAddress;
        }
        if (type == 8) {
            return this.registeredOID;
        }
        return null;
    }

    public int getType() {
        return this.generalNameID;
    }

    public ASN1Object toASN1Object() {
        if (this.generalNameID < 0) {
            return null;
        }
        Context mm = null;
        if (this.generalNameID == 1 && this.rfc822Name != null) {
            try {
                mm = new Context(1, true, ASN1Object.create(ASN1Type.IA5String, this.rfc822Name));
                mm.initByteArray();
            }
            catch (Exception e) {
                System.out.println(e);
            }
            return mm;
        }
        if (this.generalNameID == 2 && this.dNSName != null) {
            try {
                mm = new Context(2, true, ASN1Object.create(ASN1Type.IA5String, this.dNSName));
                mm.initByteArray();
            }
            catch (Exception e) {
                System.out.println(e);
            }
            return mm;
        }
        if (this.generalNameID == 4 && this.directoryName != null) {
            try {
                mm = new Context(4, false, this.directoryName.toASN1Object());
                mm.initByteArray();
            }
            catch (Exception e) {
                System.out.println(e);
            }
            return mm;
        }
        if (this.generalNameID == 6 && this.uRID != null) {
            try {
                mm = new Context(6, true, ASN1Object.create(ASN1Type.IA5String, this.uRID));
                mm.initByteArray();
            }
            catch (Exception e) {
                System.out.println(e);
            }
            return mm;
        }
        if (this.generalNameID == 7 && this.ipAddress != null) {
            try {
                mm = new Context(7, true, ASN1Object.create(ASN1Type.OCTET_STRING, this.ipAddress.getBytes()));
                mm.initByteArray();
            }
            catch (Exception e) {
                System.out.println(e);
            }
            return mm;
        }
        if (this.generalNameID == 8 && this.registeredOID != null) {
            try {
                mm = new Context(8, true, ASN1Object.create(ASN1Type.OBJECT_ID, this.registeredOID));
                mm.initByteArray();
            }
            catch (Exception e) {
                System.out.println(e);
            }
            return mm;
        }
        return null;
    }

    private static void decodeOBJECTID(ASN1Object o, byte[] stream, int offset, int length) throws ASN1Exception {
        if (length < 1) {
            throw new ASN1Exception("Wrong data (OBJECT ID) length");
        }
        int end = offset + length;
        byte v = stream[offset++];
        String content = Integer.toString(v / 40) + " ";
        content = content + Integer.toString(v % 40) + " ";
        while (offset < end) {
            long l = 0L;
            while ((stream[offset] & 0x80) != 0) {
                l |= (long)(0x7F & stream[offset++]);
                l <<= 7;
            }
            content = content + Long.toString(l |= (long)(0x7F & stream[offset++])) + " ";
        }
        if (offset != end) {
            throw new ASN1Exception("Wrong data (OBJECT ID) length");
        }
        o.setValue(content.trim());
    }

    static {
        idName.put(new Integer(1), "rfc822Name");
        idName.put(new Integer(2), "dNSName");
        idName.put(new Integer(4), "directoryName");
        idName.put(new Integer(6), "uRID");
        idName.put(new Integer(7), "ipAddress");
        idName.put(new Integer(8), "registeredOID");
    }
}

