/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.loader;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdErrorCode;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.jsonld.loader.DocumentLoaderOptions;
import com.apicatalog.jsonld.loader.FileLoader;
import com.apicatalog.jsonld.loader.HttpLoader;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SchemeRouter
implements DocumentLoader {
    private static final DocumentLoader INSTANCE = new SchemeRouter().set("http", HttpLoader.defaultInstance()).set("https", HttpLoader.defaultInstance()).set("file", new FileLoader());
    private final Map<String, DocumentLoader> loaders = new LinkedHashMap<String, DocumentLoader>();

    public static final DocumentLoader defaultInstance() {
        return INSTANCE;
    }

    public SchemeRouter set(String scheme, DocumentLoader loader) {
        this.loaders.put(scheme, loader);
        return this;
    }

    @Override
    public Document loadDocument(URI url, DocumentLoaderOptions options) throws JsonLdError {
        if (url == null) {
            throw new IllegalArgumentException("The url must not be null.");
        }
        DocumentLoader loader = this.loaders.getOrDefault(url.getScheme().toLowerCase(), null);
        if (loader == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "URL scheme [" + url.getScheme() + "] is not supported.");
        }
        return loader.loadDocument(url, options);
    }
}

