/**
*
* Jquery Mapael - Dynamic maps jQuery plugin (based on raphael.js)
* Requires jQuery and raphael.js
*
* Map of Picardie for Mapael
* Equirectangular projection
* 
* @author CCM Benchmark Group
* @source http://fr.m.wikipedia.org/wiki/Fichier:France_location_map-Departements.svg
*/
(function($) {
	$.extend(true, $.fn.mapael, 
		{
			maps :  {
				france_region_22 : {
					width : 131.49632,
					height : 100.98322,
					getCoords : function (lat, lon) {
						var xfactor = 45.48385;
						var xoffset = -62.6039;
						var x = (lon * xfactor) + xoffset;
						
						var yfactor = -65.97284;
						var yoffset = 3323.4374;
						var y = (lat * yfactor) + yoffset;
						return {x : x, y : y};
					},
					elems : {
					    "department-60" : "m 17.05,40.42 c -0.83,0.1 -0.08,1.35 -0.94,1.53 -0.8,0.24 -0.89,1.06 -0.91,1.76 -0.4,0.31 -1.37,0.65 -0.77,1.31 0.61,0.79 1.15,-0.37 1.63,-0.7 0.66,-0.54 1.21,1.04 0.53,1.33 -0.62,0.18 -1.04,0.7 -1.03,1.33 -0.7,0.33 -0.81,1.34 -0.19,1.81 0.56,0.81 -0.52,1.34 -0.77,1.96 -0.12,0.63 0.91,0.58 0.98,1.01 -0.61,0.42 -0.19,1.06 0.18,1.45 0.35,0.5 -0.35,1.6 0.62,1.54 0.6,0.03 0.02,0.86 -0.07,1.15 -0.11,0.49 -1.24,1 -0.63,1.48 0.51,0.3 1.28,0.28 1.37,-0.42 0.7,-0.89 2.09,0.34 1.5,1.19 -0.91,0.02 -0.29,1.27 -1.06,1.54 -0.56,0.3 -0.53,0.98 -1.11,1.22 -0.6,0.72 -0.97,1.73 -1.02,2.63 0.17,0.36 1.04,-0.16 0.94,0.24 -0.4,0.24 -0.83,0.73 -0.29,1.11 0.68,0.63 1.32,1.34 1.4,2.3 0.45,0.71 0.51,1.49 0.41,2.29 0.07,0.71 0.07,1.65 0.86,1.89 0.38,0.27 0.15,0.75 0.46,1.09 -0.07,0.53 -0.08,1.39 -0.59,1.68 -0.8,0.07 -1.13,-0.65 -1.51,-1.17 -0.95,-0.46 -2.65,0.25 -2.34,1.47 0.32,0.65 1.52,0.71 1.53,1.49 0.08,0.62 -1.13,0.91 -0.59,1.47 0.63,0.23 0.74,0.93 1.14,1.35 0.72,0.08 1.32,-0.7 2.1,-0.39 0.57,0.21 1.18,0.42 1.77,0.59 0.64,0.77 1.85,-0.48 2.37,0.49 0.88,0.17 1.76,-0.44 2.67,-0.38 0.71,0.14 1.12,-0.88 1.78,-0.45 0.97,0.51 1.58,-0.76 2.51,-0.83 0.62,-0.46 1.49,-1.15 2.29,-0.93 0.31,0.44 0.39,1.23 1.15,1.09 0.77,-0.08 1.7,0.2 2.23,0.75 -0.01,0.3 0.02,1.08 0.47,0.67 0.37,-0.84 1.43,-0.13 2.03,-0.67 0.47,0.14 1.18,1.08 0.39,1.35 -0.15,0.72 1.03,0.16 1.41,0.19 1.18,0.03 1.52,-1.15 2.14,-1.88 1.28,-0.5 1.56,1.36 2.39,1.91 0.47,0.2 0.89,-0.59 1.32,-0.04 0.77,0.51 1.8,0.07 2.56,0.7 0.46,0.62 1.41,0.48 1.96,1.07 0.63,0.17 0.96,0.67 0.88,1.3 0.3,0.68 1.52,0.45 1.4,-0.38 0.21,-0.94 1.47,0.01 1.2,0.69 0.1,0.69 1.06,0.67 1.15,1.4 0.67,0.51 0.96,-0.76 1.58,-0.84 0.34,-0.2 0.76,-0.95 1.06,-0.38 1.12,0.31 2.22,1.22 2.47,2.37 0.63,0.35 0.95,-0.88 1.47,-0.75 0.09,0.58 0.47,1.25 1.17,0.98 0.6,-0.07 1.51,-0.72 0.86,-1.26 0.45,-0.49 1.21,-0.76 1.78,-1.04 0.37,0.8 1.47,0.62 1.89,1.28 0.32,1 1.37,0.2 1.9,-0.15 0.6,-0.59 1.63,0.42 2.28,-0.27 0.2,-0.42 0.74,-0.11 1.08,-0.4 0.52,0.09 0.26,1.47 0.9,0.96 0.33,-1.35 2,-0.88 2.99,-0.76 0.52,-0.19 0.01,-0.93 0.42,-1.28 0.19,-0.7 0.85,-0.94 1.29,-1.4 0.16,-0.35 0.07,-0.89 0.6,-0.88 0.34,-0.55 1.4,-0.28 1.49,-1.02 -0.3,-0.44 -1.15,-0.47 -1.03,-1.18 0.14,-1.06 -0.43,-1.79 -0.83,-0.43 -0.39,0.48 0.08,1.09 -0.07,1.53 -1.09,-0.3 -0.06,-1.66 -0.6,-2.3 -0.38,-0.12 -1.06,0.21 -0.96,-0.46 -0.18,-0.53 -0.74,-0.35 -1.1,-0.43 -0.47,0.14 -0.93,-0.39 -0.71,-0.97 0.82,0 0.85,-0.93 0.59,-1.5 -0.34,-0.74 0.05,-1.69 -0.38,-2.37 -0.41,-0.11 -0.35,-0.28 -0.48,-0.59 -0.47,0.02 -0.98,0.1 -1.28,-0.4 -0.35,-0.32 -0.86,-0.54 -0.48,-1.01 -0.07,-0.38 -0.76,-0.68 -0.14,-1.01 0.64,-0.44 1.33,-1.33 2.15,-0.7 0.5,0.35 1.17,0.38 1.5,-0.21 0.73,-0.42 1.23,-1.1 1.27,-1.97 0.19,-0.61 0.77,-1.02 0.62,-1.76 0.13,-0.92 -0.08,-2.06 0.27,-2.88 0.68,-0.13 1.3,0.51 2.02,0.15 0.47,0.03 1.35,-0.58 0.62,-0.93 -0.68,-0.57 -1.92,-0.63 -2.3,-1.46 0.28,-0.48 1.26,-0.73 0.46,-1.34 -0.22,-0.46 -1.15,-1.2 -0.61,-1.69 0.55,-0.15 1.19,-0.39 1.09,-1.1 0.15,-0.99 -0.07,-2.05 0.28,-2.96 -0.16,-1.13 -1.1,-1.89 -1.67,-2.78 0.27,-0.34 0.94,-0.64 0.62,-1.23 -0.35,-0.54 -0.86,-0.93 -0.13,-1.43 0.23,-0.33 1.06,-0.36 0.64,-0.93 -0.6,-0.48 0.6,-1.45 -0.26,-1.86 -0.67,-0.22 -1.04,0.69 -1.57,0.74 0.13,-0.49 -0.08,-1.56 -0.75,-1 -0.3,0.43 -0.22,1.1 -0.91,1.05 -0.38,0.18 -0.45,1.16 -0.98,0.63 -0.74,-0.29 -0.81,-1.7 -1.78,-1.31 -0.47,0.26 -0.83,0.61 -1.36,0.72 -0.51,0.49 0.44,1.03 -0.13,1.56 -0.28,-0.59 -1.06,-0.57 -1.18,-1.29 -0.14,-0.69 -0.76,-0.99 -1.4,-0.79 -0.37,-0.06 -0.89,-0.87 -1.03,-0.11 0.31,0.62 1.12,1.24 0.71,2.01 -0.34,-0.39 -1.06,-1.25 -1.42,-0.39 -0.37,0.38 -0.1,1.3 -0.87,1.13 -0.81,-0.09 -1.95,-0.04 -2.06,1 -0.12,0.64 0.6,1.56 -0.2,1.97 -0.69,0.25 -1.29,-0.13 -1.86,-0.44 -0.85,-0.04 -1.73,-0.16 -2.57,-0.19 -0.25,0.5 -0.39,1.12 -0.72,1.62 -0.25,0.55 -0,1.32 -0.71,1.58 -0.62,0.67 -1.75,-0.2 -1.48,-0.99 0.2,-0.81 -0.61,-1.43 -1.33,-1.09 -0.55,0 -0.88,1.13 -1.41,0.57 -0.32,-0.53 -0.7,-0.98 -1.25,-1.24 -0.56,-0.46 -1.25,-0.95 -1.95,-1.04 -0.28,0.36 -1.22,1.32 -1.45,0.41 -0.37,-0.46 -0.76,-0.88 -0.98,-1.42 -0.72,-0.76 -1.83,-0.78 -2.75,-0.49 -0.66,0.15 -1.01,-0.53 -1.62,-0.5 -0.53,-0.18 -0.81,-0.62 -0.96,-1.11 -0.5,-0.63 -1.24,0.2 -1.81,-0.29 -1.18,-0.43 -2.39,-1.49 -3.69,-0.91 -0.73,-0.07 -1.46,-0.49 -2.2,-0.12 -0.78,0.28 -1.41,1.14 -2.33,0.67 -0.92,-0.27 -1.91,0.75 -2.73,0.19 0.44,-0.69 -0.73,-1.21 -1.28,-1.36 -0.82,-0.14 -1.71,-0.15 -2.46,-0.39 -0.37,0.12 -0.82,1.18 -1.18,0.51 -0.16,-0.77 -1.09,-0.77 -1.45,-0.15 -0.49,0.61 -1.33,0.9 -2.03,0.47 -0.66,0.01 -1.47,-0.25 -1.57,-0.99 -0.31,-0.16 -0.81,-0.18 -0.36,-0.62 0.44,-0.25 0.51,-0.87 -0.08,-0.86 -0.4,-0.46 -0.86,-0.93 -1.5,-0.93 -0.38,-0.38 -1.09,-0.3 -1.59,-0.33 z",
					    "department-80" : "m 9.48,0.1 c -0.9,0.03 -2.13,0.37 -2.04,1.52 -0.15,1.48 -0.85,3.02 -0.45,4.5 0.17,0.73 0.84,1.06 1.51,1.11 0.44,0.24 0.64,0.78 1.13,0.93 0.61,1.04 1.51,2.09 2.78,2.16 0.35,0.37 -0.54,0.88 0.11,1.21 0.47,0.17 0.44,0.91 -0.14,0.69 -1.68,-0.39 -3.05,-1.44 -4.6,-2.1 -1.84,0 -2.99,1.94 -3.54,3.49 -0.53,1.93 -1.2,4 -2.94,5.18 -0.62,0.48 -2.21,1.4 -0.58,1.61 0.82,0.39 0.87,-1.09 1.7,-0.69 0.78,-0.06 1.29,0.69 0.96,1.41 -0.25,0.93 1.01,0.91 1.36,1.56 0.8,0.47 1.55,0.98 1.97,1.83 0.79,0.9 2.12,1.31 2.54,2.53 1.07,1.61 3.22,1.85 4.49,3.2 0.23,0.62 0.64,1.09 1.18,1.37 0.31,0.59 0.34,1.29 0.51,1.93 -0.08,0.87 0.48,1.52 0.53,2.37 0.45,1.29 1.03,2.63 2.11,3.47 0.27,0.63 0.69,1.26 1.41,1.32 0.37,0.35 0.59,0.94 1.21,0.92 0.9,0.35 -0.85,1.01 -0.06,1.4 0.36,0.42 0.6,1.09 1.27,0.97 0.75,0.3 1.63,0.4 2.15,-0.36 0.36,-0.43 1.15,-0.91 1.51,-0.21 0.49,1.13 0.73,-0.1 1.24,-0.38 0.48,0.04 0.86,0.51 1.41,0.42 1.07,-0.07 2.11,0.28 2.7,1.22 0.36,0.89 1.43,-0.18 2.1,-0.01 0.57,0.09 1.2,0.47 1.66,-0.14 0.96,-0.78 2.38,-0.25 3.51,-0.44 1.48,-0.26 2.58,1 3.95,1.17 0.39,-0.24 0.93,-0.37 1.19,0.18 0.33,0.59 0.78,1.31 1.55,1.11 0.37,0.44 0.9,0.87 1.47,0.4 1.12,-0.34 2.46,0.18 2.84,1.33 0.4,0.07 1,0.22 0.66,0.8 0.42,0.56 0.89,-0.53 1.34,-0.67 0.35,-0.35 0.41,0.44 0.84,0.42 0.7,0.27 1.22,1.02 2.02,0.86 -0.05,0.44 0.18,1.57 0.8,1.06 0.43,-0.73 1.44,-0.66 2.15,-0.54 0.24,0.76 -0.15,2.32 1.03,2.37 1.09,-0.33 0.63,-1.71 1.36,-2.35 0.27,-0.37 0.06,-1.11 0.73,-1.05 1.28,-0.14 2.55,0.04 3.66,0.68 0.92,0.23 0.84,-1.03 0.72,-1.59 -0.12,-0.63 0.08,-1.64 0.95,-1.44 0.58,0 1.62,0.14 1.6,-0.71 0.27,-0.65 0.92,-1.06 1.61,-1 0.13,-0.48 -1.26,-0.85 -0.46,-1.31 0.22,-0.25 0.68,-0.65 0.72,-0.06 0.16,1.22 0.72,0.02 1.17,-0.03 0.55,0.51 0.53,1.8 1.4,1.89 0.37,-0.29 0.05,-1.02 0.72,-1.09 0.52,-0.4 1.23,-0.95 1.9,-0.49 0.4,0.41 0.74,1.37 1.39,1.27 0.13,-0.49 0.49,-0.75 0.96,-0.74 0.4,-0.48 -0.5,-1.53 0.6,-1.15 0.52,-0.08 0.9,0.17 0.91,0.71 0.44,0.31 0.5,-0.59 1.06,-0.44 0.78,-0.63 -0.4,-1.43 -0.48,-2.14 -0.18,-0.58 0.01,-1.74 -0.94,-1.62 -0.73,-0.1 -1.13,-1.35 -0.19,-1.52 0.69,-0.41 0.5,-1.69 -0.14,-2.05 -0.74,0.15 -0.9,-1.05 -0.17,-1.18 1.22,-0.4 0.21,-0.75 0.56,-1.66 0.34,-0.59 0.34,-0.71 0.74,-0.68 1.3,-0.42 0.92,-2.02 1.22,-3.03 0.15,-1.09 1.36,-1.41 1.8,-2.27 -0.21,-1.06 1.04,-1.35 1.57,-1.95 -0.26,-0.56 -1.66,-0.12 -1.73,-0.83 0.18,-0.43 1.01,-1.43 0.16,-1.61 -0.39,0.13 -0.66,0.11 -0.85,-0.25 -0.54,-0.17 -1.23,-0.11 -1.41,-0.81 -0.33,-0.35 -0.75,-0.81 -1.24,-0.89 -0.78,0.52 -1.62,-0.51 -2.46,-0.43 -1.01,-0.1 -1.91,0.48 -2.79,0.9 -0.36,-0.58 -1.19,-1.01 -1.61,-0.27 -0.38,0.08 -0.64,0.32 -0.89,0.58 -0.68,0.04 -1.65,0.24 -1.79,0.98 -0.49,0.32 -1.44,-0.27 -0.81,-0.77 0.61,-0.26 0.82,-0.97 0.28,-1.45 -0.37,-0.28 -0.55,-0.63 -0.61,-1.09 -0.6,-0.51 -0.78,0.71 -1.41,0.64 -0.61,0.01 -0.91,0.6 -1.35,0.84 -0.57,0.32 -1.23,0.89 -1.92,0.46 -0.77,-0.54 0.56,-0.96 0.46,-1.61 0.63,-0.76 1.05,-1.78 0.73,-2.76 -0.54,-0.3 -1.34,-0.12 -1.76,-0.75 -0.28,-0.47 -1.27,-0.61 -1.13,0.15 0.36,0.6 -0.84,0.75 -0.3,1.29 0.39,0.29 0.88,0.94 0.1,1.1 -0.52,-0.03 -0.79,-0.88 -1.42,-0.79 -0.42,-0.08 -0.87,-0.4 -1.27,-0.08 -0.77,-0.13 -0.93,-1.24 -1.81,-0.92 -0.68,0.26 -1.93,-0.13 -1.77,-0.99 0.26,-0.25 0.76,-1.02 0.03,-0.84 -0.38,-0.02 -1.04,-0.39 -1,0.32 0.08,0.46 -0.42,1.2 -0.87,1.01 -0.41,-0.6 -0.57,-1.86 -1.6,-1.44 -1.11,0.03 -2.15,0.69 -2.4,1.8 -0.25,0.42 -0.33,1.28 -0.77,1.47 -0.72,-0.5 -1.39,-1.45 -2.28,-1.46 0.25,-1.19 0.26,-2.74 1.29,-3.54 0.58,-0.01 0.41,-0.8 1.01,-0.89 0.98,-0.39 2.27,-0.47 2.92,-1.4 -0.02,-0.84 -1.35,-0.7 -1.57,-1.5 -0.54,-0.72 -1.65,-0.16 -2.3,-0.67 -0.72,0.34 -1.48,0.77 -1.79,1.56 -0.44,0.26 -0.68,-0.76 -0.95,-0.97 -0.06,-0.41 -0.88,-1 -0.78,-0.29 0.32,0.49 -0.01,0.94 -0.57,0.84 -0.81,0.19 -1.37,-0.44 -2.05,-0.66 -0.57,0.18 -0.91,0.84 -1.58,0.89 -0.53,0.35 -0.74,-0.61 -1.32,-0.23 -1.04,0.24 -1.91,0.81 -2.69,1.46 -0.31,-0.01 -0.35,-0.74 -0.79,-0.82 -0.69,-0.36 -1.55,0.33 -2.24,0 0.14,-0.95 -1.21,-1.63 -0.83,-2.52 0.59,-0.31 0.08,-0.93 -0.43,-0.82 -0.8,-0.41 -1.56,-0.95 -2.48,-0.98 -0.71,-0.57 -1.65,-0.92 -2.5,-1.13 -0.75,-0.5 -0.63,-1.08 0.15,-1.48 0.57,-0.29 0.6,-1.22 -0.15,-1.21 -0.8,0.08 -1.18,1.42 -2.13,0.91 -0.91,-0.18 -1.33,-0.99 -1.96,-1.53 -0.95,-0.47 -1.83,-1.14 -2.84,-1.44 -1.26,-0.23 -2.4,0.34 -3.45,0.92 -0.87,0.14 -1.63,0.69 -2.45,0.86 -1.25,-0.51 -1.52,-2.38 -3.06,-2.35 -0.16,-0.02 -0.32,-0.01 -0.49,-0.01 z",
					    "department-02" : "m 105.47,20.48 c -0.68,0.17 -1.42,0.62 -1.19,1.42 -0.06,0.73 -1.06,0 -1.46,0.47 -0.48,0.44 -0.97,0.31 -1.19,-0.3 -0.69,-0.55 -1.62,-1.39 -2.56,-1.11 -0.5,0.44 -0.9,1.01 -1.55,1.16 -0.64,0.45 -0.89,1.41 -1.85,1 -1.81,0.16 -3.33,-1.1 -5.13,-0.92 -0.76,0.15 -0.78,1.35 -1.71,1.09 -0.71,-0.07 -1.71,0.28 -2.27,-0.25 -0.28,-0.67 -1.38,-0.42 -1.97,-0.43 -0.77,0.22 -1.43,0.77 -2.22,0.97 -0.49,0.25 -1.34,1.06 -0.48,1.42 0.36,0.3 1.33,-0.19 1.28,0.54 -0.51,0.74 -1.87,1.04 -1.57,2.2 -0.51,0.65 -1.53,0.94 -1.74,1.88 -0.34,0.86 -0.19,1.84 -0.49,2.68 -0.84,0.53 -1.8,1.27 -1.55,2.39 -0.18,0.5 -1.45,0.76 -0.84,1.39 0.38,0.15 1.01,0 0.89,0.64 0.07,0.64 0.32,1.52 -0.45,1.83 -0.64,0.44 -0.25,1.35 0.5,1.28 0.42,0.01 0.84,0.1 0.58,0.59 -0.09,1.55 1.36,2.69 1.17,4.28 -0.14,0.5 -0.23,1 0.1,1.44 0.13,0.38 0.04,0.76 -0.44,0.63 -0.89,0.18 -0.26,1.1 -0.08,1.58 0.22,0.73 -1.31,0.9 -0.48,1.49 0.68,0.73 1.42,1.63 1.57,2.64 -0.33,0.19 -0.64,0.53 -0.29,0.92 0.27,0.56 0.08,1.15 -0.14,1.65 0.22,0.66 -0.49,1.2 -1.09,1.21 -0.55,0.72 0.73,1.27 0.79,2.01 0.22,0.48 -0.23,0.7 -0.51,0.92 0.18,0.76 1.35,0.82 1.91,1.27 0.69,0.14 0.74,1.26 -0.07,1.21 -0.71,0.28 -1.46,0.37 -2.1,-0.08 -0.65,0.24 -0.25,1.31 -0.4,1.86 -0.04,0.91 0.14,1.98 -0.6,2.66 -0.24,0.61 -0.22,1.33 -0.89,1.71 -0.63,0.49 -1.22,1.61 -2.03,0.73 -0.8,-0.56 -1.94,0.11 -2.3,0.85 0.18,0.4 0.52,0.71 0.59,1.16 0.32,0.61 0.91,0.75 1.51,0.79 0.49,0.11 1.25,0.38 0.79,1 -0.35,1.09 0.39,2.22 0.23,3.27 -0.69,0.25 -0.56,1.12 0.16,1.14 0.97,-0.19 1.45,1.27 2.35,1.35 0.29,-0.24 0.52,-0.84 0.92,-0.31 0.27,0.67 -0.15,1.79 0.86,1.97 0.31,0.1 0.75,0.37 0.31,0.66 -0.5,0.57 -1.13,1.19 -1.88,1.27 -0.04,0.56 -1,0.92 -0.68,1.39 1.17,0.27 2.38,0.31 3.47,0.79 0.6,0.02 0.07,0.94 0.4,1.28 0.41,0.62 0.71,1.28 1.02,1.93 0.38,0.48 -0.54,0.86 -0.51,1.37 -0.5,0.29 -0.71,1.04 -0.05,1.31 0.98,0.32 1.94,1.05 2.44,1.92 0.22,0.41 0.88,0.27 0.99,0.85 0.47,0.59 0.38,2.16 1.46,1.91 0.41,-0.05 0.98,-0.86 1.19,-0.14 0.25,0.73 0.25,1.91 1.09,2.2 0.62,-0.15 1.11,-0.73 1.52,-1.08 0.75,0.68 0.03,1.92 0.73,2.67 -0.05,0.6 0.49,0.83 1.02,0.72 -0.13,0.66 0.61,0.52 1.01,0.64 0.56,0.21 1.4,0.42 1.14,1.2 0.21,0.86 0.82,-0.17 1.15,-0.35 0.68,-0.15 -0.09,-1.17 0.77,-1.19 0.88,-0.69 0.63,-2.26 1.74,-2.75 0.68,-0.27 2.01,-0.04 1.88,-1.17 -0.11,-0.92 1.42,-0.98 0.98,-1.98 0.1,-0.52 0.79,-0.38 1.13,-0.5 0.25,-0.87 0.48,-1.99 1.31,-2.48 0.66,0.08 1.56,-0.45 1.13,-1.2 -0.28,-1.05 -1.43,-1.2 -2.3,-0.84 -0.49,0.06 -1.76,0.48 -1.66,-0.42 -0.25,-1.22 1.03,-2.17 2.13,-2.19 0.58,-0.47 -0.45,-1.09 -0.41,-1.66 -0.09,-0.61 -0.64,-0.87 -0.97,-1.24 -0.24,-0.4 0.46,-0.34 0.34,-0.78 0.26,-0.51 0.29,-1.58 1.11,-1.35 0.83,0.16 1.66,-0.19 2.44,-0.21 0.64,0.66 1.34,0.69 2.02,0.03 0.56,-0.15 1.16,-1.27 0.39,-1.5 -0.86,0.35 -2.22,-0.36 -1.86,-1.39 -0.14,-0.53 -0.89,0.13 -1.05,-0.47 -0.36,-0.29 -1.21,-0.2 -1.06,-0.9 0.15,-0.52 1.15,-0.55 0.81,-1.27 -0.46,-0.78 -0.64,-1.63 -0.74,-2.5 -0.09,-0.46 0.14,-1.04 -0.41,-1.32 -0.64,-0.41 -0,-1.37 0.49,-1.63 1.12,-0.67 2.48,-0.76 3.64,-1.29 0.25,-0.39 0.54,-0.74 1.06,-0.7 1.14,-0.47 2.67,-0.93 3.68,0.01 0.5,0.39 0.93,-0.31 0.49,-0.7 -0.36,-0.4 0.54,-0.61 0.38,-1.11 0.7,-0.98 2.25,-0.87 2.96,-1.91 0.8,0.12 1.26,1.89 2.4,1.75 0.78,0.04 1.48,0.61 1.92,1.16 0.73,0.34 0.98,-0.54 0.86,-1.1 0.02,-1.06 0.83,-2.03 0.28,-3.09 -0.38,-0.56 -0.17,-1.34 0.54,-1.4 0.38,-0.69 -0.65,-1.32 -0.6,-2.05 0.05,-0.62 -0.29,-1.56 0.17,-2.02 0.6,-0.1 0.57,-1.08 1.22,-0.9 0.51,-0.54 0.08,-1.5 -0.68,-1.46 -0.57,-0.33 0.32,-0.96 0.54,-1.26 0.3,-0.57 -0.65,-0.94 -0.33,-1.58 0.15,-0.74 -0.84,-0.8 -1.06,-1.42 -0.46,-0.37 -0.6,-0.95 0,-1.21 0.11,-0.38 0.13,-0.92 0.7,-0.74 0.88,-0.06 1.96,0.68 2.77,0.16 0.52,-0.84 0.35,-2.02 0.76,-2.83 0.59,0.12 0.72,-0.42 0.94,-0.79 0.71,-0.37 1.61,-0.66 1.87,-1.5 0.47,-0.75 1.69,-0.87 1.68,-1.93 0.02,-0.57 1.14,-0.8 0.58,-1.39 -0.29,-0.69 -1.57,-0.3 -1.52,-1.15 0.44,-0.36 1.08,-0.92 0.48,-1.48 -0.39,-0.92 0.34,-1.94 0.67,-2.82 0.43,-0.55 0.85,-1.1 0.8,-1.86 -0.04,-0.59 0.51,-1.9 -0.44,-1.95 -1.12,-0.21 -1.32,-1.54 -0.8,-2.38 0.31,-0.44 0.46,-1.42 -0.36,-1.33 -1.01,0.12 -1.26,-1.35 -2.32,-1.15 -1.28,-0.26 -2.61,0.73 -3.8,0.17 -0.91,-1.14 -2.71,-0.14 -3.68,-1.14 -0.35,-0.19 -1.06,-0.02 -0.83,-0.65 -0.12,-0.84 0.75,-1.79 0.21,-2.54 -0.85,-0.21 -1.34,1.02 -2.24,0.79 -0.86,0.14 -1.56,1.01 -2.39,1.06 0,-0.38 -0.15,-0.82 -0.32,-1.09 -0.18,-0.69 -1.23,-0.63 -1.75,-1.03 -0.66,-0.08 -1.34,0.54 -1.91,-0.06 -0.48,-0.26 -1.03,0.1 -1.41,-0.36 -1.02,-0.03 -1.83,-1.04 -2.79,-1 -0.32,0.13 -0.63,0.25 -0.95,0.38 z"
					}
				}
			}
		}
	);
})(jQuery);