/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.utils.repository;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.stream.XMLStreamException;
import org.apache.felix.utils.repository.BaseRepository;
import org.apache.felix.utils.repository.StaxParser;
import org.apache.felix.utils.repository.UrlLoader;
import org.apache.felix.utils.resource.CapabilitySet;
import org.apache.felix.utils.resource.SimpleFilter;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class XmlRepository
extends BaseRepository {
    protected final String url;
    protected final long expiration;
    protected final Map<String, XmlLoader> loaders = new HashMap<String, XmlLoader>();
    protected final ReadWriteLock lock = new ReentrantReadWriteLock();

    public XmlRepository(String url, long expiration) {
        this.url = url;
        this.expiration = expiration;
    }

    @Override
    public List<Resource> getResources() {
        this.checkAndLoadCache();
        return super.getResources();
    }

    @Override
    public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) {
        this.checkAndLoadCache();
        return super.findProviders(requirements);
    }

    public String getUrl() {
        return this.url;
    }

    protected Map<String, XmlLoader> getLoaders() {
        return this.loaders;
    }

    @Override
    protected void addResource(Resource resource) {
        List identities = resource.getCapabilities("osgi.identity");
        if (identities.isEmpty()) {
            throw new IllegalStateException("Invalid resource: a capability with 'osgi.identity' namespace is required");
        }
        if (identities.size() > 1) {
            throw new IllegalStateException("Invalid resource: multiple 'osgi.identity' capabilities found");
        }
        Capability identity = (Capability)identities.get(0);
        Object name = identity.getAttributes().get("osgi.identity");
        Object type = identity.getAttributes().get("type");
        Object vers = identity.getAttributes().get("version");
        if (!(String.class.isInstance(name) && String.class.isInstance(type) && Version.class.isInstance(vers))) {
            throw new IllegalStateException("Invalid osgi.identity capability: " + identity);
        }
        if (!this.hasResource((String)type, (String)name, (Version)vers)) {
            super.addResource(resource);
        }
    }

    private boolean hasResource(String type, String name, Version version) {
        CapabilitySet set = (CapabilitySet)this.capSets.get("osgi.identity");
        if (set != null) {
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            attrs.put("type", type);
            attrs.put("osgi.identity", name);
            attrs.put("version", version);
            SimpleFilter sf = SimpleFilter.convert(attrs);
            return !set.match(sf, true).isEmpty();
        }
        return false;
    }

    protected void checkAndLoadCache() {
        if (this.checkAndLoadReferrals(this.url, Integer.MAX_VALUE)) {
            this.lock.writeLock().lock();
            try {
                this.resources.clear();
                this.capSets.clear();
                this.populate(this.loaders.get((Object)this.url).xml, Integer.MAX_VALUE);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    private void populate(StaxParser.XmlRepository xml, int hopCount) {
        if (hopCount > 0) {
            for (Resource resource : xml.resources) {
                this.addResource(resource);
            }
            for (StaxParser.Referral referral : xml.referrals) {
                this.populate(this.loaders.get((Object)referral.url).xml, Math.min(referral.depth, hopCount - 1));
            }
        }
    }

    private boolean checkAndLoadReferrals(String url, int hopCount) {
        boolean modified = false;
        if (hopCount > 0) {
            XmlLoader loader = this.loaders.get(url);
            if (loader == null) {
                loader = new XmlLoader(url, this.expiration);
                this.loaders.put(url, loader);
            }
            modified = loader.checkAndLoadCache();
            for (StaxParser.Referral referral : loader.xml.referrals) {
                modified |= this.checkAndLoadReferrals(referral.url, Math.min(referral.depth, hopCount - 1));
            }
        }
        return modified;
    }

    protected static class XmlLoader
    extends UrlLoader {
        protected StaxParser.XmlRepository xml;

        public XmlLoader(String url, long expiration) {
            super(url, expiration);
        }

        public XmlLoader(String url, long expiration, StaxParser.XmlRepository xml) {
            super(url, expiration);
            this.xml = xml;
        }

        @Override
        protected boolean doRead(InputStream is) throws IOException {
            try {
                StaxParser.XmlRepository oldXml = this.xml;
                this.xml = StaxParser.parse(URI.create(this.getUrl()), is, oldXml);
                return oldXml != this.xml;
            }
            catch (XMLStreamException e) {
                throw new IOException("Unable to read xml repository", e);
            }
        }
    }
}

