/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.client;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpUpgrader;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.client.Result;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.websocket.core.Behavior;
import org.eclipse.jetty.websocket.core.Configuration;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.ExtensionConfig;
import org.eclipse.jetty.websocket.core.ExtensionStack;
import org.eclipse.jetty.websocket.core.FrameHandler;
import org.eclipse.jetty.websocket.core.Negotiated;
import org.eclipse.jetty.websocket.core.WebSocketConnection;
import org.eclipse.jetty.websocket.core.WebSocketConstants;
import org.eclipse.jetty.websocket.core.WebSocketCoreSession;
import org.eclipse.jetty.websocket.core.client.UpgradeListener;
import org.eclipse.jetty.websocket.core.client.WebSocketCoreClient;
import org.eclipse.jetty.websocket.core.client.internal.HttpUpgraderOverHTTP;
import org.eclipse.jetty.websocket.core.client.internal.HttpUpgraderOverHTTP2;
import org.eclipse.jetty.websocket.core.exception.UpgradeException;
import org.eclipse.jetty.websocket.core.exception.WebSocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CoreClientUpgradeRequest
implements Response.CompleteListener,
HttpUpgrader.Factory {
    private static final Logger LOG = LoggerFactory.getLogger(CoreClientUpgradeRequest.class);
    private final Request request;
    private final CompletableFuture<CoreSession> futureCoreSession;
    private final WebSocketCoreClient wsClient;
    private FrameHandler frameHandler;
    private final Configuration.ConfigurationCustomizer customizer = new Configuration.ConfigurationCustomizer();
    private final List<UpgradeListener> upgradeListeners = new ArrayList<UpgradeListener>();
    private final AtomicBoolean notifyResponseListeners = new AtomicBoolean(false);
    private List<ExtensionConfig> requestedExtensions = new ArrayList<ExtensionConfig>();
    private boolean upgraded;

    public static CoreClientUpgradeRequest from(WebSocketCoreClient webSocketClient, URI requestURI, final FrameHandler frameHandler) {
        return new CoreClientUpgradeRequest(webSocketClient, requestURI){

            @Override
            public FrameHandler getFrameHandler() {
                return frameHandler;
            }
        };
    }

    public CoreClientUpgradeRequest(WebSocketCoreClient webSocketClient, URI requestURI) {
        if (!requestURI.isAbsolute()) {
            throw new IllegalArgumentException("WebSocket URI must be absolute");
        }
        if (StringUtil.isBlank((String)requestURI.getScheme())) {
            throw new IllegalArgumentException("WebSocket URI must include a scheme");
        }
        String scheme = requestURI.getScheme();
        if (!HttpScheme.WS.is(scheme) && !HttpScheme.WSS.is(scheme)) {
            throw new IllegalArgumentException("WebSocket URI scheme only supports [ws] and [wss], not [" + scheme + "]");
        }
        if (requestURI.getHost() == null) {
            throw new IllegalArgumentException("Invalid WebSocket URI: host not present");
        }
        this.request = webSocketClient.getHttpClient().newRequest(requestURI);
        this.request.attribute(HttpUpgrader.Factory.class.getName(), (Object)this);
        this.wsClient = webSocketClient;
        this.futureCoreSession = new CompletableFuture();
        this.futureCoreSession.whenComplete((session, throwable) -> {
            if (throwable != null) {
                this.request.abort(throwable);
            }
        });
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public URI getURI() {
        return this.request.getURI();
    }

    public HttpVersion getVersion() {
        return this.request.getVersion();
    }

    public void setVersion(HttpVersion httpVersion) {
        this.request.version(httpVersion);
    }

    public void listener(Request.Listener listener) {
        this.request.onRequestListener(listener);
    }

    public void headers(Consumer<HttpFields.Mutable> consumer) {
        this.request.headers(consumer);
    }

    public HttpFields getHeaders() {
        return this.request.getHeaders();
    }

    public List<HttpCookie> getCookies() {
        return this.request.getCookies();
    }

    public void timeout(long value, TimeUnit unit) {
        this.request.timeout(value, unit);
    }

    public void setConfiguration(Configuration.ConfigurationCustomizer config) {
        config.customize((Configuration)this.customizer);
    }

    public void addListener(UpgradeListener listener) {
        this.upgradeListeners.add(listener);
    }

    public void addExtensions(ExtensionConfig ... configs) {
        this.requestedExtensions.addAll(Arrays.asList(configs));
    }

    public void addExtensions(String ... configs) {
        for (String config : configs) {
            this.requestedExtensions.add(ExtensionConfig.parse((String)config));
        }
    }

    public List<ExtensionConfig> getExtensions() {
        return this.requestedExtensions;
    }

    public void setExtensions(List<ExtensionConfig> configs) {
        this.requestedExtensions = configs;
    }

    public List<String> getSubProtocols() {
        return this.request.getHeaders().getCSV(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL, true);
    }

    public void setSubProtocols(String ... protocols) {
        this.request.headers(headers -> {
            headers.remove(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL);
            for (String protocol : protocols) {
                headers.add(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL, protocol);
            }
        });
    }

    public void setSubProtocols(List<String> protocols) {
        this.request.headers(headers -> {
            headers.remove(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL);
            for (String protocol : protocols) {
                headers.add(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL, protocol);
            }
        });
    }

    public void send(Response.CompleteListener listener) {
        try {
            this.frameHandler = this.getFrameHandler();
            if (this.frameHandler == null) {
                throw new IllegalArgumentException("FrameHandler could not be created");
            }
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("FrameHandler could not be created", t);
        }
        this.request.send(listener);
    }

    public CompletableFuture<CoreSession> sendAsync() {
        this.send(this);
        return this.futureCoreSession;
    }

    public void onComplete(Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onComplete() - {}", (Object)result);
        }
        URI requestURI = result.getRequest().getURI();
        Request request = result.getRequest();
        Response response = result.getResponse();
        int status = response.getStatus();
        String responseLine = status + " " + response.getReason();
        boolean receivedResponse = status > 0;
        Throwable cause = result.getFailure();
        if (receivedResponse) {
            Throwable listenerError;
            if (this.upgraded) {
                return;
            }
            if (this.notifyResponseListeners.compareAndSet(false, true) && (listenerError = this.notifyUpgradeListeners(listener -> listener.onHandshakeResponse(request, response))) != null && LOG.isDebugEnabled()) {
                LOG.debug("Failure while notifying handshake response listeners", listenerError);
            }
            Throwable failure = cause != null ? (cause instanceof IOException || cause instanceof UpgradeException ? cause : new UpgradeException(requestURI, status, cause.getMessage(), cause)) : new UpgradeException(requestURI, status, "Failed to upgrade to websocket: Unexpected HTTP Response Status Code: " + responseLine);
            this.handleException(failure);
        } else {
            if (LOG.isDebugEnabled()) {
                if (result.getRequestFailure() != null) {
                    LOG.debug("Failed to upgrade to websocket: request failure", result.getRequestFailure());
                }
                if (result.getResponseFailure() != null) {
                    LOG.debug("Failed to upgrade to websocket: response failure", result.getResponseFailure());
                }
            }
            Throwable failure = cause instanceof IOException || cause instanceof UpgradeException ? cause : new UpgradeException(requestURI, cause);
            this.handleException(failure);
        }
    }

    protected void handleException(Throwable failure) {
        this.futureCoreSession.completeExceptionally(failure);
        if (this.frameHandler != null) {
            try {
                this.frameHandler.onError(failure, Callback.NOOP);
            }
            catch (Throwable t) {
                LOG.info("FrameHandler onError threw", t);
            }
        }
    }

    public HttpUpgrader newHttpUpgrader(HttpVersion version) {
        if (version == HttpVersion.HTTP_1_1) {
            return new HttpUpgraderOverHTTP(this);
        }
        if (version == HttpVersion.HTTP_2) {
            return new HttpUpgraderOverHTTP2(this);
        }
        throw new UnsupportedOperationException("Unsupported HTTP version for upgrade: " + String.valueOf(version));
    }

    protected void customize(EndPoint endPoint) {
    }

    public abstract FrameHandler getFrameHandler();

    public void requestComplete() {
        Throwable listenerError;
        String extensionString = this.requestedExtensions.stream().filter(ec -> !ec.getName().startsWith("@")).map(ExtensionConfig::getParameterizedNameWithoutInternalParams).collect(Collectors.joining(","));
        if (!StringUtil.isEmpty((String)extensionString)) {
            this.request.headers(headers -> headers.add(HttpHeader.SEC_WEBSOCKET_EXTENSIONS, extensionString));
        }
        if ((listenerError = this.notifyUpgradeListeners(listener -> listener.onHandshakeRequest(this.request))) != null) {
            this.request.abort(listenerError);
            return;
        }
        String extsAfterListener = String.join((CharSequence)",", this.request.getHeaders().getCSV(HttpHeader.SEC_WEBSOCKET_EXTENSIONS, true));
        if (!extensionString.equals(extsAfterListener)) {
            if (!this.requestedExtensions.isEmpty()) {
                this.request.abort((Throwable)new IllegalStateException("Extensions set in both the ClientUpgradeRequest and UpgradeListener"));
            }
            this.requestedExtensions = ExtensionConfig.parseList((String[])new String[]{extsAfterListener});
        }
    }

    private Throwable notifyUpgradeListeners(Consumer<UpgradeListener> action) {
        Throwable multiException = null;
        for (UpgradeListener listener : this.upgradeListeners) {
            try {
                action.accept(listener);
            }
            catch (Throwable t) {
                LOG.info("Exception while invoking listener {}", (Object)listener, (Object)t);
                multiException = ExceptionUtil.combine(multiException, (Throwable)t);
            }
        }
        return multiException;
    }

    public void upgrade(Response response, EndPoint endPoint) {
        Object[] values;
        String[] extValues;
        ArrayList<ExtensionConfig> negotiatedExtensions = new ArrayList<ExtensionConfig>();
        HttpField extField = response.getHeaders().getField(HttpHeader.SEC_WEBSOCKET_EXTENSIONS);
        if (extField != null && (extValues = extField.getValues()) != null) {
            for (String extVal : extValues) {
                Iterator i = QuotedStringTokenizer.CSV.tokenize(extVal);
                while (i.hasNext()) {
                    negotiatedExtensions.add(ExtensionConfig.parse((String)((String)i.next())));
                }
            }
        }
        ArrayList<ExtensionConfig> negotiatedWithInternal = new ArrayList<ExtensionConfig>(this.requestedExtensions);
        Iterator iterator = negotiatedWithInternal.iterator();
        while (iterator.hasNext()) {
            ExtensionConfig extConfig = (ExtensionConfig)iterator.next();
            if (extConfig.isInternalExtension()) continue;
            long negExtsCount = negotiatedExtensions.stream().filter(ec -> extConfig.getName().equals(ec.getName())).count();
            if (negExtsCount < 1L) {
                iterator.remove();
                continue;
            }
            long duplicateCount = negotiatedWithInternal.stream().filter(ec -> extConfig.getName().equals(ec.getName())).count();
            if (duplicateCount <= 1L) continue;
            iterator.remove();
        }
        for (ExtensionConfig config : negotiatedExtensions) {
            if (config.getName().startsWith("@")) continue;
            boolean wasRequested = false;
            for (ExtensionConfig requestedConfig : this.requestedExtensions) {
                if (!config.getName().equalsIgnoreCase(requestedConfig.getName())) continue;
                for (Map.Entry entry : requestedConfig.getInternalParameters()) {
                    config.setParameter((String)entry.getKey(), (String)entry.getValue());
                }
                wasRequested = true;
                break;
            }
            if (!wasRequested) {
                throw new WebSocketException("Upgrade failed: Sec-WebSocket-Extensions contained extension not requested");
            }
            long numExtsWithSameName = negotiatedExtensions.stream().filter(c -> config.getName().equalsIgnoreCase(c.getName())).count();
            if (numExtsWithSameName <= 1L) continue;
            throw new WebSocketException("Upgrade failed: Sec-WebSocket-Extensions contained more than one extension of the same name");
        }
        ExtensionStack extensionStack = new ExtensionStack(this.wsClient.getWebSocketComponents(), Behavior.CLIENT);
        extensionStack.negotiate(this.requestedExtensions, negotiatedWithInternal);
        Object negotiatedSubProtocol = null;
        HttpField subProtocolField = response.getHeaders().getField(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL);
        if (subProtocolField != null && (values = subProtocolField.getValues()) != null) {
            if (values.length > 1) {
                throw new WebSocketException("Upgrade failed: Too many WebSocket subprotocol's in response: " + Arrays.toString(values));
            }
            if (values.length == 1) {
                negotiatedSubProtocol = values[0];
            }
        }
        List<String> offeredSubProtocols = this.getSubProtocols();
        if (negotiatedSubProtocol != null && !offeredSubProtocols.contains(negotiatedSubProtocol)) {
            throw new WebSocketException("Upgrade failed: subprotocol [" + negotiatedSubProtocol + "] not found in offered subprotocols " + String.valueOf(offeredSubProtocols));
        }
        this.customize(endPoint);
        String scheme = this.request.getScheme();
        Negotiated negotiated = new Negotiated(this.request.getURI(), (String)negotiatedSubProtocol, HttpScheme.isSecure((String)scheme), extensionStack, WebSocketConstants.SPEC_VERSION_STRING);
        WebSocketCoreSession coreSession = new WebSocketCoreSession(this.frameHandler, Behavior.CLIENT, negotiated, this.wsClient.getWebSocketComponents());
        coreSession.setClassLoader(this.wsClient.getClassLoader());
        this.customizer.customize((Configuration)coreSession);
        HttpClient httpClient = this.wsClient.getHttpClient();
        ByteBufferPool bufferPool = this.wsClient.getWebSocketComponents().getByteBufferPool();
        WebSocketConnection wsConnection = new WebSocketConnection(endPoint, httpClient.getExecutor(), httpClient.getScheduler(), bufferPool, coreSession);
        coreSession.setWebSocketConnection(wsConnection);
        this.wsClient.getEventListeners().forEach(arg_0 -> ((WebSocketConnection)wsConnection).addEventListener(arg_0));
        if (!this.notifyResponseListeners.compareAndSet(false, true)) {
            throw new IllegalStateException("Already notified handshake response listeners");
        }
        Throwable listenerError = this.notifyUpgradeListeners(listener -> listener.onHandshakeResponse(this.request, response));
        if (listenerError != null) {
            throw new WebSocketException("onHandshakeResponse error", listenerError);
        }
        this.upgraded = true;
        try {
            endPoint.upgrade((Connection)wsConnection);
            if (!this.futureCoreSession.complete((CoreSession)coreSession)) {
                this.futureCoreSession.exceptionally(t -> {
                    coreSession.processConnectionError(t, Callback.NOOP);
                    return null;
                });
            }
        }
        catch (Throwable t2) {
            this.futureCoreSession.completeExceptionally(t2);
        }
    }
}

