untrusted comment: verify with openbsd-68-base.pub
RWQZj25CSG5R2lSfcopVLSE3lI0o/nay6qmKY8Ry2hq5J4d2N/7F5fQOCS2C/MzmAN+8iasjMGvAr2c13KZUqp1iAM95yhCzLAA=

OpenBSD 6.8 errata 002, October 29, 2020:

When generating the ICMP6 response to an IPv6 packet, the kernel
could use mbuf memory after freeing it.

Apply by doing:
    signify -Vep /etc/signify/openbsd-68-base.pub -x 002_icmp6.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/netinet/icmp6.h
===================================================================
RCS file: /cvs/src/sys/netinet/icmp6.h,v
retrieving revision 1.49
diff -u -p -r1.49 icmp6.h
--- sys/netinet/icmp6.h	1 Sep 2020 01:53:13 -0000	1.49
+++ sys/netinet/icmp6.h	27 Oct 2020 17:43:37 -0000
@@ -594,7 +594,7 @@ struct mbuf	*icmp6_do_error(struct mbuf 
 void		 icmp6_error(struct mbuf *, int, int, int);
 int		 icmp6_input(struct mbuf **, int *, int, int);
 void		 icmp6_fasttimo(void);
-int		 icmp6_reflect(struct mbuf *, size_t, struct sockaddr *);
+int		 icmp6_reflect(struct mbuf **, size_t, struct sockaddr *);
 void		 icmp6_prepare(struct mbuf *);
 void		 icmp6_redirect_input(struct mbuf *, int);
 void		 icmp6_redirect_output(struct mbuf *, struct rtentry *);
Index: sys/netinet6/icmp6.c
===================================================================
RCS file: /cvs/src/sys/netinet6/icmp6.c,v
retrieving revision 1.232
diff -u -p -r1.232 icmp6.c
--- sys/netinet6/icmp6.c	1 Sep 2020 01:53:13 -0000	1.232
+++ sys/netinet6/icmp6.c	27 Oct 2020 17:43:38 -0000
@@ -379,7 +379,7 @@ icmp6_error(struct mbuf *m, int type, in
 	n = icmp6_do_error(m, type, code, param);
 	if (n != NULL) {
 		/* header order: IPv6 - ICMPv6 */
-		if (!icmp6_reflect(n, sizeof(struct ip6_hdr), NULL))
+		if (!icmp6_reflect(&n, sizeof(struct ip6_hdr), NULL))
 			ip6_send(n);
 	}
 }                                                                    
@@ -609,7 +609,7 @@ icmp6_input(struct mbuf **mp, int *offp,
 			nicmp6->icmp6_code = 0;
 			icmp6stat_inc(icp6s_reflect);
 			icmp6stat_inc(icp6s_outhist + ICMP6_ECHO_REPLY);
-			if (!icmp6_reflect(n, noff, NULL))
+			if (!icmp6_reflect(&n, noff, NULL))
 				ip6_send(n);
 		}
 		if (!m)
@@ -1044,8 +1044,9 @@ icmp6_mtudisc_update(struct ip6ctlparam 
  * OFF points to the icmp6 header, counted from the top of the mbuf.
  */
 int
-icmp6_reflect(struct mbuf *m, size_t off, struct sockaddr *sa)
+icmp6_reflect(struct mbuf **mp, size_t off, struct sockaddr *sa)
 {
+	struct mbuf *m = *mp;
 	struct rtentry *rt = NULL;
 	struct ip6_hdr *ip6;
 	struct icmp6_hdr *icmp6;
@@ -1065,7 +1066,7 @@ icmp6_reflect(struct mbuf *m, size_t off
 	}
 
 	if (m->m_pkthdr.ph_loopcnt++ >= M_MAXLOOP) {
-		m_freem(m);
+		m_freemp(mp);
 		return (ELOOP);
 	}
 	rtableid = m->m_pkthdr.ph_rtableid;
@@ -1085,7 +1086,7 @@ icmp6_reflect(struct mbuf *m, size_t off
 		m_adj(m, l);
 		l = sizeof(struct ip6_hdr) + sizeof(struct icmp6_hdr);
 		if (m->m_len < l) {
-			if ((m = m_pullup(m, l)) == NULL)
+			if ((m = *mp = m_pullup(m, l)) == NULL)
 				return (EMSGSIZE);
 		}
 		memcpy(mtod(m, caddr_t), &nip6, sizeof(nip6));
@@ -1093,7 +1094,7 @@ icmp6_reflect(struct mbuf *m, size_t off
 		size_t l;
 		l = sizeof(struct ip6_hdr) + sizeof(struct icmp6_hdr);
 		if (m->m_len < l) {
-			if ((m = m_pullup(m, l)) == NULL)
+			if ((m = *mp = m_pullup(m, l)) == NULL)
 				return (EMSGSIZE);
 		}
 	}
@@ -1189,7 +1190,7 @@ icmp6_reflect(struct mbuf *m, size_t off
 	return (0);
 
  bad:
-	m_freem(m);
+	m_freemp(mp);
 	return (EHOSTUNREACH);
 }
 
