% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pMedian.r
\name{pMedian}
\alias{pMedian}
\title{pMedian}
\usage{
pMedian(x, na.rm = FALSE)
}
\arguments{
\item{x}{a numeric vector}

\item{na.rm}{set to \code{TRUE} to exclude \code{NA}s before computing the pseudomedian}
}
\value{
a scalar numeric value
}
\description{
Pseudomedian
}
\details{
Uses fast Fortran code to compute the pseudomedian of a numeric vector.  The pseudomedian is the median of all possible midpoints of two observations.  The pseudomedian is also called the Hodges-Lehmann one-sample estimator.  The Fortran code is was originally from JF Monahan, and was converted to C++ in the \code{DescTools} package.  It has been converted to Fortran 2018 here.
}
\examples{
x <- c(1:4, 10000)
pMedian(x)
# Compare with brute force calculation and with wilcox.test
w <- outer(x, x, '+')
median(w[lower.tri(w, diag=TRUE)]) / 2
wilcox.test(x, conf.int=TRUE)
}
\seealso{
\url{https://dl.acm.org/toc/toms/1984/10/3/}, \url{https://www4.stat.ncsu.edu/~monahan/jul10/}
}
