/*
 * JBoss, Home of Professional Open Source
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.config;

import org.jboss.cache.CacheException;

import java.util.ArrayList;
import java.util.List;

/**
 * An exception that represents an error in the configuration.  This could be a parsing error or a logical error involving clashing
 * configuration options or missing mandatory configuration elements.
 *
 * @author <a href="mailto:manik@jboss.org">Manik Surtani (manik@jboss.org)</a>
 * @see org.jboss.cache.config.Configuration
 * @see org.jboss.cache.CacheFactory
 */
public class ConfigurationException extends CacheException
{

   private static final long serialVersionUID = -5576382839360927955L;

   private List<String> erroneousAttributes = new ArrayList<String>();

   public ConfigurationException(Exception e)
   {
      super(e);
   }

   public ConfigurationException(String string)
   {
      super(string);
   }

   public ConfigurationException(String string, String erroneousAttribute)
   {
      super(string);
      erroneousAttributes.add(erroneousAttribute);
   }

   public ConfigurationException(String string, Throwable throwable)
   {
      super(string, throwable);
   }

   public List<String> getErroneousAttributes()
   {
      return erroneousAttributes;
   }

   public void addErroneousAttribute(String s)
   {
      erroneousAttributes.add(s);
   }
}
