/*
 * This file is part of the Ubuntu TV Media Scanner
 * Copyright (C) 2012-2013 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact: Jim Hodapp <jim.hodapp@canonical.com>
 * Authored by: Mathias Hasselmann <mathias@openismus.com>
 */
#include "mediascanner/glibutils.h"

// C++ Standard Library
#include <sstream>
#include <string>

namespace mediascanner {

std::string to_string(const GError *error) {
    std::ostringstream oss;

    if (error) {
        oss << g_quark_to_string(error->domain)
             << "(" << error->code << "): " << error->message;
    } else {
        oss << "Unknown error.";
    }

    return oss.str();
}

std::string to_string(const GstCaps *caps) {
    if (caps) {
        const std::string text = take(gst_caps_to_string(caps)).get();
        return "(caps: " + text + ")";
    }

    return "(caps: null)";
}


} // namespace mediascanner
