/*=========================================================================

   Program: ParaView
   Module:  pqScalarBarRepresentation.h

   Copyright (c) 2005-2008 Sandia Corporation, Kitware Inc.
   All rights reserved.

   ParaView is a free software; you can redistribute it and/or modify it
   under the terms of the ParaView license version 1.2.

   See License_v1.2.txt for the full ParaView license.
   A copy of this license can be obtained by contacting
   Kitware Inc.
   28 Corporate Drive
   Clifton Park, NY 12065
   USA

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/
#ifndef pqScalarBarRepresentation_h
#define pqScalarBarRepresentation_h

#include "pqRepresentation.h"

class pqPipelineRepresentation;
class pqScalarsToColors;
class vtkUndoElement;

/**
 * pqScalarBarRepresentation is created for "ScalarBarWidgetRepresentation"
 * proxies. The only reason why pqScalarBarRepresentation is used is to keep
 * create undo elements to aid with undo/redo for scalar bar interaction i.e.
 * if user drags the scalar-bar widget, we capture the entire operation in a
 * single undo-able action.
 */
class PQCORE_EXPORT pqScalarBarRepresentation : public pqRepresentation
{
  Q_OBJECT
  typedef pqRepresentation Superclass;

public:
  pqScalarBarRepresentation(const QString& group, const QString& name, vtkSMProxy* scalarbar,
    pqServer* server, QObject* parent = nullptr);
  ~pqScalarBarRepresentation() override;

protected Q_SLOTS:
  void startInteraction();
  void endInteraction();
};
#endif
