# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.monitor.aio import MonitorManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestMonitorManagementDiagnosticSettingsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(MonitorManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_diagnostic_settings_get(self, resource_group):
        response = await self.client.diagnostic_settings.get(
            resource_uri="str",
            name="str",
            api_version="2021-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_diagnostic_settings_create_or_update(self, resource_group):
        response = await self.client.diagnostic_settings.create_or_update(
            resource_uri="str",
            name="str",
            parameters={
                "eventHubAuthorizationRuleId": "str",
                "eventHubName": "str",
                "id": "str",
                "logAnalyticsDestinationType": "str",
                "logs": [
                    {
                        "enabled": bool,
                        "category": "str",
                        "categoryGroup": "str",
                        "retentionPolicy": {"days": 0, "enabled": bool},
                    }
                ],
                "marketplacePartnerId": "str",
                "metrics": [
                    {
                        "enabled": bool,
                        "category": "str",
                        "retentionPolicy": {"days": 0, "enabled": bool},
                        "timeGrain": "1 day, 0:00:00",
                    }
                ],
                "name": "str",
                "serviceBusRuleId": "str",
                "storageAccountId": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
                "workspaceId": "str",
            },
            api_version="2021-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_diagnostic_settings_delete(self, resource_group):
        response = await self.client.diagnostic_settings.delete(
            resource_uri="str",
            name="str",
            api_version="2021-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_diagnostic_settings_list(self, resource_group):
        response = self.client.diagnostic_settings.list(
            resource_uri="str",
            api_version="2021-05-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
