% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ard_statistics.R
\name{get_ard_statistics}
\alias{get_ard_statistics}
\title{ARD Statistics as List}
\usage{
get_ard_statistics(x, ..., .column = "stat", .attributes = NULL)
}
\arguments{
\item{x}{(\code{data.frame})\cr
an ARD data frame of class 'card'}

\item{...}{(\code{\link[rlang:dyn-dots]{dynamic-dots}})\cr
optional arguments indicating rows to subset of the ARD.
For example, to return only rows where the column \code{"AGEGR1"} is \code{"65-80"},
pass \code{AGEGR1 \%in\% "65-80"}.}

\item{.column}{(\code{string})\cr
string indicating the column that will be returned in the list.
Default is \code{"statistic"}}

\item{.attributes}{(\code{character})\cr
character vector of column names that will be returned
in the list as attributes.
Default is \code{NULL}}
}
\value{
named list
}
\description{
Returns the statistics from an ARD as a named list.
}
\examples{
ard <- ard_categorical(ADSL, by = "ARM", variables = "AGEGR1")

get_ard_statistics(
  ard,
  group1_level \%in\% "Placebo",
  variable_level \%in\% "65-80",
  .attributes = "stat_label"
)
}
